/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioState;
import agents.andySloane.SpriteState;

final class MarioMath {
    private static final FallDistance _fallDistance = new FallDistance();

    MarioMath() {
    }

    public static float stepsToJump(float h) {
        if (h < 26.6f) {
            return 10.0f * h / 133.0f;
        }
        if ((double)h < 64.6) {
            return (float)(17.0 - Math.sqrt(281.0f - 80.0f * h / 19.0f)) / 2.0f;
        }
        return MarioMath.stepsToJump(64.0f) + MarioMath.stepsToJump(h - 64.0f);
    }

    private static float secantSolve(DistanceFunction f, float distance, float dx0, float min) {
        float xdiff;
        float x0 = min;
        float x1 = min + 30.0f;
        do {
            float fx0 = f.value(dx0, x0);
            float fx1 = f.value(dx0, x1);
            xdiff = (fx1 - distance) * (x1 - x0) / (fx1 - fx0);
            x0 = x1;
            x1 -= xdiff;
        } while ((double)Math.abs(xdiff) > 1.0E-4);
        return x1;
    }

    public static float runDistance(float v0, float steps) {
        float d_n = (float)Math.pow(0.89f, steps);
        return (1320.0f * steps - 20.0f * (d_n - 1.0f) * (55.0f * v0 - 534.0f)) / 121.0f;
    }

    public static float fallDistance(float ya0, float steps) {
        float d_n = (float)Math.pow(0.85f, steps);
        return 20.0f * steps - 20.0f * (d_n - 1.0f) * (ya0 - 20.0f) / 3.0f;
    }

    public static float runSpeed(float xa0, float steps) {
        float d_n = (float)Math.pow(0.89f, steps);
        return -9.70909f * (d_n - 1.0f) + d_n * xa0;
    }

    public static float stepsToRun(float distance, float v0) {
        float xdiff;
        float x0 = 1.0f;
        float x1 = 2.0f;
        float sgn = 1.0f;
        int c = 0;
        if (distance < 0.0f) {
            sgn = -1.0f;
            distance = -distance;
        }
        do {
            float fx0 = MarioMath.runDistance(v0, x0);
            float fx1 = MarioMath.runDistance(v0, x1);
            xdiff = (fx1 - distance) * (x1 - x0) / (fx1 - fx0);
            x0 = x1;
            if (!((x1 -= xdiff) < 0.0f)) continue;
            x1 = -x1;
        } while (c++ < 1000 && (double)Math.abs(xdiff) > 1.0E-4);
        return x1 * sgn;
    }

    public static float stepsToFall(float height, float ya0) {
        if (height < 0.0f) {
            height = -height;
            ya0 = -ya0;
        }
        return MarioMath.secantSolve(_fallDistance, height, ya0, 0.0f);
    }

    public static float stepsToStomp(MarioState ms, SpriteState e) {
        float dx = MarioMath.stepsToRun(e.x - ms.x, ms.xa);
        float dy = 0.0f;
        if (e.y < ms.y) {
            if (ms.onGround) {
                dy = MarioMath.stepsToJump(ms.y - e.y);
            }
        } else if (e.y > ms.y) {
            dy = MarioMath.stepsToFall(e.y - ms.y, ms.ya);
        }
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static boolean canReachLedge(float x0, float xa, int apogeesteps, float apogeey, float x1, float y1) {
        float ya = 2.8045f;
        float nsteps = MarioMath.stepsToRun(x1 - x0, xa);
        float y = apogeey - MarioMath.fallDistance(ya, nsteps - (float)apogeesteps);
        return y <= y1;
    }

    private static class FallDistance
    implements DistanceFunction {
        private FallDistance() {
        }

        @Override
        public float value(float ya0, float steps) {
            return MarioMath.fallDistance(ya0, steps);
        }
    }

    static interface DistanceFunction {
        public float value(float var1, float var2);
    }
}

