/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioState;
import agents.andySloane.SpriteState;
import agents.andySloane.WorldState;

public class ShellState
extends SpriteState {
    public boolean carried = false;
    public boolean onGround = false;
    public boolean flyDeath = false;
    public static final float width = 4.0f;
    public static final float height = 12.0f;

    @Override
    public final float height() {
        return 12.0f;
    }

    @Override
    public SpriteState clone() {
        ShellState e = new ShellState(this.x, this.y, false);
        e.xa = this.xa;
        e.ya = this.ya;
        e.facing = this.facing;
        e.deadTime = this.deadTime;
        e.carried = this.carried;
        e.onGround = this.onGround;
        e.flyDeath = this.flyDeath;
        return e;
    }

    @Override
    public final boolean dead() {
        return this.deadTime != 0;
    }

    ShellState(float _x, float _y, boolean predicted) {
        this.x = _x;
        this.y = _y;
        this.type = 13;
        this.xa = 0.0f;
        this.ya = predicted ? -5.0f : -2.25f;
        this.facing = 0;
    }

    @Override
    public boolean move(WorldState ws) {
        if (this.carried) {
            ws.checkShellCollide(this);
            return false;
        }
        if (this.deadTime > 0) {
            --this.deadTime;
            if (this.deadTime == 0) {
                this.deadTime = 1;
                return false;
            }
            if (this.flyDeath) {
                this.x += this.xa;
                this.y += this.ya;
                this.ya = (float)((double)this.ya * 0.95);
                this.ya += 1.0f;
            }
            return true;
        }
        if (this.xa > 2.0f) {
            this.facing = 1;
        } else if (this.xa < -2.0f) {
            this.facing = -1;
        }
        if (this.facing != 0) {
            ws.checkShellCollide(this);
        }
        if (!this.move(this.xa, 0.0f, ws)) {
            this.facing = -this.facing;
        }
        this.onGround = false;
        this.move(0.0f, this.ya, ws);
        this.ya *= 0.85f;
        this.xa *= 0.89f;
        if (!this.onGround) {
            this.ya += 2.0f;
        }
        return true;
    }

    @Override
    public void resync(float x, float y, float prev_x, float prev_y) {
        this.x = x;
        this.y = y;
        this.xa = x - prev_x;
        this.facing = this.xa == 0.0f ? 0 : (this.xa < 0.0f ? -1 : 1);
        this.ya = (y - prev_y) * 0.85f;
        if (!this.onGround) {
            this.ya += 2.0f;
        }
    }

    private boolean move(float xa, float ya, WorldState ws) {
        while (xa > 8.0f) {
            if (!this.move(8.0f, 0.0f, ws)) {
                return false;
            }
            xa -= 8.0f;
        }
        while (xa < -8.0f) {
            if (!this.move(-8.0f, 0.0f, ws)) {
                return false;
            }
            xa += 8.0f;
        }
        while (ya > 8.0f) {
            if (!this.move(0.0f, 8.0f, ws)) {
                return false;
            }
            ya -= 8.0f;
        }
        while (ya < -8.0f) {
            if (!this.move(0.0f, -8.0f, ws)) {
                return false;
            }
            ya += 8.0f;
        }
        boolean collide = false;
        if (ya > 0.0f) {
            if (this.isBlocking(this.x + xa - 4.0f, this.y + ya, xa, 0.0f, ws)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + 4.0f, this.y + ya, xa, 0.0f, ws)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa - 4.0f, this.y + ya + 1.0f, xa, ya, ws)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + 4.0f, this.y + ya + 1.0f, xa, ya, ws)) {
                collide = true;
            }
        }
        if (ya < 0.0f) {
            if (this.isBlocking(this.x + xa, this.y + ya - 12.0f, xa, ya, ws)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa - 4.0f, this.y + ya - 12.0f, xa, ya, ws)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa + 4.0f, this.y + ya - 12.0f, xa, ya, ws)) {
                collide = true;
            }
        }
        if (xa > 0.0f) {
            if (this.isBlocking(this.x + xa + 4.0f, this.y + ya - 12.0f, xa, ya, ws)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + 4.0f, this.y + ya - 6.0f, xa, ya, ws)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + 4.0f, this.y + ya, xa, ya, ws)) {
                collide = true;
            }
        }
        if (xa < 0.0f) {
            if (this.isBlocking(this.x + xa - 4.0f, this.y + ya - 12.0f, xa, ya, ws)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - 4.0f, this.y + ya - 6.0f, xa, ya, ws)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - 4.0f, this.y + ya, xa, ya, ws)) {
                collide = true;
            }
        }
        if (collide) {
            if (xa < 0.0f) {
                this.x = (float)((int)((this.x - 4.0f) / 16.0f) * 16) + 4.0f;
                this.xa = 0.0f;
            }
            if (xa > 0.0f) {
                this.x = (float)((int)((this.x + 4.0f) / 16.0f + 1.0f) * 16) - 4.0f - 1.0f;
                this.xa = 0.0f;
            }
            if (ya < 0.0f) {
                this.y = (float)((int)((this.y - 12.0f) / 16.0f) * 16) + 12.0f;
                this.ya = 0.0f;
            }
            if (ya > 0.0f) {
                this.y = (int)(this.y / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += xa;
        this.y += ya;
        return true;
    }

    private boolean isBlocking(float _x, float _y, float xa, float ya, WorldState ws) {
        int x = (int)(_x / 16.0f);
        int y = (int)(_y / 16.0f);
        if (x == (int)(this.x / 16.0f) && y == (int)(this.y / 16.0f)) {
            return false;
        }
        return ws.isBlocking(x, y, xa, ya);
    }

    @Override
    public SpriteState stomp(WorldState ws, MarioState ms) {
        ShellState e = (ShellState)this.clone();
        if (this.facing != 0) {
            e.facing = 0;
            e.xa = 0.0f;
        } else {
            e.facing = ms.facing;
        }
        return e;
    }

    @Override
    public WorldState collideCheck(WorldState ws, MarioState ms) {
        if (this.deadTime != 0) {
            return ws;
        }
        float xMarioD = ms.x - this.x;
        float yMarioD = ms.y - this.y;
        float height = this.height();
        if (xMarioD > -12.0f && xMarioD < 12.0f && yMarioD > -height && yMarioD < ms.height()) {
            if (!(this.spiky() || !(ms.ya > 0.0f) || !(yMarioD <= 0.0f) || ms.onGround && ms.wasOnGround)) {
                ws = ws.stomp(this, ms);
            } else if (this.facing != 0) {
                ms.getHurt();
            } else {
                ws.kick(this);
                this.facing = ms.facing;
            }
        }
        return ws;
    }
}

