/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioState;
import agents.andySloane.ShellState;
import agents.andySloane.SpriteState;
import java.util.HashMap;
import java.util.Vector;

public final class WorldState {
    public int[][] map;
    public int[] heightmap;
    public int MapX;
    public int MapY;
    public Vector<SpriteState> enemies;
    public Vector<SpriteState> addqueue;
    WorldState pred = null;
    HashMap<WSHashKey, WorldState> succ;

    public WorldState(int[][] _map, MarioState ms, float[] enemyPosition) {
        this.map = _map;
        this.MapX = (int)ms.x / 16 - 8;
        this.MapY = (int)ms.y / 16 - 8;
        this.succ = new HashMap();
        this.enemies = new Vector();
        this.buildHeightMap();
        this.syncEnemies(this, enemyPosition, ms);
    }

    WorldState() {
    }

    public WorldState clone() {
        WorldState w = new WorldState();
        w.map = this.map;
        w.MapX = this.MapX;
        w.MapY = this.MapY;
        w.heightmap = this.heightmap;
        w.succ = new HashMap();
        w.enemies = this.enemies;
        w.addqueue = this.addqueue;
        return w;
    }

    public WorldState step() {
        WSHashKey h = new WSHashKey();
        WorldState s = this.succ.get(h);
        if (s == null) {
            s = this.clone();
            s.enemies = (Vector)this.enemies.clone();
            s.stepEnemies();
            this.succ.put(h, s);
        }
        return s;
    }

    public void sync(WorldState prevws, int[][] _map, MarioState ms, float[] enemyPosition) {
        this.map = _map;
        this.MapX = (int)ms.x / 16 - 8;
        this.MapY = (int)ms.y / 16 - 8;
        this.buildHeightMap();
        this.succ.clear();
        this.syncEnemies(prevws, enemyPosition, ms);
    }

    void buildHeightMap() {
        this.heightmap = new int[16];
        for (int i = 0; i < 16; ++i) {
            int j;
            for (j = 15; j >= 0 && this.map[j][i] == 0; --j) {
            }
            if (j < 0 || j + this.MapY < 8) {
                this.heightmap[i] = 22;
                continue;
            }
            while (j >= 0 && this.map[j][i] != 0 && this.map[j][i] != 1) {
                --j;
            }
            this.heightmap[i] = j + 1;
        }
    }

    void _removeTile(WSHashKey h, int x, int y) {
        int[][] newmap = new int[16][16];
        for (int j = 0; j < 16; ++j) {
            for (int i = 0; i < 16; ++i) {
                newmap[i][j] = this.map[i][j];
            }
        }
        newmap[x][y] = 0;
        this.map = newmap;
    }

    public void syncEnemies(WorldState prevws, float[] enemyObs, MarioState ms) {
        EnemyObservation[] obs = new EnemyObservation[enemyObs.length / 3];
        for (int i = 0; i < enemyObs.length; i += 3) {
            obs[i / 3] = new EnemyObservation((int)enemyObs[i], enemyObs[i + 1], enemyObs[i + 2]);
        }
        Vector<SpriteState> newenemies = new Vector<SpriteState>(this.enemies.size() + 2);
        Vector<SpriteState> oldenemies = prevws.enemies;
        for (EnemyObservation eobs : obs) {
            SpriteState closest = null;
            float closestdist = Float.POSITIVE_INFINITY;
            int closest_idx = 0;
            for (int i = 0; i < this.enemies.size(); ++i) {
                SpriteState s = this.enemies.get(i);
                if (s.type != eobs.type) continue;
                float ex = s.x - eobs.x;
                float ey = s.y - eobs.y;
                float dist = ex * ex + ey * ey;
                if (closest != null && !(dist < closestdist)) continue;
                closest = s;
                closestdist = dist;
                closest_idx = i;
            }
            if (closest == null || closestdist > 64.0f) {
                closest = SpriteState.newEnemy(eobs.x, eobs.y, eobs.type, ms);
            } else if (closestdist != 0.0f) {
                if (closest_idx >= oldenemies.size()) {
                    closest = SpriteState.newEnemy(eobs.x, eobs.y, eobs.type, ms);
                } else {
                    SpriteState prev = oldenemies.get(closest_idx);
                    closest.resync(eobs.x, eobs.y, prev.x, prev.y);
                }
            }
            if (closest == null) continue;
            newenemies.add(closest);
        }
        this.enemies = newenemies;
    }

    public void stepEnemies() {
        for (int i = 0; i < this.enemies.size(); ++i) {
            SpriteState e = this.enemies.get(i).clone();
            boolean keep = e.move(this);
            if (keep) {
                this.enemies.set(i, e);
                continue;
            }
            this.enemies.remove(i);
            --i;
        }
    }

    public WorldState interact(MarioState ms, boolean verbose) {
        WorldState ws = this;
        ws.addqueue = new Vector();
        if (verbose) {
            System.out.printf("--interact\n", new Object[0]);
        }
        for (int i = 0; i < ws.enemies.size(); ++i) {
            ws = ws.enemies.get(i).collideCheck(ws, ms);
        }
        for (SpriteState s : ws.addqueue) {
            if (verbose) {
                System.out.printf("interact: new e t=%d xy=%f,%f xaya=%f,%f deadTime=%d\n", s.type, Float.valueOf(s.x), Float.valueOf(s.y), Float.valueOf(s.xa), Float.valueOf(s.ya), s.deadTime);
            }
            ws.enemies.add(s);
        }
        ws.addqueue = null;
        return ws;
    }

    public void addShell(float x, float y) {
        ShellState s = new ShellState(x, y, true);
        s.move(this);
        this.addqueue.add(s);
    }

    WorldState removeTile(int x, int y) {
        if ((x -= this.MapX) < 0 || x >= 16 || (y -= this.MapY) < 0 || y >= 16) {
            return this;
        }
        WSHashKey h = new WSHashKey(x * 16 + y);
        WorldState s = this.succ.get(h);
        if (s == null) {
            s = this.clone();
            s._removeTile(h, x, y);
            this.succ.put(h, s);
        }
        return s;
    }

    final int getBlock(int x, int y) {
        if ((x -= this.MapX) < 0 || x >= 16 || (y -= this.MapY) < 0 || y >= 16) {
            return 0;
        }
        return this.map[x][y];
    }

    final boolean isBlocking(int x, int y, float xa, float ya) {
        int block = this.getBlock(x, y);
        if (block == 1) {
            return false;
        }
        if (block == 34) {
            return false;
        }
        if (block == -11) {
            return ya > 0.0f;
        }
        return block != 0;
    }

    final WorldState stomp(SpriteState e, MarioState ms) {
        ms.stomp(e);
        WorldState ws = this.clone();
        ws.enemies = (Vector)this.enemies.clone();
        ws.enemies.set(ws.enemies.indexOf(e), e.stomp(this, ms));
        return ws;
    }

    final WorldState bump(int x, int y, boolean big) {
        if (big) {
            switch (this.getBlock(x, y)) {
                case 16: {
                    return this.removeTile(x, y);
                }
            }
        }
        return this;
    }

    final void checkShellCollide(ShellState s) {
    }

    final void kick(ShellState s) {
    }

    private static class EnemyObservation
    implements Comparable<EnemyObservation> {
        int type;
        float x;
        float y;

        EnemyObservation(int type, float x, float y) {
            this.type = type;
            this.x = x;
            this.y = y;
        }

        @Override
        public int compareTo(EnemyObservation b) {
            return this.x < b.x ? -1 : (this.x > b.x ? 1 : 0);
        }
    }

    private class WSHashKey {
        static final int MOD_NONE = 0;
        static final int MOD_REMOVETILE = 1;
        static final int MOD_STOMP = 2;
        public int modType = 0;
        public int modTile = 0;
        public SpriteState modEnemy = null;

        WSHashKey() {
            this.modType = 0;
        }

        WSHashKey(int _modTile) {
            this.modType = 1;
            this.modTile = _modTile;
        }

        public int hashCode() {
            switch (this.modType) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1 + this.modTile * 4;
                }
                case 2: {
                    return 2 + this.modEnemy.hashCode() * 4;
                }
            }
            return -1;
        }

        public boolean equals(Object _o) {
            WSHashKey o = (WSHashKey)_o;
            if (o.modType != this.modType) {
                return false;
            }
            if (o.modTile != this.modTile) {
                return false;
            }
            return o.modEnemy == this.modEnemy;
        }
    }
}

