/*
 * Decompiled with CFR 0.152.
 */
package agents.robinBaumgarten;

import agents.robinBaumgarten.SearchNode;
import engine.core.MarioForwardModel;
import engine.helper.GameStatus;
import engine.helper.MarioActions;
import java.util.ArrayList;

public class Helper {
    public static final int visitedListPenalty = 1500;
    public static final float maxMarioSpeed = 10.909091f;

    public static int getMarioDamage(MarioForwardModel model, MarioForwardModel prevModel) {
        int damage = 0;
        if (prevModel.getMarioMode() > model.getMarioMode()) {
            ++damage;
        }
        if (model.getGameStatus() == GameStatus.LOSE) {
            damage = model.getMarioFloatPos()[1] > model.getLevelFloatDimensions()[1] - 20.0f ? (damage += 5) : (damage += 2);
        }
        return damage;
    }

    public static String getActionString(boolean[] action) {
        String s = "";
        if (action[MarioActions.RIGHT.getValue()]) {
            s = s + "Forward ";
        }
        if (action[MarioActions.LEFT.getValue()]) {
            s = s + "Backward ";
        }
        if (action[MarioActions.SPEED.getValue()]) {
            s = s + "Speed ";
        }
        if (action[MarioActions.JUMP.getValue()]) {
            s = s + "Jump ";
        }
        if (action[MarioActions.DOWN.getValue()]) {
            s = s + "Duck";
        }
        if (s.length() == 0) {
            s = "[NONE]";
        }
        return s;
    }

    public static float[] estimateMaximumForwardMovement(float currentAccel, boolean[] action, int ticks) {
        float dist = 0.0f;
        float runningSpeed = action[MarioActions.SPEED.getValue()] ? 1.2f : 0.6f;
        int dir = 0;
        if (action[MarioActions.LEFT.getValue()]) {
            dir = -1;
        }
        if (action[MarioActions.RIGHT.getValue()]) {
            dir = 1;
        }
        for (int i = 0; i < ticks; ++i) {
            dist += (currentAccel += runningSpeed * (float)dir);
            currentAccel *= 0.89f;
        }
        float[] ret = new float[]{dist, currentAccel};
        return ret;
    }

    public static boolean[] createAction(boolean left, boolean right, boolean down, boolean jump, boolean speed) {
        boolean[] action = new boolean[5];
        action[MarioActions.DOWN.getValue()] = down;
        action[MarioActions.JUMP.getValue()] = jump;
        action[MarioActions.LEFT.getValue()] = left;
        action[MarioActions.RIGHT.getValue()] = right;
        action[MarioActions.SPEED.getValue()] = speed;
        return action;
    }

    public static boolean canJumpHigher(SearchNode node, boolean checkParent) {
        if (node.parentPos != null && checkParent && Helper.canJumpHigher(node.parentPos, false)) {
            return true;
        }
        return node.sceneSnapshot.mayMarioJump() || node.sceneSnapshot.getMarioCanJumpHigher();
    }

    public static ArrayList<boolean[]> createPossibleActions(SearchNode node) {
        ArrayList<boolean[]> possibleActions = new ArrayList<boolean[]>();
        if (Helper.canJumpHigher(node, true)) {
            possibleActions.add(Helper.createAction(false, false, false, true, false));
        }
        if (Helper.canJumpHigher(node, true)) {
            possibleActions.add(Helper.createAction(false, false, false, true, true));
        }
        possibleActions.add(Helper.createAction(false, true, false, false, true));
        if (Helper.canJumpHigher(node, true)) {
            possibleActions.add(Helper.createAction(false, true, false, true, true));
        }
        possibleActions.add(Helper.createAction(false, true, false, false, false));
        if (Helper.canJumpHigher(node, true)) {
            possibleActions.add(Helper.createAction(false, true, false, true, false));
        }
        possibleActions.add(Helper.createAction(true, false, false, false, false));
        if (Helper.canJumpHigher(node, true)) {
            possibleActions.add(Helper.createAction(true, false, false, true, false));
        }
        possibleActions.add(Helper.createAction(true, false, false, false, true));
        if (Helper.canJumpHigher(node, true)) {
            possibleActions.add(Helper.createAction(true, false, false, true, true));
        }
        return possibleActions;
    }
}

