/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import agents.spencerSchumann.EnemySimulator;
import agents.spencerSchumann.MarioState;
import agents.spencerSchumann.MovementPlanner;
import agents.spencerSchumann.PlanRunner;
import agents.spencerSchumann.Scene;
import agents.spencerSchumann.Tiles;
import engine.core.MarioAgent;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.MarioActions;

public class Agent
implements MarioAgent {
    private Tiles tiles;
    private MarioState mario;
    private EnemySimulator enemySim;
    private boolean manualOverride = false;
    private PlanRunner planRunner;

    @Override
    public void initialize(MarioForwardModel model, MarioTimer timer) {
        this.tiles = new Tiles();
        this.mario = new MarioState();
        this.planRunner = new PlanRunner();
        this.enemySim = new EnemySimulator();
    }

    @Override
    public boolean[] getActions(MarioForwardModel model, MarioTimer timer) {
        float[] marioPos = model.getMarioFloatPos();
        this.tiles.addObservation(model);
        int mx = (int)(marioPos[0] / 16.0f);
        int my = (int)(marioPos[1] / 16.0f);
        model.getClass();
        int n = mx - 16 / 2;
        model.getClass();
        int n2 = my - 16 / 2;
        model.getClass();
        model.getClass();
        int[][] scene = this.tiles.getScene(n, n2, 16, 16);
        this.mario.update(model);
        Scene sanitizedScene = new Scene(model, scene);
        this.enemySim.update(sanitizedScene);
        this.enemySim.update(model);
        boolean[] action = null;
        if (this.planRunner.isDone() || this.planRunner.isLastAction() || this.manualOverride) {
            MovementPlanner planner = new MovementPlanner(sanitizedScene, this.mario, this.enemySim.clone());
            PlanRunner plan = planner.planMovement();
            if (plan != null) {
                this.planRunner = plan;
            } else {
                action = new boolean[5];
                action[MarioActions.RIGHT.getValue()] = true;
                boolean bl = model.mayMarioJump() || !model.isMarioOnGround();
                action[MarioActions.JUMP.getValue()] = bl;
                action[MarioActions.SPEED.getValue()] = bl;
            }
        }
        if (action == null) {
            action = this.planRunner.nextAction();
        }
        return action;
    }

    @Override
    public String getAgentName() {
        return "SpencerShumannAgent";
    }
}

