/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import agents.spencerSchumann.Edge;
import agents.spencerSchumann.MarioState;
import agents.spencerSchumann.Scene;
import engine.helper.MarioActions;

public class MotionSimulator {
    private Scene scene;
    public MarioState mario;
    public boolean collision;
    private int ticks;
    public boolean leftWorldEdge = true;

    public MotionSimulator(Scene scene, MarioState mario) {
        this.scene = scene.clone();
        this.mario = mario.clone();
    }

    public void updateScene(Scene scene) {
        this.scene.update(scene);
    }

    private void handleHorizontalInput(boolean[] action) {
        float xSpeed;
        float f = xSpeed = action[MarioActions.SPEED.getValue()] ? 1.2f : 0.6f;
        if (action[MarioActions.LEFT.getValue()]) {
            this.mario.vx -= xSpeed;
        }
        if (action[MarioActions.RIGHT.getValue()]) {
            this.mario.vx += xSpeed;
        }
    }

    private void handleJumpInput(boolean[] action) {
        this.mario.vy *= 0.85f;
        if (!this.mario.onGround) {
            this.mario.vy += 3.0f;
        }
        if (!action[MarioActions.JUMP.getValue()]) {
            this.mario.jumpTime = 0;
            if (this.mario.onGround) {
                this.mario.mayJump = true;
            }
        }
        if (action[MarioActions.JUMP.getValue()]) {
            if (this.mario.jumpTime > 0) {
                this.mario.vy = -1.9f * (float)this.mario.jumpTime--;
            } else if (this.mario.mayJump) {
                this.mario.jumpTime = 7;
                this.mario.vy = -1.9f * (float)this.mario.jumpTime;
            }
            this.mario.mayJump = false;
        }
    }

    public void update(boolean[] action) {
        this.handleHorizontalInput(action);
        this.handleJumpInput(action);
        this.moveHorizontally();
        this.moveVertically();
        ++this.ticks;
    }

    private float goofyAdd(float a, float b) {
        while (b > 8.0f) {
            b -= 8.0f;
            a += 8.0f;
        }
        while (b < -8.0f) {
            b += 8.0f;
            a -= 8.0f;
        }
        return a + b;
    }

    private void moveHorizontally() {
        if (Math.abs(this.mario.vx) < 0.5f) {
            this.mario.vx = 0.0f;
        }
        float newX = this.goofyAdd(this.mario.x, this.mario.vx);
        for (Edge e : this.scene.walls) {
            if (!(e.y1 <= this.mario.y) || !(e.y2 >= this.mario.y - this.mario.height)) continue;
            if (this.mario.x + 4.0f <= e.x1 && e.x1 <= newX + 4.0f) {
                this.mario.x = e.x1 - 5.0f;
                this.mario.vx = 0.0f;
                this.collision = true;
                return;
            }
            if (!(newX - 4.0f <= e.x1) || !(e.x1 <= this.mario.x - 4.0f)) continue;
            this.mario.x = e.x1 + 4.0f;
            this.mario.vx = 0.0f;
            this.collision = true;
            return;
        }
        this.mario.x = newX;
        this.mario.vx *= 0.89f;
        if (this.leftWorldEdge && this.mario.x < 0.0f) {
            this.mario.x = 0.0f;
            this.mario.vx = 0.0f;
        }
    }

    private void moveVertically() {
        float newY = this.goofyAdd(this.mario.y, this.mario.vy);
        if (this.mario.vy >= 0.0f) {
            for (Edge e : this.scene.floors) {
                if (!(e.x1 < this.mario.x + 4.0f) || !(e.x2 > this.mario.x - 4.0f) || !(this.mario.y <= e.y1) || !(e.y1 - 1.0f <= newY)) continue;
                this.mario.y = e.y1 - 1.0f;
                this.mario.onGround = true;
                this.mario.jumpTime = 0;
                return;
            }
        } else if (this.mario.vy < 0.0f) {
            for (Edge e : this.scene.ceilings) {
                if (!(e.x1 < this.mario.x + 4.0f) || !(e.x2 > this.mario.x - 4.0f) || !(this.mario.y - this.mario.height >= e.y1) || !(e.y1 >= newY - this.mario.height)) continue;
                this.mario.y = e.y1 + this.mario.height;
                this.mario.vy = 0.0f;
                this.mario.jumpTime = 0;
                this.collision = true;
                return;
            }
        }
        this.mario.onGround = false;
        this.mario.mayJump = false;
        this.mario.y = newY;
    }

    public Scene getScene() {
        return this.scene;
    }

    public float getX() {
        return this.mario.x;
    }

    public void setX(float x) {
        this.mario.x = x;
    }

    public float getVX() {
        return this.mario.vx;
    }

    public float getY() {
        return this.mario.y;
    }

    public void setY(float y) {
        this.mario.y = y;
    }

    public int getTicks() {
        return this.ticks;
    }
}

