/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import agents.spencerSchumann.Edge;
import agents.spencerSchumann.Enemy;
import agents.spencerSchumann.EnemySimulator;
import agents.spencerSchumann.MarioState;
import agents.spencerSchumann.MotionSimulator;
import agents.spencerSchumann.PlanRunner;
import agents.spencerSchumann.Scene;
import engine.helper.MarioActions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class MovementPlanner {
    Scene scene;
    MarioState mario;
    EnemySimulator enemySim;
    Edge targetFloor;
    public float[] projectedX;
    public float[] projectedY;

    MovementPlanner(Scene scene, MarioState mario, EnemySimulator enemySim) {
        this.scene = scene;
        this.mario = mario;
        this.enemySim = enemySim;
    }

    private int flightTimeForJump(int jumpTime, float height) {
        Scene simScene = new Scene(0.0f, 0.0f);
        simScene.floors.add(new Edge(-10.0f, height, 10.0f, height));
        MarioState simMario = new MarioState();
        simMario.mayJump = true;
        simMario.onGround = true;
        MotionSimulator sim = new MotionSimulator(simScene, simMario);
        boolean[] jump = new boolean[5];
        jump[MarioActions.JUMP.getValue()] = true;
        for (int i = 0; i < jumpTime; ++i) {
            sim.update(jump);
        }
        boolean[] coast = new boolean[5];
        do {
            sim.update(coast);
            if (!sim.mario.onGround) continue;
            return sim.getTicks();
        } while (!(sim.mario.vy > 0.0f) || !(sim.mario.y > height));
        return -1;
    }

    private int ticksToPos(float pos) {
        Scene simScene = new Scene(0.0f, 0.0f);
        simScene.floors.add(new Edge(-1000.0f, 1.0f, pos, 1.0f));
        MarioState simMario = new MarioState();
        simMario.vx = this.mario.vx;
        MotionSimulator sim = new MotionSimulator(simScene, simMario);
        sim.leftWorldEdge = false;
        boolean[] run = new boolean[5];
        run[MarioActions.RIGHT.getValue()] = true;
        run[MarioActions.SPEED.getValue()] = true;
        do {
            sim.update(run);
        } while (!(sim.mario.x >= pos));
        return sim.getTicks();
    }

    private float posFromTicks(int ticks) {
        Scene simScene = new Scene(0.0f, 0.0f);
        simScene.floors.add(new Edge(-1000.0f, 1.0f, (float)ticks * 100.0f, 1.0f));
        MarioState simMario = new MarioState();
        simMario.vx = this.mario.vx;
        MotionSimulator sim = new MotionSimulator(simScene, simMario);
        sim.leftWorldEdge = false;
        boolean[] run = new boolean[5];
        run[MarioActions.RIGHT.getValue()] = true;
        run[MarioActions.SPEED.getValue()] = true;
        for (int i = 0; i < ticks; ++i) {
            sim.update(run);
        }
        return sim.mario.x;
    }

    private boolean checkPlan(PlanRunner plan, Edge targetFloor) {
        MotionSimulator sim = new MotionSimulator(this.scene, this.mario);
        this.projectedX = new float[plan.getLength() + 1];
        this.projectedY = new float[plan.getLength() + 1];
        this.targetFloor = targetFloor;
        EnemySimulator es = this.enemySim.clone();
        while (!plan.isDone()) {
            es.update(this.scene);
            sim.update(plan.nextAction());
            this.projectedX[plan.getIndex() - 1] = sim.mario.x;
            this.projectedY[plan.getIndex() - 1] = sim.mario.y;
            for (Enemy e : es.enemies) {
                if (!(sim.mario.x >= e.x - e.width / 2.0f - 4.0f) || !(sim.mario.x <= e.x + e.width / 2.0f + 4.0f) || !(sim.mario.y >= e.y - e.height) || !(sim.mario.y - sim.mario.height <= e.y)) continue;
                return false;
            }
        }
        plan.rewind();
        return sim.mario.x > targetFloor.x1 - 4.0f && sim.mario.x < targetFloor.x2 + 4.0f && sim.mario.y == targetFloor.y1 - 1.0f;
    }

    private PlanRunner planJump(Edge currentFloor, Edge targetFloor) {
        float ydiff = targetFloor.y1 - currentFloor.y1;
        float xdiff = targetFloor.x1 - this.mario.x + 4.0f;
        if (xdiff < 0.0f) {
            xdiff = targetFloor.x2 - this.mario.x - 3.0f;
        }
        int ticks = this.ticksToPos(xdiff);
        int flightTime = 0;
        for (int jumpTime = 0; jumpTime <= 7; ++jumpTime) {
            flightTime = this.flightTimeForJump(jumpTime, ydiff);
            if (flightTime < 0) continue;
            PlanRunner plan = new PlanRunner();
            if (ticks <= flightTime) {
                plan.addKey(MarioActions.SPEED.getValue());
                plan.addKey(MarioActions.JUMP.getValue(), 0, jumpTime);
                plan.addKey(MarioActions.RIGHT.getValue(), flightTime - ticks, ticks);
            } else {
                int timeUntilJump = ticks - flightTime + 1;
                float posUntilJump = this.posFromTicks(timeUntilJump);
                if (posUntilJump + this.mario.x >= currentFloor.x2 + 4.0f) continue;
                plan.addKey(MarioActions.SPEED.getValue());
                plan.addKey(MarioActions.RIGHT.getValue(), 0, ticks);
                plan.addKey(MarioActions.JUMP.getValue(), timeUntilJump, jumpTime);
            }
            if (!this.checkPlan(plan, targetFloor)) continue;
            return plan;
        }
        return null;
    }

    private ArrayList<Edge> findTargetFloors(Edge currentFloor) {
        ArrayList<Edge> targets = new ArrayList<Edge>();
        Collections.sort(this.scene.floors, new BestTarget());
        for (Edge e : this.scene.floors) {
            if (!(e.x2 > this.mario.x) || !(e.y1 + 64.0f >= currentFloor.y1)) continue;
            targets.add(e);
        }
        return targets;
    }

    private Edge findCurrentFloor() {
        for (Edge e : this.scene.floors) {
            if (this.mario.y != e.y1 - 1.0f || !(this.mario.x >= e.x1 - 4.0f) || !(this.mario.x <= e.x2 + 4.0f)) continue;
            return e;
        }
        return null;
    }

    public PlanRunner planMovement() {
        Edge currentFloor = this.findCurrentFloor();
        if (currentFloor == null) {
            return null;
        }
        ArrayList<Edge> targetFloors = this.findTargetFloors(currentFloor);
        if (!targetFloors.isEmpty()) {
            for (Edge target : targetFloors) {
                PlanRunner plan;
                if (target == currentFloor || null == (plan = this.planJump(currentFloor, target))) continue;
                return plan;
            }
        }
        return null;
    }

    public Edge getTargetFloor() {
        return this.targetFloor;
    }

    class BestTarget
    implements Comparator<Edge> {
        BestTarget() {
        }

        @Override
        public int compare(Edge o1, Edge o2) {
            if (o1.x2 > o2.x2) {
                return -1;
            }
            if (o1.x2 < o2.x2) {
                return 1;
            }
            if (o1.y1 > o2.y1) {
                return -1;
            }
            if (o1.y1 < o2.y1) {
                return 1;
            }
            return 0;
        }
    }
}

