/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import java.util.ArrayList;
import java.util.HashMap;

public class PlanRunner {
    private int index;
    private int maxTime = -1;
    private boolean[] action = new boolean[5];
    private HashMap<Integer, ArrayList<Event>> events = new HashMap();

    PlanRunner() {
        this.rewind();
    }

    public boolean isDone() {
        return this.index > this.maxTime;
    }

    public boolean isLastAction() {
        return this.index == this.maxTime;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.maxTime;
    }

    public void rewind() {
        this.index = 0;
    }

    public void addKey(int key) {
        this.addKey(key, 0);
    }

    public void addKey(int key, int timeStep) {
        this.addKeyEvent(key, timeStep, true);
    }

    public void addKey(int key, int timeStep, int duration) {
        this.addKeyEvent(key, timeStep, true);
        this.addKeyEvent(key, timeStep + duration, false);
    }

    private void addKeyEvent(int key, int timeStep, boolean pressed) {
        ArrayList<Event> keys = this.events.get(timeStep);
        if (keys == null) {
            keys = new ArrayList();
            this.events.put(timeStep, keys);
        }
        keys.add(new Event(key, pressed));
        this.maxTime = Math.max(this.maxTime, timeStep);
    }

    public boolean[] nextAction() {
        ArrayList<Event> keys = this.events.get(this.index);
        if (keys != null) {
            for (Event e : keys) {
                this.action[e.key] = e.pressed;
            }
        }
        ++this.index;
        return this.action;
    }

    private class Event {
        public int key;
        public boolean pressed;

        Event(int key, boolean pressed) {
            this.key = key;
            this.pressed = pressed;
        }
    }
}

