/*
 * Decompiled with CFR 0.152.
 */
package agents.trondEllingsen;

import engine.core.MarioAgent;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.MarioActions;

public class Agent
implements MarioAgent {
    private JumpType jumpType = JumpType.NONE;
    private int jumpCount = 0;
    private int jumpSize = -1;
    private float prevY = 0.0f;
    private boolean[] action;

    @Override
    public void initialize(MarioForwardModel model, MarioTimer timer) {
        this.action = new boolean[MarioActions.numberOfActions()];
        this.action[MarioActions.RIGHT.getValue()] = true;
        this.action[MarioActions.SPEED.getValue()] = true;
    }

    private int getWallHeight(int tileX, int tileY, int[][] levelScene) {
        int y = tileY + 1;
        int wallHeight = 0;
        while (y-- > 0 && levelScene[tileX + 1][y] != 0) {
            ++wallHeight;
        }
        return wallHeight;
    }

    private boolean dangerOfGap(int tileX, int tileY, int[][] levelScene) {
        for (int y = tileY + 1; y < levelScene[0].length; ++y) {
            if (levelScene[tileX + 1][y] == 0) continue;
            return false;
        }
        return true;
    }

    private boolean enemyInRange(MarioForwardModel e, Rectangle r) {
        for (int i = 0; i < e.getEnemiesFloatPos().length; i += 3) {
            if (!r.contains(e.getEnemiesFloatPos()[i + 1] - e.getMarioFloatPos()[0], e.getMarioFloatPos()[1] - e.getEnemiesFloatPos()[i + 2])) continue;
            return true;
        }
        return false;
    }

    private final void setJump(JumpType type, int size) {
        this.jumpType = type;
        this.jumpSize = size;
        this.jumpCount = 0;
    }

    @Override
    public boolean[] getActions(MarioForwardModel model, MarioTimer timer) {
        float marioSpeed = model.getMarioFloatVelocity()[0];
        boolean dangerOfEnemy = this.enemyInRange(model, new Rectangle(-13.0f, -57.0f, 105.0f, 87.0f));
        boolean dangerOfEnemyAbove = this.enemyInRange(model, new Rectangle(-28.0f, 28.0f, 58.0f, 45.0f));
        boolean dangerOfGap = this.dangerOfGap(model.getMarioScreenTilePos()[0], model.getMarioScreenTilePos()[1], model.getScreenSceneObservation());
        if ((model.isMarioOnGround() || model.mayMarioJump()) && !this.jumpType.equals((Object)JumpType.NONE)) {
            this.setJump(JumpType.NONE, -1);
        } else if (model.mayMarioJump()) {
            int wallHeight = this.getWallHeight(model.getMarioScreenTilePos()[0], model.getMarioScreenTilePos()[1], model.getScreenSceneObservation());
            if (dangerOfGap && marioSpeed > 0.0f) {
                this.setJump(JumpType.GAP, marioSpeed < 6.0f ? (int)(9.0f - marioSpeed) : 1);
            } else if (marioSpeed <= 1.0f && !dangerOfEnemyAbove && wallHeight > 0) {
                this.setJump(JumpType.WALL, wallHeight >= 4 ? wallHeight + 3 : wallHeight);
            } else if (!(!dangerOfEnemy || dangerOfEnemyAbove && marioSpeed > 2.0f)) {
                this.setJump(JumpType.ENEMY, 7);
            }
        } else {
            ++this.jumpCount;
        }
        boolean isFalling = this.prevY < model.getMarioFloatPos()[1] && this.jumpType.equals((Object)JumpType.NONE);
        this.action[MarioActions.LEFT.getValue()] = isFalling && (dangerOfEnemy && dangerOfEnemyAbove || dangerOfGap);
        this.action[MarioActions.RIGHT.getValue()] = !isFalling && (!dangerOfEnemyAbove || this.jumpType != JumpType.WALL);
        this.action[MarioActions.JUMP.getValue()] = !this.jumpType.equals((Object)JumpType.NONE) && this.jumpCount < this.jumpSize;
        this.action[MarioActions.SPEED.getValue()] = !this.jumpType.equals((Object)JumpType.ENEMY) || !this.action[MarioActions.SPEED.getValue()] || model.getMarioMode() != 2;
        this.prevY = model.getMarioFloatPos()[1];
        return this.action;
    }

    @Override
    public String getAgentName() {
        return "TrondEllingsen";
    }

    private class Rectangle {
        private float x;
        private float y;
        private float width;
        private float height;

        public Rectangle(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public boolean contains(float x, float y) {
            return x >= this.x && y >= this.y && x <= this.x + this.width && y <= this.y + this.height;
        }
    }

    private static enum JumpType {
        ENEMY,
        GAP,
        WALL,
        NONE;

    }
}

