/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.graphics.MarioImage;
import engine.helper.Assets;
import java.awt.Graphics;

public abstract class MarioEffect {
    public float x;
    public float y;
    public float xv;
    public float yv;
    public float xa;
    public float ya;
    public int life;
    public int startingIndex;
    protected MarioImage graphics;

    public MarioEffect(float x, float y, float xv, float yv, float xa, float ya, int startIndex, int life) {
        this.x = x;
        this.y = y;
        this.xv = xv;
        this.yv = yv;
        this.xa = xa;
        this.ya = ya;
        this.life = life;
        this.graphics = new MarioImage(Assets.particles, startIndex);
        this.graphics.width = 16;
        this.graphics.height = 16;
        this.graphics.originX = 8;
        this.graphics.originY = 8;
        this.startingIndex = startIndex;
    }

    public void render(Graphics og, float cameraX, float cameraY) {
        if (this.life <= 0) {
            return;
        }
        --this.life;
        this.x += this.xv;
        this.y += this.yv;
        this.xv += this.xa;
        this.yv += this.ya;
        this.graphics.render(og, (int)(this.x - cameraX), (int)(this.y - cameraY));
    }
}

