/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.core.MarioEvent;
import engine.core.MarioSprite;
import engine.core.MarioWorld;
import engine.helper.EventType;
import engine.helper.GameStatus;
import engine.helper.SpriteType;
import java.util.ArrayList;

public class MarioForwardModel {
    private static final int OBS_SCENE_SHIFT = 16;
    public static final int OBS_NONE = 0;
    public static final int OBS_UNDEF = -42;
    public static final int OBS_SOLID = 17;
    public static final int OBS_BRICK = 22;
    public static final int OBS_QUESTION_BLOCK = 24;
    public static final int OBS_COIN = 31;
    public static final int OBS_PYRAMID_SOLID = 18;
    public static final int OBS_PIPE_BODY_RIGHT = 37;
    public static final int OBS_PIPE_BODY_LEFT = 36;
    public static final int OBS_PIPE_TOP_RIGHT = 35;
    public static final int OBS_PIPE_TOP_LEFT = 34;
    public static final int OBS_USED_BLOCK = 30;
    public static final int OBS_BULLET_BILL_BODY = 21;
    public static final int OBS_BULLET_BILL_NECT = 20;
    public static final int OBS_BULLET_BILL_HEAD = 19;
    public static final int OBS_BACKGROUND = 63;
    public static final int OBS_PLATFORM_SINGLE = 59;
    public static final int OBS_PLATFORM_LEFT = 60;
    public static final int OBS_PLATFORM_RIGHT = 61;
    public static final int OBS_PLATFORM_CENTER = 62;
    public static final int OBS_PLATFORM = 59;
    public static final int OBS_CANNON = 19;
    public static final int OBS_PIPE = 34;
    public static final int OBS_SCENE_OBJECT = 100;
    public static final int OBS_FIREBALL = 16;
    public static final int OBS_GOOMBA = 2;
    public static final int OBS_GOOMBA_WINGED = 3;
    public static final int OBS_RED_KOOPA = 4;
    public static final int OBS_RED_KOOPA_WINGED = 5;
    public static final int OBS_GREEN_KOOPA = 6;
    public static final int OBS_GREEN_KOOPA_WINGED = 7;
    public static final int OBS_SPIKY = 8;
    public static final int OBS_SPIKY_WINGED = 9;
    public static final int OBS_BULLET_BILL = 10;
    public static final int OBS_ENEMY_FLOWER = 11;
    public static final int OBS_MUSHROOM = 12;
    public static final int OBS_FIRE_FLOWER = 13;
    public static final int OBS_SHELL = 14;
    public static final int OBS_LIFE_MUSHROOM = 15;
    public static final int OBS_STOMPABLE_ENEMY = 2;
    public static final int OBS_NONSTOMPABLE_ENEMY = 8;
    public static final int OBS_SPECIAL_ITEM = 12;
    public static final int OBS_ENEMY = 1;
    public final int obsGridWidth = 16;
    public final int obsGridHeight = 16;
    private MarioWorld world;
    private int fallKill;
    private int stompKill;
    private int fireKill;
    private int shellKill;
    private int mushrooms;
    private int flowers;
    private int breakBlock;

    public static int getSpriteTypeGeneralization(SpriteType sprite, int detail) {
        switch (detail) {
            case 0: {
                switch (sprite) {
                    case MARIO: {
                        return 0;
                    }
                }
                sprite.getValue();
            }
            case 1: {
                switch (sprite) {
                    case MARIO: {
                        return 0;
                    }
                    case FIREBALL: {
                        return 16;
                    }
                    case MUSHROOM: 
                    case FIRE_FLOWER: 
                    case LIFE_MUSHROOM: {
                        return 12;
                    }
                    case GOOMBA: 
                    case GOOMBA_WINGED: 
                    case RED_KOOPA: 
                    case RED_KOOPA_WINGED: 
                    case GREEN_KOOPA: 
                    case GREEN_KOOPA_WINGED: 
                    case BULLET_BILL: 
                    case SHELL: {
                        return 2;
                    }
                    case SPIKY: 
                    case SPIKY_WINGED: 
                    case ENEMY_FLOWER: {
                        return 8;
                    }
                }
                return 0;
            }
            case 2: {
                switch (sprite) {
                    case MARIO: 
                    case FIREBALL: 
                    case MUSHROOM: 
                    case FIRE_FLOWER: 
                    case LIFE_MUSHROOM: {
                        return 0;
                    }
                }
                return 1;
            }
        }
        return -42;
    }

    public static int getBlockValueGeneralization(int tile, int detail) {
        if (tile == 0) {
            return 0;
        }
        switch (detail) {
            case 0: {
                switch (tile) {
                    case 48: 
                    case 49: {
                        return 0;
                    }
                    case 6: 
                    case 7: 
                    case 50: 
                    case 51: {
                        return 22;
                    }
                    case 8: 
                    case 11: {
                        return 24;
                    }
                }
                return tile + 16;
            }
            case 1: {
                switch (tile) {
                    case 47: 
                    case 48: 
                    case 49: {
                        return 0;
                    }
                    case 1: 
                    case 2: 
                    case 14: {
                        return 17;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        return 19;
                    }
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: {
                        return 34;
                    }
                    case 6: 
                    case 7: 
                    case 50: 
                    case 51: {
                        return 22;
                    }
                    case 8: 
                    case 11: {
                        return 24;
                    }
                    case 15: {
                        return 31;
                    }
                    case 44: 
                    case 45: 
                    case 46: {
                        return 59;
                    }
                }
                return 0;
            }
            case 2: {
                switch (tile) {
                    case 47: 
                    case 48: 
                    case 49: {
                        return 0;
                    }
                }
                return 100;
            }
        }
        return -42;
    }

    public MarioForwardModel(MarioWorld world) {
        this.world = world;
    }

    public int getTotalCoins() {
        return this.world.level.totalCoins;
    }

    public MarioForwardModel clone() {
        MarioForwardModel model = new MarioForwardModel(this.world.clone());
        model.fallKill = this.fallKill;
        model.stompKill = this.stompKill;
        model.fireKill = this.fireKill;
        model.shellKill = this.shellKill;
        model.mushrooms = this.mushrooms;
        model.flowers = this.flowers;
        model.breakBlock = this.breakBlock;
        return model;
    }

    public void advance(boolean[] actions) {
        this.world.update(actions);
        for (MarioEvent e : this.world.lastFrameEvents) {
            if (e.getEventType() == EventType.FIRE_KILL.getValue()) {
                ++this.fireKill;
            }
            if (e.getEventType() == EventType.STOMP_KILL.getValue()) {
                ++this.stompKill;
            }
            if (e.getEventType() == EventType.FALL_KILL.getValue()) {
                ++this.fallKill;
            }
            if (e.getEventType() == EventType.SHELL_KILL.getValue()) {
                ++this.shellKill;
            }
            if (e.getEventType() == EventType.COLLECT.getValue()) {
                if (e.getEventParam() == SpriteType.FIRE_FLOWER.getValue()) {
                    ++this.flowers;
                }
                if (e.getEventParam() == SpriteType.MUSHROOM.getValue()) {
                    ++this.mushrooms;
                }
            }
            if (e.getEventType() != EventType.BUMP.getValue() || e.getEventParam() != 22 || e.getMarioState() <= 0) continue;
            ++this.breakBlock;
        }
    }

    public GameStatus getGameStatus() {
        return this.world.gameStatus;
    }

    public float getCompletionPercentage() {
        return this.world.mario.x / (float)(this.world.level.exitTileX * 16);
    }

    public float[] getLevelFloatDimensions() {
        return new float[]{this.world.level.width, this.world.level.height};
    }

    public int getRemainingTime() {
        return this.world.currentTimer;
    }

    public float[] getMarioFloatPos() {
        return new float[]{this.world.mario.x, this.world.mario.y};
    }

    public float[] getMarioFloatVelocity() {
        return new float[]{this.world.mario.xa, this.world.mario.ya};
    }

    public boolean getMarioCanJumpHigher() {
        return this.world.mario.jumpTime > 0;
    }

    public int getMarioMode() {
        int value = 0;
        if (this.world.mario.isLarge) {
            value = 1;
        }
        if (this.world.mario.isFire) {
            value = 2;
        }
        return value;
    }

    public boolean isMarioOnGround() {
        return this.world.mario.onGround;
    }

    public boolean mayMarioJump() {
        return this.world.mario.mayJump;
    }

    public float[] getEnemiesFloatPos() {
        ArrayList<MarioSprite> enemiesAlive = this.world.getEnemies();
        float[] enemyPos = new float[enemiesAlive.size() * 3];
        int i = 0;
        while (i < enemiesAlive.size()) {
            enemyPos[3 * i] = enemiesAlive.get((int)i).type.getValue();
            enemyPos[3 * i + 1] = enemiesAlive.get((int)i).x;
            enemyPos[3 * i + 2] = enemiesAlive.get((int)i).y;
            ++i;
        }
        return enemyPos;
    }

    public int getNumEnemiesRemain() {
        return this.world.getEnemiesRemain();
    }

    public int getKillsTotal() {
        return this.fallKill + this.fireKill + this.shellKill + this.stompKill;
    }

    public int getTotalEnemies() {
        return this.world.getTotalEnemies();
    }

    public int getKillsByFire() {
        return this.fireKill;
    }

    public int getKillsByStomp() {
        return this.stompKill;
    }

    public int getKillsByShell() {
        return this.shellKill;
    }

    public int getKillsByFall() {
        return this.fallKill;
    }

    public int getNumLives() {
        return this.world.lives;
    }

    public int getNumCollectedMushrooms() {
        return this.mushrooms;
    }

    public int getNumCollectedFireflower() {
        return this.flowers;
    }

    public int getNumCollectedCoins() {
        return this.world.coins;
    }

    public int getNumDestroyedBricks() {
        return this.breakBlock;
    }

    public int[] getMarioScreenTilePos() {
        return new int[]{(int)((this.world.mario.x - this.world.cameraX) / 16.0f), (int)(this.world.mario.y / 16.0f)};
    }

    public int[][] getScreenCompleteObservation() {
        return this.getScreenCompleteObservation(1, 0);
    }

    public int[][] getScreenEnemiesObservation() {
        return this.getScreenEnemiesObservation(0);
    }

    public int[][] getScreenSceneObservation() {
        return this.getScreenSceneObservation(1);
    }

    public int[][] getMarioCompleteObservation() {
        return this.getMarioCompleteObservation(1, 0);
    }

    public int[][] getMarioEnemiesObservation() {
        return this.getMarioEnemiesObservation(0);
    }

    public int[][] getMarioSceneObservation() {
        return this.getMarioSceneObservation(1);
    }

    public int[][] getScreenCompleteObservation(int sceneDetail, int enemyDetail) {
        return this.world.getMergedObservation(this.world.cameraX + 128.0f, 128.0f, sceneDetail, enemyDetail);
    }

    public int[][] getScreenEnemiesObservation(int detail) {
        return this.world.getEnemiesObservation(this.world.cameraX + 128.0f, 128.0f, detail);
    }

    public int[][] getScreenSceneObservation(int detail) {
        return this.world.getSceneObservation(this.world.cameraX + 128.0f, 128.0f, detail);
    }

    public int[][] getMarioCompleteObservation(int sceneDetail, int enemyDetail) {
        return this.world.getMergedObservation(this.world.mario.x, this.world.mario.y, sceneDetail, enemyDetail);
    }

    public int[][] getMarioEnemiesObservation(int detail) {
        return this.world.getEnemiesObservation(this.world.mario.x, this.world.mario.y, detail);
    }

    public int[][] getMarioSceneObservation(int detail) {
        return this.world.getSceneObservation(this.world.mario.x, this.world.mario.y, detail);
    }
}

