/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import agents.human.Agent;
import engine.core.MarioAgent;
import engine.core.MarioAgentEvent;
import engine.core.MarioEvent;
import engine.core.MarioForwardModel;
import engine.core.MarioRender;
import engine.core.MarioResult;
import engine.core.MarioTimer;
import engine.core.MarioWorld;
import engine.helper.GameStatus;
import engine.helper.MarioActions;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import javax.swing.JFrame;

public class MarioGame {
    public static final long maxTime = 40L;
    public static final long graceTime = 10L;
    public static final int width = 256;
    public static final int height = 256;
    public static final int tileWidth = 16;
    public static final int tileHeight = 16;
    public boolean verbose = false;
    public boolean pause = false;
    private MarioEvent[] killEvents;
    private int initialLives;
    private int segSize = 32;
    private int segTime = 0;
    private long segStart = 0L;
    private int segPassed = 0;
    private JFrame window = null;
    private MarioRender render = null;
    private MarioAgent agent = null;
    private MarioWorld world = null;

    public MarioGame() {
    }

    public MarioGame(MarioEvent[] killEvents) {
        this.killEvents = killEvents;
    }

    private int getDelay(int fps) {
        if (fps <= 0) {
            return 0;
        }
        return 1000 / fps;
    }

    private void setAgent(MarioAgent agent) {
        this.agent = agent;
        if (agent instanceof KeyAdapter) {
            this.render.addKeyListener((KeyAdapter)((Object)this.agent));
        }
    }

    public MarioResult playGame(String level, int timer) {
        return this.runGame(new Agent(), level, timer, 0, true, 30, 2.0f, 0L);
    }

    public MarioResult playGame(String level, int timer, int marioState) {
        return this.runGame(new Agent(), level, timer, marioState, true, 30, 2.0f, 0L);
    }

    public MarioResult playGame(String level, int timer, int marioState, int fps) {
        return this.runGame(new Agent(), level, timer, marioState, true, fps, 2.0f, 0L);
    }

    public MarioResult playGame(String level, int timer, int marioState, int fps, float scale) {
        return this.runGame(new Agent(), level, timer, marioState, true, fps, scale, 0L);
    }

    public MarioResult runGame(MarioAgent agent, String level, int timer) {
        return this.runGame(agent, level, timer, 0, false, 0, 2.0f, 0L);
    }

    public MarioResult runGame(MarioAgent agent, String level, int timer, int marioState) {
        return this.runGame(agent, level, timer, marioState, false, 0, 2.0f, 0L);
    }

    public MarioResult runGame(MarioAgent agent, String level, int timer, int marioState, boolean visuals) {
        return this.runGame(agent, level, timer, marioState, visuals, visuals ? 30 : 0, 2.0f, 0L);
    }

    public MarioResult runGame(MarioAgent agent, String level, int timer, int marioState, boolean visuals, int fps) {
        return this.runGame(agent, level, timer, marioState, visuals, fps, 2.0f, 0L);
    }

    public MarioResult runGame(MarioAgent agent, String level, int timer, int marioState, boolean visuals, int fps, float scale) {
        if (visuals) {
            this.window = new JFrame("Mario AI Framework");
            this.render = new MarioRender(scale);
            this.window.setContentPane(this.render);
            this.window.pack();
            this.window.setResizable(false);
            this.window.setDefaultCloseOperation(3);
            this.render.init();
            this.window.setVisible(true);
        }
        this.setAgent(agent);
        return this.runGame(agent, level, timer, marioState, visuals, fps, scale, 0L);
    }

    public MarioResult runGame(MarioAgent agent, String level, int timer, int marioState, boolean visuals, int fps, float scale, long realTimeLimitMs) {
        if (visuals) {
            this.window = new JFrame("Mario AI Framework");
            this.render = new MarioRender(scale);
            this.window.setContentPane(this.render);
            this.window.pack();
            this.window.setResizable(false);
            this.window.setDefaultCloseOperation(3);
            this.render.init();
            this.window.setVisible(true);
        }
        this.setAgent(agent);
        return this.gameLoop(level, timer, marioState, visuals, fps, realTimeLimitMs);
    }

    private MarioResult gameLoop(String level, int timer, int marioState, boolean visual, int fps, long realTimeLimitMs) {
        long startTimeMs;
        this.world = new MarioWorld(this.killEvents);
        this.world.lives = this.initialLives;
        this.world.visuals = visual;
        this.world.initializeLevel(level, 1000 * timer);
        if (visual) {
            this.world.initializeVisuals(this.render.getGraphicsConfiguration());
        }
        this.world.mario.isLarge = marioState > 0;
        this.world.mario.isFire = marioState > 1;
        this.world.update(new boolean[MarioActions.numberOfActions()]);
        long currentTime = System.currentTimeMillis();
        VolatileImage renderTarget = null;
        Graphics backBuffer = null;
        Graphics currentBuffer = null;
        if (visual) {
            renderTarget = this.render.createVolatileImage(256, 256);
            backBuffer = this.render.getGraphics();
            currentBuffer = renderTarget.getGraphics();
            this.render.addFocusListener(this.render);
        }
        MarioTimer agentTimer = new MarioTimer(40L);
        this.agent.initialize(new MarioForwardModel(this.world.clone()), agentTimer);
        ArrayList<MarioEvent> gameEvents = new ArrayList<MarioEvent>();
        ArrayList<MarioAgentEvent> agentEvents = new ArrayList<MarioAgentEvent>();
        this.segStart = startTimeMs = System.currentTimeMillis();
        while (this.world.gameStatus == GameStatus.RUNNING) {
            if (!this.pause) {
                agentTimer = new MarioTimer(40L);
                boolean[] actions = this.agent.getActions(new MarioForwardModel(this.world.clone()), agentTimer);
                this.world.update(actions);
                gameEvents.addAll(this.world.lastFrameEvents);
                agentEvents.add(new MarioAgentEvent(actions, this.world.mario.x, this.world.mario.y, (this.world.mario.isLarge ? 1 : 0) + (this.world.mario.isFire ? 1 : 0), this.world.mario.onGround, this.world.currentTick));
            }
            if (visual) {
                this.render.renderWorld(this.world, renderTarget, backBuffer, currentBuffer, this.verbose);
            }
            if (this.getDelay(fps) > 0) {
                try {
                    Thread.sleep(Math.max(0L, (currentTime += (long)this.getDelay(fps)) - System.currentTimeMillis()));
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            if (realTimeLimitMs > 0L && System.currentTimeMillis() - startTimeMs >= realTimeLimitMs) {
                this.world.gameStatus = GameStatus.TIME_OUT;
            }
            if (this.segTime <= 0) continue;
            if ((int)(this.world.mario.x / 16.0f / (float)this.segSize) > this.segPassed) {
                this.segPassed = (int)(this.world.mario.x / 16.0f / (float)this.segSize);
                this.segStart = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.segStart <= (long)this.segTime) continue;
            this.world.gameStatus = GameStatus.TIME_OUT;
        }
        return new MarioResult(this.world, gameEvents, agentEvents);
    }

    public void setSegwiseTimeouter(int segTimeCoefficient) {
        this.segTime = segTimeCoefficient * this.segSize;
    }

    public void setSegwiseTimeouter(int segSize, int segTimeCoefficient) {
        this.segSize = segSize;
        this.segTime = segTimeCoefficient * this.segSize;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setLives(int lives) {
        this.initialLives = lives;
    }
}

