/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.core.MarioAgentEvent;
import engine.core.MarioEvent;
import engine.core.MarioWorld;
import engine.helper.EventType;
import engine.helper.GameStatus;
import engine.helper.SpriteType;
import java.util.ArrayList;

public class MarioResult {
    private MarioWorld world;
    private ArrayList<MarioEvent> gameEvents;
    private ArrayList<MarioAgentEvent> agentEvents;

    public MarioResult(MarioWorld world, ArrayList<MarioEvent> gameEvents, ArrayList<MarioAgentEvent> agentEvents) {
        this.world = world;
        this.gameEvents = gameEvents;
        this.agentEvents = agentEvents;
    }

    public GameStatus getGameStatus() {
        return this.world.gameStatus;
    }

    public float getCompletionPercentage() {
        return this.world.mario.x / (float)(this.world.level.exitTileX * 16);
    }

    public int getRemainingTime() {
        return this.world.currentTimer;
    }

    public int getMarioMode() {
        int value = 0;
        if (this.world.mario.isLarge) {
            value = 1;
        }
        if (this.world.mario.isFire) {
            value = 2;
        }
        return value;
    }

    public ArrayList<MarioEvent> getGameEvents() {
        return this.gameEvents;
    }

    public ArrayList<MarioAgentEvent> getAgentEvents() {
        return this.agentEvents;
    }

    public int getKillsTotal() {
        int kills = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.STOMP_KILL.getValue() && e.getEventType() != EventType.FIRE_KILL.getValue() && e.getEventType() != EventType.FALL_KILL.getValue() && e.getEventType() != EventType.SHELL_KILL.getValue()) continue;
            ++kills;
        }
        return kills;
    }

    public int getKillsByFire() {
        int kills = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.FIRE_KILL.getValue()) continue;
            ++kills;
        }
        return kills;
    }

    public int getKillsByStomp() {
        int kills = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.STOMP_KILL.getValue()) continue;
            ++kills;
        }
        return kills;
    }

    public int getKillsByShell() {
        int kills = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.SHELL_KILL.getValue()) continue;
            ++kills;
        }
        return kills;
    }

    public int getMarioNumKills(int enemyType) {
        int kills = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.SHELL_KILL.getValue() && e.getEventType() != EventType.FIRE_KILL.getValue() && e.getEventType() != EventType.STOMP_KILL.getValue() || e.getEventParam() != enemyType) continue;
            ++kills;
        }
        return kills;
    }

    public int getMarioNumHurts() {
        int hurt = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.HURT.getValue()) continue;
            ++hurt;
        }
        return hurt;
    }

    public int getNumBumpQuestionBlock() {
        int bump = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.BUMP.getValue() || e.getEventParam() != 24) continue;
            ++bump;
        }
        return bump;
    }

    public int getNumBumpBrick() {
        int bump = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.BUMP.getValue() || e.getEventParam() != 22) continue;
            ++bump;
        }
        return bump;
    }

    public int getKillsByFall() {
        int kills = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.FALL_KILL.getValue()) continue;
            ++kills;
        }
        return kills;
    }

    public int getNumJumps() {
        int jumps = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.JUMP.getValue()) continue;
            ++jumps;
        }
        return jumps;
    }

    public float getMaxXJump() {
        float maxXJump = 0.0f;
        float startX = -100.0f;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() == EventType.JUMP.getValue()) {
                startX = e.getMarioX();
            }
            if (e.getEventType() != EventType.LAND.getValue() || !(Math.abs(e.getMarioX() - startX) > maxXJump)) continue;
            maxXJump = Math.abs(e.getMarioX() - startX);
        }
        return maxXJump;
    }

    public int getMaxJumpAirTime() {
        int maxAirJump = 0;
        int startTime = -100;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() == EventType.JUMP.getValue()) {
                startTime = e.getTime();
            }
            if (e.getEventType() != EventType.LAND.getValue() || e.getTime() - startTime <= maxAirJump) continue;
            maxAirJump = e.getTime() - startTime;
        }
        return maxAirJump;
    }

    public int getCurrentLives() {
        return this.world.lives;
    }

    public int getCurrentCoins() {
        return this.world.coins;
    }

    public int getNumCollectedMushrooms() {
        int collect = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.COLLECT.getValue() || e.getEventParam() != SpriteType.MUSHROOM.getValue()) continue;
            ++collect;
        }
        return collect;
    }

    public int getNumCollectedFireflower() {
        int collect = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.COLLECT.getValue() || e.getEventParam() != SpriteType.FIRE_FLOWER.getValue()) continue;
            ++collect;
        }
        return collect;
    }

    public int getNumCollectedTileCoins() {
        int collect = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.COLLECT.getValue() || e.getEventParam() != 31) continue;
            ++collect;
        }
        return collect;
    }

    public int getNumDestroyedBricks() {
        int bricks = 0;
        for (MarioEvent e : this.gameEvents) {
            if (e.getEventType() != EventType.BUMP.getValue() || e.getEventParam() != 22 || e.getMarioState() <= 0) continue;
            ++bricks;
        }
        return bricks;
    }
}

