/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.core.MarioEffect;
import engine.core.MarioEvent;
import engine.core.MarioForwardModel;
import engine.core.MarioLevel;
import engine.core.MarioSprite;
import engine.effects.BrickEffect;
import engine.effects.CoinEffect;
import engine.effects.FireballEffect;
import engine.graphics.MarioBackground;
import engine.helper.EventType;
import engine.helper.GameStatus;
import engine.helper.SpriteType;
import engine.helper.TileFeature;
import engine.sprites.BulletBill;
import engine.sprites.Enemy;
import engine.sprites.FireFlower;
import engine.sprites.Fireball;
import engine.sprites.FlowerEnemy;
import engine.sprites.LifeMushroom;
import engine.sprites.Mario;
import engine.sprites.Mushroom;
import engine.sprites.Shell;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.util.ArrayList;

public class MarioWorld {
    public static final int onlineTimerMax = 100000;
    public GameStatus gameStatus;
    public int pauseTimer = 0;
    public int fireballsOnScreen = 0;
    public int currentTimer = -1;
    public float cameraX;
    public float cameraY;
    public Mario mario;
    public MarioLevel level;
    public boolean visuals;
    public int currentTick;
    public int coins;
    public int lives;
    public int kills;
    public int deaths;
    public int jumps;
    public int items;
    public int airStart;
    public int airTime;
    public ArrayList<MarioEvent> lastFrameEvents;
    private MarioEvent[] killEvents;
    private ArrayList<MarioSprite> sprites;
    private ArrayList<Shell> shellsToCheck;
    private ArrayList<Fireball> fireballsToCheck;
    private ArrayList<MarioSprite> addedSprites;
    private ArrayList<MarioSprite> removedSprites;
    private ArrayList<MarioEffect> effects;
    private MarioBackground[] backgrounds = new MarioBackground[2];

    public MarioWorld(MarioEvent[] killEvents) {
        this.gameStatus = GameStatus.RUNNING;
        this.sprites = new ArrayList();
        this.shellsToCheck = new ArrayList();
        this.fireballsToCheck = new ArrayList();
        this.addedSprites = new ArrayList();
        this.removedSprites = new ArrayList();
        this.effects = new ArrayList();
        this.lastFrameEvents = new ArrayList();
        this.killEvents = killEvents;
        this.lives = 0;
        this.kills = 0;
        this.deaths = 0;
    }

    public void initializeVisuals(GraphicsConfiguration graphicsConfig) {
        int[][] tempBackground = new int[][]{{42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}, {42}};
        this.backgrounds[0] = new MarioBackground(graphicsConfig, 256, tempBackground);
        int[][] nArrayArray = new int[9][];
        nArrayArray[0] = new int[16];
        nArrayArray[1] = new int[16];
        int[] nArray = new int[16];
        nArray[0] = 31;
        nArray[1] = 32;
        nArray[2] = 33;
        nArrayArray[2] = nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = 34;
        nArray2[1] = 35;
        nArray2[2] = 36;
        nArrayArray[3] = nArray2;
        nArrayArray[4] = new int[16];
        int[] nArray3 = new int[16];
        nArray3[8] = 31;
        nArray3[9] = 32;
        nArray3[10] = 33;
        nArrayArray[5] = nArray3;
        int[] nArray4 = new int[16];
        nArray4[8] = 34;
        nArray4[9] = 35;
        nArray4[10] = 36;
        nArrayArray[6] = nArray4;
        nArrayArray[7] = new int[16];
        nArrayArray[8] = new int[16];
        tempBackground = nArrayArray;
        this.backgrounds[1] = new MarioBackground(graphicsConfig, 256, tempBackground);
    }

    public void initializeLevel(String level, int timer) {
        this.currentTimer = timer;
        this.level = new MarioLevel(level, this.visuals);
        this.mario = new Mario(this.visuals, (float)(this.level.marioTileX * 16), this.level.marioTileY * 16);
        this.mario.alive = true;
        this.mario.world = this;
        this.sprites.add(this.mario);
    }

    public int getTotalEnemies() {
        return this.level.totalEnemies;
    }

    public int getEnemiesRemain() {
        int n = 0;
        int x = (int)(this.mario.x / 16.0f) + 128;
        while (x < this.level.tileWidth) {
            n += this.level.enemyNumList.get(x).intValue();
            ++x;
        }
        return n;
    }

    public ArrayList<MarioSprite> getEnemies() {
        ArrayList<MarioSprite> enemies = new ArrayList<MarioSprite>();
        for (MarioSprite sprite : this.sprites) {
            if (!this.isEnemy(sprite)) continue;
            enemies.add(sprite);
        }
        return enemies;
    }

    public MarioWorld clone() {
        MarioWorld world = new MarioWorld(this.killEvents);
        world.visuals = false;
        world.cameraX = this.cameraX;
        world.cameraY = this.cameraY;
        world.fireballsOnScreen = this.fireballsOnScreen;
        world.gameStatus = this.gameStatus;
        world.pauseTimer = this.pauseTimer;
        world.currentTimer = this.currentTimer;
        world.currentTick = this.currentTick;
        world.level = this.level.clone();
        for (MarioSprite sprite : this.sprites) {
            MarioSprite cloneSprite = sprite.clone();
            cloneSprite.world = world;
            if (cloneSprite.type == SpriteType.MARIO) {
                world.mario = (Mario)cloneSprite;
            }
            world.sprites.add(cloneSprite);
        }
        if (world.mario == null) {
            world.mario = (Mario)this.mario.clone();
        }
        world.coins = this.coins;
        world.lives = this.lives;
        return world;
    }

    public void appendLevelSegment(String levelSegStr) {
        this.level.appendSegment(levelSegStr);
        this.currentTimer += 50 * levelSegStr.length();
        this.currentTimer = Math.min(this.currentTimer, 100000);
    }

    public void addEvent(EventType eventType, int eventParam) {
        int marioState = 0;
        if (this.mario.isLarge) {
            marioState = 1;
        }
        if (this.mario.isFire) {
            marioState = 2;
        }
        if (eventType == EventType.STOMP_KILL || eventType == EventType.FIRE_KILL || eventType == EventType.SHELL_KILL) {
            ++this.kills;
        }
        if (eventType == EventType.COLLECT && eventParam != 31) {
            ++this.items;
        }
        if (eventType == EventType.JUMP) {
            ++this.jumps;
            this.airStart = this.currentTick;
        }
        if (eventType == EventType.LAND) {
            this.airTime += this.currentTick - this.airStart;
        }
        this.lastFrameEvents.add(new MarioEvent(eventType, eventParam, this.mario.x, this.mario.y, marioState, this.currentTick));
    }

    public void addEffect(MarioEffect effect) {
        this.effects.add(effect);
    }

    public void addSprite(MarioSprite sprite) {
        this.addedSprites.add(sprite);
        sprite.alive = true;
        sprite.world = this;
        sprite.added();
        sprite.update();
    }

    public void removeSprite(MarioSprite sprite) {
        this.removedSprites.add(sprite);
        sprite.alive = false;
        sprite.removed();
        sprite.world = null;
    }

    public void checkShellCollide(Shell shell) {
        this.shellsToCheck.add(shell);
    }

    public void checkFireballCollide(Fireball fireball) {
        this.fireballsToCheck.add(fireball);
    }

    public void win() {
        this.addEvent(EventType.WIN, 0);
        this.gameStatus = GameStatus.WIN;
    }

    public void lose() {
        this.addEvent(EventType.LOSE, 0);
        this.gameStatus = GameStatus.LOSE;
        this.mario.alive = false;
    }

    public void timeout() {
        this.gameStatus = GameStatus.TIME_OUT;
        this.mario.alive = false;
    }

    public void revive() {
        int newTileY;
        int newTileX;
        block5: {
            newTileX = (int)this.mario.x / 16;
            newTileY = (int)this.mario.y / 16;
            try {
                while (true) {
                    int y = this.level.tileHeight - 2;
                    while (y >= 8) {
                        if (this.level.standable(newTileX, y)) {
                            newTileY = y;
                            break block5;
                        }
                        --y;
                    }
                    --newTileX;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.lose();
                return;
            }
        }
        this.mario.x = (float)((double)newTileX * 16.0 + 8.0);
        this.mario.y = (float)((double)newTileY * 16.0);
    }

    public int[][] getSceneObservation(float centerX, float centerY, int detail) {
        int[][] ret = new int[16][16];
        int centerXInMap = (int)centerX / 16;
        int centerYInMap = (int)centerY / 16;
        int y = centerYInMap - 8;
        int obsY = 0;
        while (y < centerYInMap + 8) {
            int x = centerXInMap - 8;
            int obsX = 0;
            while (x < centerXInMap + 8) {
                int currentY;
                int currentX = x;
                if (currentX < 0) {
                    currentX = 0;
                }
                if (currentX > this.level.tileWidth - 1) {
                    currentX = this.level.tileWidth - 1;
                }
                if ((currentY = y) < 0) {
                    currentY = 0;
                }
                if (currentY > this.level.tileHeight - 1) {
                    currentY = this.level.tileHeight - 1;
                }
                ret[obsX][obsY] = MarioForwardModel.getBlockValueGeneralization(this.level.getBlock(currentX, currentY), detail);
                ++x;
                ++obsX;
            }
            ++y;
            ++obsY;
        }
        return ret;
    }

    public int[][] getEnemiesObservation(float centerX, float centerY, int detail) {
        int[][] ret = new int[16][16];
        int centerXInMap = (int)centerX / 16;
        int centerYInMap = (int)centerY / 16;
        int w = 0;
        while (w < ret.length) {
            int h = 0;
            while (h < ret[0].length) {
                ret[w][h] = 0;
                ++h;
            }
            ++w;
        }
        for (MarioSprite sprite : this.sprites) {
            if (sprite.type == SpriteType.MARIO || sprite.getMapX() < 0 || sprite.getMapX() <= centerXInMap - 8 || sprite.getMapX() >= centerXInMap + 8 || sprite.getMapY() < 0 || sprite.getMapY() <= centerYInMap - 8 || sprite.getMapY() >= centerYInMap + 8) continue;
            int obsX = sprite.getMapX() - centerXInMap + 8;
            int obsY = sprite.getMapY() - centerYInMap + 8;
            ret[obsX][obsY] = MarioForwardModel.getSpriteTypeGeneralization(sprite.type, detail);
        }
        return ret;
    }

    public int[][] getMergedObservation(float centerX, float centerY, int sceneDetail, int enemiesDetail) {
        int[][] ret = new int[16][16];
        int centerXInMap = (int)centerX / 16;
        int centerYInMap = (int)centerY / 16;
        int y = centerYInMap - 8;
        int obsY = 0;
        while (y < centerYInMap + 8) {
            int x = centerXInMap - 8;
            int obsX = 0;
            while (x < centerXInMap + 8) {
                int currentY;
                int currentX = x;
                if (currentX < 0) {
                    currentX = 0;
                }
                if (currentX > this.level.tileWidth - 1) {
                    currentX = this.level.tileWidth - 1;
                }
                if ((currentY = y) < 0) {
                    currentY = 0;
                }
                if (currentY > this.level.tileHeight - 1) {
                    currentY = this.level.tileHeight - 1;
                }
                ret[obsX][obsY] = MarioForwardModel.getBlockValueGeneralization(this.level.getBlock(x, y), sceneDetail);
                ++x;
                ++obsX;
            }
            ++y;
            ++obsY;
        }
        for (MarioSprite sprite : this.sprites) {
            if (sprite.type == SpriteType.MARIO || sprite.getMapX() < 0 || sprite.getMapX() <= centerXInMap - 8 || sprite.getMapX() >= centerXInMap + 8 || sprite.getMapY() < 0 || sprite.getMapY() <= centerYInMap - 8 || sprite.getMapY() >= centerYInMap + 8) continue;
            int obsX = sprite.getMapX() - centerXInMap + 8;
            int obsY2 = sprite.getMapY() - centerYInMap + 8;
            int tmp = MarioForwardModel.getSpriteTypeGeneralization(sprite.type, enemiesDetail);
            if (tmp == SpriteType.NONE.getValue()) continue;
            ret[obsX][obsY2] = tmp;
        }
        return ret;
    }

    private boolean isEnemy(MarioSprite sprite) {
        return sprite instanceof Enemy || sprite instanceof FlowerEnemy || sprite instanceof BulletBill;
    }

    public void update(boolean[] actions) {
        if (this.gameStatus != GameStatus.RUNNING) {
            return;
        }
        if (this.pauseTimer > 0) {
            --this.pauseTimer;
            if (this.visuals) {
                this.mario.updateGraphics();
            }
            return;
        }
        if (this.currentTimer > 0) {
            this.currentTimer -= 30;
            if (this.currentTimer <= 0) {
                this.currentTimer = 0;
                this.timeout();
                return;
            }
        }
        ++this.currentTick;
        this.cameraX = this.mario.x - 128.0f;
        if (this.cameraX + 256.0f > (float)this.level.width) {
            this.cameraX = this.level.width - 256;
        }
        if (this.cameraX < 0.0f) {
            this.cameraX = 0.0f;
        }
        this.cameraY = this.mario.y - 128.0f;
        if (this.cameraY + 256.0f > (float)this.level.height) {
            this.cameraY = this.level.height - 256;
        }
        if (this.cameraY < 0.0f) {
            this.cameraY = 0.0f;
        }
        this.lastFrameEvents.clear();
        this.fireballsOnScreen = 0;
        for (MarioSprite sprite : this.sprites) {
            if (sprite.x < this.cameraX - 64.0f || sprite.x > this.cameraX + 256.0f + 64.0f || sprite.y > (float)(this.level.height + 32)) {
                if (sprite.type == SpriteType.MARIO) {
                    if (this.lives > 0) {
                        this.mario.getDrop();
                        this.revive();
                        continue;
                    }
                    this.lose();
                    continue;
                }
                this.removeSprite(sprite);
                if (!this.isEnemy(sprite) || !(sprite.y > 288.0f)) continue;
                this.addEvent(EventType.FALL_KILL, sprite.type.getValue());
                continue;
            }
            if (sprite.type != SpriteType.FIREBALL) continue;
            ++this.fireballsOnScreen;
        }
        this.level.update((int)this.cameraX, (int)this.cameraY);
        int x = (int)this.cameraX / 16 - 1;
        while (x <= (int)(this.cameraX + 256.0f) / 16 + 1) {
            int y = (int)this.cameraY / 16 - 1;
            while (y <= (int)(this.cameraY + 256.0f) / 16 + 1) {
                ArrayList<TileFeature> features;
                SpriteType type;
                int dir = 0;
                if ((float)(x * 16 + 8) > this.mario.x + 16.0f) {
                    dir = -1;
                }
                if ((float)(x * 16 + 8) < this.mario.x - 16.0f) {
                    dir = 1;
                }
                if ((type = this.level.getSpriteType(x, y)) != SpriteType.NONE) {
                    String spriteCode = this.level.getSpriteCode(x, y);
                    boolean found = false;
                    for (MarioSprite sprite : this.sprites) {
                        if (!sprite.initialCode.equals(spriteCode)) continue;
                        found = true;
                        break;
                    }
                    if (!found && this.level.getLastSpawnTick(x, y) != this.currentTick - 1) {
                        MarioSprite sprite;
                        sprite = type.spawnSprite(this.visuals, x, y, dir);
                        sprite.initialCode = spriteCode;
                        this.addSprite(sprite);
                    }
                    this.level.setLastSpawnTick(x, y, this.currentTick);
                }
                if (dir != 0 && (features = TileFeature.getTileType(this.level.getBlock(x, y))).contains((Object)TileFeature.SPAWNER) && this.currentTick % 100 == 0) {
                    this.addSprite(new BulletBill(this.visuals, x * 16 + 8 + dir * 8, y * 16 + 15, dir));
                }
                ++y;
            }
            ++x;
        }
        this.mario.actions = actions;
        for (MarioSprite sprite : this.sprites) {
            if (!sprite.alive) continue;
            sprite.update();
        }
        for (MarioSprite sprite : this.sprites) {
            if (!sprite.alive) continue;
            sprite.collideCheck();
        }
        for (Shell shell : this.shellsToCheck) {
            for (MarioSprite sprite : this.sprites) {
                if (sprite == shell || !shell.alive || !sprite.alive || !sprite.shellCollideCheck(shell)) continue;
                this.removeSprite(sprite);
            }
        }
        this.shellsToCheck.clear();
        for (Fireball fireball : this.fireballsToCheck) {
            for (MarioSprite sprite : this.sprites) {
                if (sprite == fireball || !fireball.alive || !sprite.alive || !sprite.fireballCollideCheck(fireball)) continue;
                if (this.visuals) {
                    this.addEffect(new FireballEffect(fireball.x, fireball.y));
                }
                this.removeSprite(fireball);
            }
        }
        this.fireballsToCheck.clear();
        this.sprites.addAll(0, this.addedSprites);
        this.sprites.removeAll(this.removedSprites);
        this.addedSprites.clear();
        this.removedSprites.clear();
        if (this.killEvents != null) {
            MarioEvent[] marioEventArray = this.killEvents;
            int n = this.killEvents.length;
            int n2 = 0;
            while (n2 < n) {
                MarioEvent k = marioEventArray[n2];
                if (this.lastFrameEvents.contains(k)) {
                    this.lose();
                }
                ++n2;
            }
        }
    }

    public void bump(int xTile, int yTile, boolean canBreakBricks) {
        int block = this.level.getBlock(xTile, yTile);
        ArrayList<TileFeature> features = TileFeature.getTileType(block);
        if (features.contains((Object)TileFeature.BUMPABLE)) {
            this.bumpInto(xTile, yTile - 1);
            this.addEvent(EventType.BUMP, 24);
            this.level.setBlock(xTile, yTile, 14);
            this.level.setShiftIndex(xTile, yTile, 4);
            if (features.contains((Object)TileFeature.SPECIAL)) {
                if (!this.mario.isLarge) {
                    this.addSprite(new Mushroom(this.visuals, (float)(xTile * 16 + 9), yTile * 16 + 8));
                } else {
                    this.addSprite(new FireFlower(this.visuals, (float)(xTile * 16 + 9), yTile * 16 + 8));
                }
            } else if (features.contains((Object)TileFeature.LIFE)) {
                this.addSprite(new LifeMushroom(this.visuals, (float)(xTile * 16 + 9), yTile * 16 + 8));
            } else {
                this.mario.collectCoin();
                if (this.visuals) {
                    this.addEffect(new CoinEffect(xTile * 16 + 8, yTile * 16));
                }
            }
        }
        if (features.contains((Object)TileFeature.BREAKABLE)) {
            this.bumpInto(xTile, yTile - 1);
            if (canBreakBricks) {
                this.addEvent(EventType.BUMP, 22);
                this.level.setBlock(xTile, yTile, 0);
                if (this.visuals) {
                    int xx = 0;
                    while (xx < 2) {
                        int yy = 0;
                        while (yy < 2) {
                            this.addEffect(new BrickEffect(xTile * 16 + xx * 8 + 4, yTile * 16 + yy * 8 + 4, (xx * 2 - 1) * 4, (yy * 2 - 1) * 4 - 8));
                            ++yy;
                        }
                        ++xx;
                    }
                }
            } else {
                this.level.setShiftIndex(xTile, yTile, 4);
            }
        }
    }

    public void bumpInto(int xTile, int yTile) {
        int block = this.level.getBlock(xTile, yTile);
        if (TileFeature.getTileType(block).contains((Object)TileFeature.PICKABLE)) {
            this.addEvent(EventType.COLLECT, block);
            this.mario.collectCoin();
            this.level.setBlock(xTile, yTile, 0);
            if (this.visuals) {
                this.addEffect(new CoinEffect(xTile * 16 + 8, yTile * 16 + 8));
            }
        }
        for (MarioSprite sprite : this.sprites) {
            sprite.bumpCheck(xTile, yTile);
        }
    }

    public void render(Graphics og) {
        int i = 0;
        while (i < this.backgrounds.length) {
            this.backgrounds[i].render(og, (int)this.cameraX, (int)this.cameraY);
            ++i;
        }
        for (MarioSprite sprite : this.sprites) {
            if (sprite.type != SpriteType.MUSHROOM && sprite.type != SpriteType.LIFE_MUSHROOM && sprite.type != SpriteType.FIRE_FLOWER && sprite.type != SpriteType.ENEMY_FLOWER) continue;
            sprite.render(og);
        }
        this.level.render(og, (int)this.cameraX, (int)this.cameraY);
        for (MarioSprite sprite : this.sprites) {
            if (sprite.type == SpriteType.MUSHROOM || sprite.type == SpriteType.LIFE_MUSHROOM || sprite.type == SpriteType.FIRE_FLOWER || sprite.type == SpriteType.ENEMY_FLOWER) continue;
            sprite.render(og);
        }
        i = 0;
        while (i < this.effects.size()) {
            if (this.effects.get((int)i).life <= 0) {
                this.effects.remove(i);
                --i;
            } else {
                this.effects.get(i).render(og, this.cameraX, this.cameraY);
            }
            ++i;
        }
    }
}

