/*
 * Decompiled with CFR 0.152.
 */
package engine.graphics;

import engine.graphics.MarioGraphics;
import engine.helper.TileFeature;
import java.awt.Graphics;
import java.awt.Image;
import java.util.ArrayList;

public class MarioTilemap
extends MarioGraphics {
    public Image[][] sheet;
    public ArrayList<int[]> currentIndeces;
    public ArrayList<int[]> indexShift;
    public ArrayList<float[]> moveShift;
    public int animationIndex;
    private int tileWidth;
    private final int tileHeight;

    public MarioTilemap(Image[][] sheet, ArrayList<int[]> currentIndeces) {
        this.sheet = sheet;
        this.currentIndeces = currentIndeces;
        this.indexShift = new ArrayList();
        this.moveShift = new ArrayList();
        this.tileWidth = currentIndeces.size();
        this.tileHeight = currentIndeces.get(0).length;
        int x = 0;
        while (x < this.tileWidth) {
            this.indexShift.add(new int[this.tileHeight]);
            this.moveShift.add(new float[this.tileHeight]);
            ++x;
        }
        this.animationIndex = 0;
    }

    @Override
    public void render(Graphics og, int x, int y) {
        this.update();
        this.animationIndex = (this.animationIndex + 1) % 5;
        int xMin = x / 16 - 1;
        int yMin = y / 16 - 1;
        int xMax = (x + 256) / 16 + 1;
        int yMax = (y + 256) / 16 + 1;
        int xTile = xMin;
        while (xTile <= xMax) {
            int yTile = yMin;
            while (yTile <= yMax) {
                if (xTile >= 0 && yTile >= 0 && xTile < this.tileWidth && yTile < this.tileHeight) {
                    ArrayList<TileFeature> features;
                    if (this.moveShift.get(xTile)[yTile] > 0.0f) {
                        float[] fArray = this.moveShift.get(xTile);
                        int n = yTile;
                        fArray[n] = fArray[n] - 1.0f;
                        if (this.moveShift.get(xTile)[yTile] < 0.0f) {
                            this.moveShift.get((int)xTile)[yTile] = 0.0f;
                        }
                    }
                    if ((features = TileFeature.getTileType(this.currentIndeces.get(xTile)[yTile])).contains((Object)TileFeature.ANIMATED)) {
                        if (this.animationIndex == 0) {
                            this.indexShift.get((int)xTile)[yTile] = (this.indexShift.get(xTile)[yTile] + 1) % 3;
                        }
                    } else {
                        this.indexShift.get((int)xTile)[yTile] = 0;
                    }
                    int index = this.currentIndeces.get(xTile)[yTile] + this.indexShift.get(xTile)[yTile];
                    int move = (int)this.moveShift.get(xTile)[yTile];
                    Image img = this.sheet[index % 8][index / 8];
                    og.drawImage(img, xTile * 16 - x, yTile * 16 - y - move, null);
                }
                ++yTile;
            }
            ++xTile;
        }
    }

    public void update() {
        int x0 = this.indexShift.size();
        this.tileWidth = this.currentIndeces.size();
        if (this.tileWidth == x0) {
            return;
        }
        int x = x0;
        while (x < this.tileWidth) {
            this.indexShift.add(new int[this.tileHeight]);
            this.moveShift.add(new float[this.tileHeight]);
            ++x;
        }
    }
}

