/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.effects.DeathEffect;
import engine.effects.SquishEffect;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.EventType;
import engine.helper.SpriteType;
import engine.sprites.Fireball;
import engine.sprites.Shell;
import java.awt.Graphics;

public class Enemy
extends MarioSprite {
    private static final float GROUND_INERTIA = 0.89f;
    private static final float AIR_INERTIA = 0.89f;
    protected boolean onGround = false;
    protected boolean avoidCliffs = true;
    protected boolean winged = true;
    protected boolean noFireballDeath;
    protected float runTime;
    protected int wingTime = 0;
    protected MarioImage wingGraphics;
    protected MarioImage graphics;

    public Enemy(boolean visuals, float x, float y, int dir, SpriteType type) {
        super(x, y, type);
        this.width = 4;
        this.height = 24;
        if (this.type != SpriteType.RED_KOOPA && this.type != SpriteType.GREEN_KOOPA && this.type != SpriteType.RED_KOOPA_WINGED && this.type != SpriteType.GREEN_KOOPA_WINGED) {
            this.height = 12;
        }
        this.winged = this.type.getValue() % 2 == 1;
        this.avoidCliffs = this.type == SpriteType.RED_KOOPA || this.type == SpriteType.RED_KOOPA_WINGED;
        this.noFireballDeath = this.type == SpriteType.SPIKY || this.type == SpriteType.SPIKY_WINGED;
        this.facing = dir;
        if (this.facing == 0) {
            this.facing = 1;
        }
        if (visuals) {
            this.graphics = new MarioImage(Assets.enemies, this.type.getStartIndex());
            this.graphics.originX = 8;
            this.graphics.originY = 31;
            this.graphics.width = 16;
            this.wingGraphics = new MarioImage(Assets.enemies, 32);
            this.wingGraphics.originX = 16;
            this.wingGraphics.originY = 31;
            this.wingGraphics.width = 16;
        }
    }

    @Override
    public MarioSprite clone() {
        Enemy e = new Enemy(false, this.x, this.y, this.facing, this.type);
        e.xa = this.xa;
        e.ya = this.ya;
        e.initialCode = this.initialCode;
        e.width = this.width;
        e.height = this.height;
        e.onGround = this.onGround;
        e.winged = this.winged;
        e.avoidCliffs = this.avoidCliffs;
        e.noFireballDeath = this.noFireballDeath;
        return e;
    }

    @Override
    public void collideCheck() {
        if (!this.alive) {
            return;
        }
        float xMarioD = this.world.mario.x - this.x;
        float yMarioD = this.world.mario.y - this.y;
        if (xMarioD > (float)(-this.width * 2 - 4) && xMarioD < (float)(this.width * 2 + 4) && yMarioD > (float)(-this.height) && yMarioD < (float)this.world.mario.height) {
            if (this.type != SpriteType.SPIKY && this.type != SpriteType.SPIKY_WINGED && this.type != SpriteType.ENEMY_FLOWER && this.world.mario.ya > 0.0f && yMarioD <= 0.0f && (!this.world.mario.onGround || !this.world.mario.wasOnGround)) {
                this.world.mario.stomp(this);
                if (this.winged) {
                    this.winged = false;
                    this.ya = 0.0f;
                } else {
                    if (this.type == SpriteType.GREEN_KOOPA || this.type == SpriteType.GREEN_KOOPA_WINGED) {
                        this.world.addSprite(new Shell(this.graphics != null, this.x, this.y, 1, this.initialCode));
                    } else if (this.type == SpriteType.RED_KOOPA || this.type == SpriteType.RED_KOOPA_WINGED) {
                        this.world.addSprite(new Shell(this.graphics != null, this.x, this.y, 0, this.initialCode));
                    } else if ((this.type == SpriteType.GOOMBA || this.type == SpriteType.GOOMBA_WINGED) && this.graphics != null) {
                        this.world.addEffect(new SquishEffect(this.x, this.y - 7.0f));
                    }
                    this.world.addEvent(EventType.STOMP_KILL, this.type.getValue());
                    this.world.removeSprite(this);
                }
            } else {
                this.world.addEvent(EventType.HURT, this.type.getValue());
                this.world.mario.getHurt();
            }
        }
    }

    private void updateGraphics() {
        ++this.wingTime;
        this.wingGraphics.index = 32 + this.wingTime / 4 % 2;
        this.graphics.flipX = this.facing == -1;
        this.runTime += Math.abs(this.xa) + 5.0f;
        int runFrame = (int)(this.runTime / 20.0f) % 2;
        if (!this.onGround) {
            runFrame = 1;
        }
        if (this.winged) {
            runFrame = this.wingTime / 4 % 2;
        }
        this.graphics.index = this.type.getStartIndex() + runFrame;
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        float sideWaysSpeed = 1.75f;
        if (this.xa > 2.0f) {
            this.facing = 1;
        }
        if (this.xa < -2.0f) {
            this.facing = -1;
        }
        this.xa = (float)this.facing * sideWaysSpeed;
        if (!this.move(this.xa, 0.0f)) {
            this.facing = -this.facing;
        }
        this.onGround = false;
        this.move(0.0f, this.ya);
        this.ya *= this.winged ? 0.95f : 0.85f;
        this.xa = this.onGround ? (this.xa *= 0.89f) : (this.xa *= 0.89f);
        if (!this.onGround) {
            this.ya = this.winged ? (this.ya += 0.6f) : (this.ya += 2.0f);
        } else if (this.winged) {
            this.ya = -10.0f;
        }
        if (this.graphics != null) {
            this.updateGraphics();
        }
    }

    private boolean move(float xa, float ya) {
        while (xa > 8.0f) {
            if (!this.move(8.0f, 0.0f)) {
                return false;
            }
            xa -= 8.0f;
        }
        while (xa < -8.0f) {
            if (!this.move(-8.0f, 0.0f)) {
                return false;
            }
            xa += 8.0f;
        }
        while (ya > 8.0f) {
            if (!this.move(0.0f, 8.0f)) {
                return false;
            }
            ya -= 8.0f;
        }
        while (ya < -8.0f) {
            if (!this.move(0.0f, -8.0f)) {
                return false;
            }
            ya += 8.0f;
        }
        boolean collide = false;
        if (ya > 0.0f) {
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya, xa, 0.0f)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya, xa, 0.0f)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya + 1.0f, xa, ya)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya + 1.0f, xa, ya)) {
                collide = true;
            }
        }
        if (ya < 0.0f) {
            if (this.isBlocking(this.x + xa, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
        }
        if (xa > 0.0f) {
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)(this.height / 2), xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya, xa, ya)) {
                collide = true;
            }
            if (this.avoidCliffs && this.onGround && !this.world.level.isBlocking((int)((this.x + xa + (float)this.width) / 16.0f), (int)(this.y / 16.0f + 1.0f), xa, 1.0f)) {
                collide = true;
            }
        }
        if (xa < 0.0f) {
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)(this.height / 2), xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya, xa, ya)) {
                collide = true;
            }
            if (this.avoidCliffs && this.onGround && !this.world.level.isBlocking((int)((this.x + xa - (float)this.width) / 16.0f), (int)(this.y / 16.0f + 1.0f), xa, 1.0f)) {
                collide = true;
            }
        }
        if (collide) {
            if (xa < 0.0f) {
                this.x = (int)((this.x - (float)this.width) / 16.0f) * 16 + this.width;
                this.xa = 0.0f;
            }
            if (xa > 0.0f) {
                this.x = (int)((this.x + (float)this.width) / 16.0f + 1.0f) * 16 - this.width - 1;
                this.xa = 0.0f;
            }
            if (ya < 0.0f) {
                this.y = (int)((this.y - (float)this.height) / 16.0f) * 16 + this.height;
                this.ya = 0.0f;
            }
            if (ya > 0.0f) {
                this.y = (int)(this.y / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += xa;
        this.y += ya;
        return true;
    }

    private boolean isBlocking(float _x, float _y, float xa, float ya) {
        int x = (int)(_x / 16.0f);
        int y = (int)(_y / 16.0f);
        if (x == (int)(this.x / 16.0f) && y == (int)(this.y / 16.0f)) {
            return false;
        }
        boolean blocking = this.world.level.isBlocking(x, y, xa, ya);
        return blocking;
    }

    @Override
    public boolean shellCollideCheck(Shell shell) {
        if (!this.alive) {
            return false;
        }
        float xD = shell.x - this.x;
        float yD = shell.y - this.y;
        if (xD > -16.0f && xD < 16.0f && yD > (float)(-this.height) && yD < (float)shell.height) {
            this.xa = shell.facing * 2;
            this.ya = -5.0f;
            this.world.addEvent(EventType.SHELL_KILL, this.type.getValue());
            if (this.graphics != null) {
                if (this.type == SpriteType.GREEN_KOOPA || this.type == SpriteType.GREEN_KOOPA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 42, -5.0f));
                } else if (this.type == SpriteType.RED_KOOPA || this.type == SpriteType.RED_KOOPA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 41, -5.0f));
                } else if (this.type == SpriteType.GOOMBA || this.type == SpriteType.GOOMBA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 44, -5.0f));
                } else if (this.type == SpriteType.SPIKY || this.type == SpriteType.SPIKY_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 45, -5.0f));
                }
            }
            this.world.removeSprite(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean fireballCollideCheck(Fireball fireball) {
        if (!this.alive) {
            return false;
        }
        float xD = fireball.x - this.x;
        float yD = fireball.y - this.y;
        if (xD > -16.0f && xD < 16.0f && yD > (float)(-this.height) && yD < (float)fireball.height) {
            if (this.noFireballDeath) {
                return true;
            }
            this.xa = fireball.facing * 2;
            this.ya = -5.0f;
            this.world.addEvent(EventType.FIRE_KILL, this.type.getValue());
            if (this.graphics != null) {
                if (this.type == SpriteType.GREEN_KOOPA || this.type == SpriteType.GREEN_KOOPA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 42, -5.0f));
                } else if (this.type == SpriteType.RED_KOOPA || this.type == SpriteType.RED_KOOPA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 41, -5.0f));
                } else if (this.type == SpriteType.GOOMBA || this.type == SpriteType.GOOMBA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 44, -5.0f));
                }
            }
            this.world.removeSprite(this);
            return true;
        }
        return false;
    }

    @Override
    public void bumpCheck(int xTile, int yTile) {
        if (!this.alive) {
            return;
        }
        if (this.x + (float)this.width > (float)(xTile * 16) && this.x - (float)this.width < (float)(xTile * 16 + 16) && yTile == (int)((this.y - 1.0f) / 16.0f)) {
            this.xa = -this.world.mario.facing * 2;
            this.ya = -5.0f;
            if (this.graphics != null) {
                if (this.type == SpriteType.GREEN_KOOPA || this.type == SpriteType.GREEN_KOOPA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 42, -5.0f));
                } else if (this.type == SpriteType.RED_KOOPA || this.type == SpriteType.RED_KOOPA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 41, -5.0f));
                } else if (this.type == SpriteType.GOOMBA || this.type == SpriteType.GOOMBA_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 44, -5.0f));
                } else if (this.type == SpriteType.SPIKY || this.type == SpriteType.SPIKY_WINGED) {
                    this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 45, -5.0f));
                }
            }
            this.world.removeSprite(this);
        }
    }

    @Override
    public void render(Graphics og) {
        if (this.winged && this.type != SpriteType.RED_KOOPA && this.type != SpriteType.GREEN_KOOPA && this.type != SpriteType.RED_KOOPA_WINGED && this.type != SpriteType.GREEN_KOOPA_WINGED) {
            this.wingGraphics.flipX = false;
            this.wingGraphics.render(og, (int)(this.x - this.world.cameraX - 6.0f), (int)(this.y - this.world.cameraY - 6.0f));
            this.wingGraphics.flipX = true;
            this.wingGraphics.render(og, (int)(this.x - this.world.cameraX + 22.0f), (int)(this.y - this.world.cameraY - 6.0f));
        }
        this.graphics.render(og, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
        if (this.winged && (this.type == SpriteType.RED_KOOPA || this.type == SpriteType.GREEN_KOOPA || this.type == SpriteType.RED_KOOPA_WINGED || this.type == SpriteType.GREEN_KOOPA_WINGED)) {
            int shiftX = -1;
            if (this.graphics.flipX) {
                shiftX = 17;
            }
            this.wingGraphics.flipX = this.graphics.flipX;
            this.wingGraphics.render(og, (int)(this.x - this.world.cameraX + (float)shiftX), (int)(this.y - this.world.cameraY - 8.0f));
        }
    }
}

