/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.EventType;
import engine.helper.SpriteType;
import java.awt.Graphics;

public class FireFlower
extends MarioSprite {
    private MarioImage graphics;
    private int life;

    public FireFlower(boolean visuals, float x, float y) {
        super(x, y, SpriteType.FIRE_FLOWER);
        this.width = 4;
        this.height = 12;
        this.facing = 1;
        this.life = 0;
        if (visuals) {
            this.graphics = new MarioImage(Assets.items, 1);
            this.graphics.originX = 8;
            this.graphics.originY = 15;
            this.graphics.width = 16;
            this.graphics.height = 16;
        }
    }

    @Override
    public MarioSprite clone() {
        FireFlower f = new FireFlower(false, this.x, this.y);
        f.xa = this.xa;
        f.ya = this.ya;
        f.initialCode = this.initialCode;
        f.width = this.width;
        f.height = this.height;
        f.facing = this.facing;
        f.life = this.life;
        return f;
    }

    @Override
    public void collideCheck() {
        if (!this.alive) {
            return;
        }
        float xMarioD = this.world.mario.x - this.x;
        float yMarioD = this.world.mario.y - this.y;
        if (xMarioD > -16.0f && xMarioD < 16.0f && yMarioD > (float)(-this.height) && yMarioD < (float)this.world.mario.height) {
            this.world.addEvent(EventType.COLLECT, this.type.getValue());
            this.world.mario.getFlower();
            this.world.removeSprite(this);
        }
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        super.update();
        ++this.life;
        if (this.life < 9) {
            this.y -= 1.0f;
            return;
        }
        if (this.graphics != null) {
            this.graphics.index = 1 + this.life / 2 % 2;
        }
    }

    @Override
    public void render(Graphics og) {
        super.render(og);
        this.graphics.render(og, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
    }
}

