/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.EventType;
import engine.helper.SpriteType;
import java.awt.Graphics;

public class LifeMushroom
extends MarioSprite {
    private boolean onGround = false;
    private int life;
    private MarioImage graphics;
    private static final float GROUND_INERTIA = 0.89f;
    private static final float AIR_INERTIA = 0.89f;

    public LifeMushroom(boolean visuals, float x, float y) {
        super(x, y, SpriteType.LIFE_MUSHROOM);
        this.width = 4;
        this.height = 12;
        this.facing = 1;
        this.life = 0;
        if (visuals) {
            this.graphics = new MarioImage(Assets.items, 3);
            this.graphics.width = 16;
            this.graphics.height = 16;
            this.graphics.originX = 8;
            this.graphics.originY = 15;
        }
    }

    @Override
    public MarioSprite clone() {
        LifeMushroom m = new LifeMushroom(false, this.x, this.y);
        m.xa = this.xa;
        m.ya = this.ya;
        m.initialCode = this.initialCode;
        m.width = this.width;
        m.height = this.height;
        m.facing = this.facing;
        m.life = this.life;
        m.onGround = this.onGround;
        return m;
    }

    @Override
    public void collideCheck() {
        if (!this.alive) {
            return;
        }
        float xMarioD = this.world.mario.x - this.x;
        float yMarioD = this.world.mario.y - this.y;
        if (xMarioD > -16.0f && xMarioD < 16.0f && yMarioD > (float)(-this.height) && yMarioD < (float)this.world.mario.height) {
            this.world.addEvent(EventType.COLLECT, this.type.getValue());
            this.world.mario.collect1Up();
            this.world.removeSprite(this);
        }
    }

    private boolean isBlocking(float _x, float _y, float xa, float ya) {
        int x = (int)(_x / 16.0f);
        int y = (int)(_y / 16.0f);
        if (x == (int)(this.x / 16.0f) && y == (int)(this.y / 16.0f)) {
            return false;
        }
        boolean blocking = this.world.level.isBlocking(x, y, xa, ya);
        return blocking;
    }

    @Override
    public void bumpCheck(int xTile, int yTile) {
        if (!this.alive) {
            return;
        }
        if (this.x + (float)this.width > (float)(xTile * 16) && this.x - (float)this.width < (float)(xTile * 16 + 16) && yTile == (int)((this.y - 1.0f) / 16.0f)) {
            this.facing = -this.world.mario.facing;
            this.ya = -10.0f;
        }
    }

    private boolean move(float xa, float ya) {
        while (xa > 8.0f) {
            if (!this.move(8.0f, 0.0f)) {
                return false;
            }
            xa -= 8.0f;
        }
        while (xa < -8.0f) {
            if (!this.move(-8.0f, 0.0f)) {
                return false;
            }
            xa += 8.0f;
        }
        while (ya > 8.0f) {
            if (!this.move(0.0f, 8.0f)) {
                return false;
            }
            ya -= 8.0f;
        }
        while (ya < -8.0f) {
            if (!this.move(0.0f, -8.0f)) {
                return false;
            }
            ya += 8.0f;
        }
        boolean collide = false;
        if (ya > 0.0f) {
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya, xa, 0.0f)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya, xa, 0.0f)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya + 1.0f, xa, ya)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya + 1.0f, xa, ya)) {
                collide = true;
            }
        }
        if (ya < 0.0f) {
            if (this.isBlocking(this.x + xa, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
        }
        if (xa > 0.0f) {
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)(this.height / 2), xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya, xa, ya)) {
                collide = true;
            }
        }
        if (xa < 0.0f) {
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)(this.height / 2), xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya, xa, ya)) {
                collide = true;
            }
        }
        if (collide) {
            if (xa < 0.0f) {
                this.x = (int)((this.x - (float)this.width) / 16.0f) * 16 + this.width;
                this.xa = 0.0f;
            }
            if (xa > 0.0f) {
                this.x = (int)((this.x + (float)this.width) / 16.0f + 1.0f) * 16 - this.width - 1;
                this.xa = 0.0f;
            }
            if (ya < 0.0f) {
                this.y = (int)((this.y - (float)this.height) / 16.0f) * 16 + this.height;
                this.ya = 0.0f;
            }
            if (ya > 0.0f) {
                this.y = (int)(this.y / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += xa;
        this.y += ya;
        return true;
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        if (this.life < 9) {
            this.y -= 1.0f;
            ++this.life;
            return;
        }
        float sideWaysSpeed = 1.75f;
        if (this.xa > 2.0f) {
            this.facing = 1;
        }
        if (this.xa < -2.0f) {
            this.facing = -1;
        }
        this.xa = (float)this.facing * sideWaysSpeed;
        if (!this.move(this.xa, 0.0f)) {
            this.facing = -this.facing;
        }
        this.onGround = false;
        this.move(0.0f, this.ya);
        this.ya *= 0.85f;
        this.xa = this.onGround ? (this.xa *= 0.89f) : (this.xa *= 0.89f);
        if (!this.onGround) {
            this.ya += 2.0f;
        }
    }

    @Override
    public void render(Graphics og) {
        super.render(og);
        this.graphics.render(og, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
    }
}

