/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.EventType;
import engine.helper.MarioActions;
import engine.helper.SpriteType;
import engine.helper.TileFeature;
import engine.sprites.BulletBill;
import engine.sprites.Enemy;
import engine.sprites.Fireball;
import engine.sprites.Shell;
import java.awt.Graphics;

public class Mario
extends MarioSprite {
    public boolean isLarge = false;
    public boolean isFire = false;
    public boolean onGround;
    public boolean wasOnGround;
    public boolean isDucking;
    public boolean canShoot;
    public boolean mayJump;
    public boolean[] actions = null;
    public int jumpTime = 0;
    private float xJumpSpeed;
    private float yJumpSpeed = 0.0f;
    private int invulnerableTime = 0;
    private float marioFrameSpeed = 0.0f;
    private boolean oldLarge = false;
    private boolean oldFire = false;
    private MarioImage graphics = null;
    private float xJumpStart = -100.0f;
    private final float GROUND_INERTIA = 0.89f;
    private final float AIR_INERTIA = 0.89f;
    private final int POWERUP_TIME = 3;

    public Mario(boolean visuals, float x, float y) {
        super(x + 8.0f, y + 15.0f, SpriteType.MARIO);
        this.width = 4;
        this.height = 24;
        if (visuals) {
            this.graphics = new MarioImage(Assets.smallMario, 0);
        }
    }

    @Override
    public MarioSprite clone() {
        Mario sprite = new Mario(false, this.x - 8.0f, this.y - 15.0f);
        sprite.xa = this.xa;
        sprite.ya = this.ya;
        sprite.initialCode = this.initialCode;
        sprite.width = this.width;
        sprite.height = this.height;
        sprite.facing = this.facing;
        sprite.isLarge = this.isLarge;
        sprite.isFire = this.isFire;
        sprite.wasOnGround = this.wasOnGround;
        sprite.onGround = this.onGround;
        sprite.isDucking = this.isDucking;
        sprite.canShoot = this.canShoot;
        sprite.mayJump = this.mayJump;
        sprite.actions = new boolean[this.actions.length];
        int i = 0;
        while (i < this.actions.length) {
            sprite.actions[i] = this.actions[i];
            ++i;
        }
        sprite.xJumpSpeed = this.xJumpSpeed;
        sprite.yJumpSpeed = this.yJumpSpeed;
        sprite.invulnerableTime = this.invulnerableTime;
        sprite.jumpTime = this.jumpTime;
        sprite.xJumpStart = this.xJumpStart;
        return sprite;
    }

    private boolean move(float xa, float ya) {
        while (xa > 8.0f) {
            if (!this.move(8.0f, 0.0f)) {
                return false;
            }
            xa -= 8.0f;
        }
        while (xa < -8.0f) {
            if (!this.move(-8.0f, 0.0f)) {
                return false;
            }
            xa += 8.0f;
        }
        while (ya > 8.0f) {
            if (!this.move(0.0f, 8.0f)) {
                return false;
            }
            ya -= 8.0f;
        }
        while (ya < -8.0f) {
            if (!this.move(0.0f, -8.0f)) {
                return false;
            }
            ya += 8.0f;
        }
        boolean collide = false;
        if (ya > 0.0f) {
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya, xa, 0.0f)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya, xa, 0.0f)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya + 1.0f, xa, ya)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya + 1.0f, xa, ya)) {
                collide = true;
            }
        }
        if (ya < 0.0f) {
            if (this.isBlocking(this.x + xa, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
        }
        if (xa > 0.0f) {
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)(this.height / 2), xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya, xa, ya)) {
                collide = true;
            }
        }
        if (xa < 0.0f) {
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)(this.height / 2), xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya, xa, ya)) {
                collide = true;
            }
        }
        if (collide) {
            if (xa < 0.0f) {
                this.x = (int)((this.x - (float)this.width) / 16.0f) * 16 + this.width;
                this.xa = 0.0f;
            }
            if (xa > 0.0f) {
                this.x = (int)((this.x + (float)this.width) / 16.0f + 1.0f) * 16 - this.width - 1;
                this.xa = 0.0f;
            }
            if (ya < 0.0f) {
                this.y = (int)((this.y - (float)this.height) / 16.0f) * 16 + this.height;
                this.jumpTime = 0;
                this.ya = 0.0f;
            }
            if (ya > 0.0f) {
                this.y = (int)((this.y - 1.0f) / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += xa;
        this.y += ya;
        return true;
    }

    private boolean isBlocking(float _x, float _y, float xa, float ya) {
        int xTile = (int)(_x / 16.0f);
        int yTile = (int)(_y / 16.0f);
        if (xTile == (int)(this.x / 16.0f) && yTile == (int)(this.y / 16.0f)) {
            return false;
        }
        boolean blocking = this.world.level.isBlocking(xTile, yTile, xa, ya);
        int block = this.world.level.getBlock(xTile, yTile);
        if (TileFeature.getTileType(block).contains((Object)TileFeature.PICKABLE)) {
            this.world.addEvent(EventType.COLLECT, block);
            this.collectCoin();
            this.world.level.setBlock(xTile, yTile, 0);
        }
        if (blocking && ya < 0.0f) {
            this.world.bump(xTile, yTile, this.isLarge);
        }
        return blocking;
    }

    public void updateGraphics() {
        boolean currentFire;
        boolean currentLarge;
        if (!this.alive) {
            return;
        }
        if (this.world.pauseTimer > 0) {
            currentLarge = this.world.pauseTimer / 2 % 2 == 0 ? this.oldLarge : this.isLarge;
            currentFire = this.world.pauseTimer / 2 % 2 == 0 ? this.oldFire : this.isFire;
        } else {
            currentLarge = this.isLarge;
            currentFire = this.isFire;
        }
        if (currentLarge) {
            this.graphics.sheet = Assets.mario;
            if (currentFire) {
                this.graphics.sheet = Assets.fireMario;
            }
            this.graphics.originX = 16;
            this.graphics.originY = 31;
            this.graphics.height = 32;
            this.graphics.width = 32;
        } else {
            this.graphics.sheet = Assets.smallMario;
            this.graphics.originX = 8;
            this.graphics.originY = 15;
            this.graphics.height = 16;
            this.graphics.width = 16;
        }
        this.marioFrameSpeed += Math.abs(this.xa) + 5.0f;
        if (Math.abs(this.xa) < 0.5f) {
            this.marioFrameSpeed = 0.0f;
        }
        this.graphics.visible = (this.invulnerableTime / 2 & 1) == 0;
        this.graphics.flipX = this.facing == -1;
        int frameIndex = 0;
        if (currentLarge) {
            frameIndex = (int)(this.marioFrameSpeed / 20.0f) % 4;
            if (frameIndex == 3) {
                frameIndex = 1;
            }
            if (Math.abs(this.xa) > 10.0f) {
                frameIndex += 3;
            }
            if (!this.onGround) {
                frameIndex = Math.abs(this.xa) > 10.0f ? 6 : 5;
            }
        } else {
            frameIndex = (int)(this.marioFrameSpeed / 20.0f) % 2;
            if (Math.abs(this.xa) > 10.0f) {
                frameIndex += 2;
            }
            if (!this.onGround) {
                frameIndex = Math.abs(this.xa) > 10.0f ? 5 : 4;
            }
        }
        if (this.onGround && (this.facing == -1 && this.xa > 0.0f || this.facing == 1 && this.xa < 0.0f) && (this.xa > 1.0f || this.xa < -1.0f)) {
            int n = frameIndex = currentLarge ? 8 : 7;
        }
        if (currentLarge && this.isDucking) {
            frameIndex = 13;
        }
        this.graphics.index = frameIndex;
    }

    @Override
    public void update() {
        float sideWaysSpeed;
        if (!this.alive) {
            return;
        }
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        this.wasOnGround = this.onGround;
        float f = sideWaysSpeed = this.actions[MarioActions.SPEED.getValue()] ? 1.2f : 0.6f;
        if (this.onGround) {
            boolean bl = this.isDucking = this.actions[MarioActions.DOWN.getValue()] && this.isLarge;
        }
        this.height = this.isLarge ? (this.isDucking ? 12 : 24) : 12;
        if (this.xa > 2.0f) {
            this.facing = 1;
        }
        if (this.xa < -2.0f) {
            this.facing = -1;
        }
        if (this.actions[MarioActions.JUMP.getValue()] || this.jumpTime < 0 && !this.onGround) {
            if (this.jumpTime < 0) {
                this.xa = this.xJumpSpeed;
                this.ya = (float)(-this.jumpTime) * this.yJumpSpeed;
                ++this.jumpTime;
            } else if (this.onGround && this.mayJump) {
                this.xJumpSpeed = 0.0f;
                this.yJumpSpeed = -1.9f;
                this.jumpTime = 7;
                this.ya = (float)this.jumpTime * this.yJumpSpeed;
                this.onGround = false;
                if (!(this.isBlocking(this.x, this.y - 4.0f - (float)this.height, 0.0f, -4.0f) || this.isBlocking(this.x - (float)this.width, this.y - 4.0f - (float)this.height, 0.0f, -4.0f) || this.isBlocking(this.x + (float)this.width, this.y - 4.0f - (float)this.height, 0.0f, -4.0f))) {
                    this.xJumpStart = this.x;
                    this.world.addEvent(EventType.JUMP, 0);
                }
            } else if (this.jumpTime > 0) {
                this.xa += this.xJumpSpeed;
                this.ya = (float)this.jumpTime * this.yJumpSpeed;
                --this.jumpTime;
            }
        } else {
            this.jumpTime = 0;
        }
        if (this.actions[MarioActions.LEFT.getValue()] && !this.isDucking) {
            this.xa -= sideWaysSpeed;
            if (this.jumpTime >= 0) {
                this.facing = -1;
            }
        }
        if (this.actions[MarioActions.RIGHT.getValue()] && !this.isDucking) {
            this.xa += sideWaysSpeed;
            if (this.jumpTime >= 0) {
                this.facing = 1;
            }
        }
        if (this.actions[MarioActions.SPEED.getValue()] && this.canShoot && this.isFire && this.world.fireballsOnScreen < 2) {
            this.world.addSprite(new Fireball(this.graphics != null, this.x + (float)(this.facing * 6), this.y - 20.0f, this.facing));
        }
        this.canShoot = !this.actions[MarioActions.SPEED.getValue()];
        boolean bl = this.mayJump = this.onGround && !this.actions[MarioActions.JUMP.getValue()];
        if (Math.abs(this.xa) < 0.5f) {
            this.xa = 0.0f;
        }
        this.onGround = false;
        this.move(this.xa, 0.0f);
        this.move(0.0f, this.ya);
        if (!this.wasOnGround && this.onGround && this.xJumpStart >= 0.0f) {
            this.world.addEvent(EventType.LAND, 0);
            this.xJumpStart = -100.0f;
        }
        if (this.x < 0.0f) {
            this.x = 0.0f;
            this.xa = 0.0f;
        }
        if (this.x > (float)(this.world.level.exitTileX * 16)) {
            this.x = this.world.level.exitTileX * 16;
            this.xa = 0.0f;
            this.world.win();
        }
        this.ya *= 0.85f;
        this.xa = this.onGround ? (this.xa *= 0.89f) : (this.xa *= 0.89f);
        if (!this.onGround) {
            this.ya += 3.0f;
        }
        if (this.graphics != null) {
            this.updateGraphics();
        }
    }

    public void stomp(Enemy enemy) {
        if (!this.alive) {
            return;
        }
        float targetY = enemy.y - (float)(enemy.height / 2);
        this.move(0.0f, targetY - this.y);
        this.xJumpSpeed = 0.0f;
        this.yJumpSpeed = -1.9f;
        this.jumpTime = 8;
        this.ya = (float)this.jumpTime * this.yJumpSpeed;
        this.onGround = false;
        this.invulnerableTime = 1;
    }

    public void stomp(Shell shell) {
        if (!this.alive) {
            return;
        }
        float targetY = shell.y - (float)(shell.height / 2);
        this.move(0.0f, targetY - this.y);
        this.xJumpSpeed = 0.0f;
        this.yJumpSpeed = -1.9f;
        this.jumpTime = 8;
        this.ya = (float)this.jumpTime * this.yJumpSpeed;
        this.onGround = false;
        this.invulnerableTime = 1;
    }

    public void getHurt() {
        if (this.invulnerableTime > 0 || !this.alive) {
            return;
        }
        if (this.isLarge) {
            this.world.pauseTimer = 9;
            this.oldLarge = this.isLarge;
            this.oldFire = this.isFire;
            if (this.isFire) {
                this.isFire = false;
            } else {
                this.isLarge = false;
            }
            this.invulnerableTime = 32;
        } else if (this.world != null) {
            if (this.world.lives <= 0) {
                this.world.lose();
            } else {
                --this.world.lives;
                ++this.world.deaths;
                this.world.pauseTimer = 9;
                this.invulnerableTime = 32;
            }
        }
    }

    public void getDrop() {
        if (!this.alive) {
            return;
        }
        this.oldLarge = this.isLarge;
        this.oldFire = this.isFire;
        this.isFire = false;
        this.isLarge = false;
        if (this.world != null) {
            if (this.world.lives <= 0) {
                this.world.lose();
            } else if (this.invulnerableTime <= 0) {
                --this.world.lives;
                ++this.world.deaths;
                this.world.pauseTimer = 9;
            }
        }
        this.invulnerableTime = 72;
    }

    public void getFlower() {
        if (!this.alive) {
            return;
        }
        if (!this.isFire) {
            this.world.pauseTimer = 9;
            this.oldFire = this.isFire;
            this.oldLarge = this.isLarge;
            this.isFire = true;
            this.isLarge = true;
        } else {
            this.collectCoin();
        }
    }

    public void getMushroom() {
        if (!this.alive) {
            return;
        }
        if (!this.isLarge) {
            this.world.pauseTimer = 9;
            this.oldFire = this.isFire;
            this.oldLarge = this.isLarge;
            this.isLarge = true;
        } else {
            this.collectCoin();
        }
    }

    public void kick(Shell shell) {
        if (!this.alive) {
            return;
        }
        this.invulnerableTime = 1;
    }

    public void stomp(BulletBill bill) {
        if (!this.alive) {
            return;
        }
        float targetY = bill.y - (float)(bill.height / 2);
        this.move(0.0f, targetY - this.y);
        this.xJumpSpeed = 0.0f;
        this.yJumpSpeed = -1.9f;
        this.jumpTime = 8;
        this.ya = (float)this.jumpTime * this.yJumpSpeed;
        this.onGround = false;
        this.invulnerableTime = 1;
    }

    public String getMarioType() {
        if (this.isFire) {
            return "fire";
        }
        if (this.isLarge) {
            return "large";
        }
        return "small";
    }

    public void collect1Up() {
        if (!this.alive) {
            return;
        }
        ++this.world.lives;
    }

    public void collectCoin() {
        if (!this.alive) {
            return;
        }
        ++this.world.coins;
        if (this.world.coins % 100 == 0) {
            this.collect1Up();
        }
    }

    @Override
    public void render(Graphics og) {
        super.render(og);
        this.graphics.render(og, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
    }
}

