/*
 * Decompiled with CFR 0.152.
 */
import engine.core.MarioAgent;
import engine.core.MarioGame;
import engine.core.MarioResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class MarioProxy {
    private static void printResults(MarioResult result) {
        System.out.println("****************************************************************");
        System.out.println("Game Status: " + result.getGameStatus().toString() + " Percentage Completion: " + result.getCompletionPercentage());
        System.out.println("Lives: " + result.getCurrentLives() + " Coins: " + result.getCurrentCoins() + " Remaining Time: " + (int)Math.ceil((float)result.getRemainingTime() / 1000.0f));
        System.out.println("Mario State: " + result.getMarioMode() + " (Mushrooms: " + result.getNumCollectedMushrooms() + " Fire Flowers: " + result.getNumCollectedFireflower() + ")");
        System.out.println("Total Kills: " + result.getKillsTotal() + " (Stomps: " + result.getKillsByStomp() + " Fireballs: " + result.getKillsByFire() + " Shells: " + result.getKillsByShell() + " Falls: " + result.getKillsByFall() + ")");
        System.out.println("Bricks: " + result.getNumDestroyedBricks() + " Jumps: " + result.getNumJumps() + " Max X Jump: " + result.getMaxXJump() + " Max Air Time: " + result.getMaxJumpAirTime());
        System.out.println("****************************************************************");
    }

    private String getLevel(String filepath) {
        String content = "";
        try {
            content = new String(Files.readAllBytes(Paths.get(filepath, new String[0])));
        }
        catch (IOException e) {
            System.out.println("Cannot open " + filepath);
        }
        return content;
    }

    public MarioResult playGameFromTxt(String filepath) {
        MarioGame game = new MarioGame();
        MarioResult res = game.playGame(this.getLevel(filepath), 200, 0);
        MarioProxy.printResults(res);
        return res;
    }

    public MarioResult playGame(String level, int lives, boolean verbose, int scale) {
        MarioGame game = new MarioGame();
        game.setLives(lives);
        game.setVerbose(verbose);
        MarioResult res = game.playGame(level, level.length() / 16 + 5, 0, 30, scale);
        MarioProxy.printResults(res);
        return res;
    }

    public MarioResult simulateGame(String level, MarioAgent agent, boolean render, int fps, long realTimeLimit) {
        MarioGame game = new MarioGame();
        int time = level.length() / 50 + 2;
        return game.runGame(agent, level, time, 0, render, fps, 2.0f, realTimeLimit);
    }

    public MarioResult simulateWithSegmentwiseTimeout(String level, MarioAgent agent, int segTimeMs) {
        MarioGame game = new MarioGame();
        game.setSegwiseTimeouter(segTimeMs);
        int time = level.length() / 50 + 2;
        return game.runGame(agent, level, time);
    }
}

