/*
 * Decompiled with CFR 0.152.
 */
import agents.killer.Agent;
import engine.core.MarioOnlineGenGame;
import engine.core.MarioResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

public class OnlineGen {
    private static String getLevel(String filepath) {
        String content = "";
        try {
            content = new String(Files.readAllBytes(Paths.get(filepath, new String[0])));
        }
        catch (IOException e) {
            System.out.println("Cannot open " + filepath);
        }
        return content;
    }

    public static void printResults(MarioResult result) {
        System.out.println("****************************************************************");
        System.out.println("Game Status: " + result.getGameStatus().toString() + " Percentage Completion: " + result.getCompletionPercentage());
        System.out.println("Lives: " + result.getCurrentLives() + " Coins: " + result.getCurrentCoins() + " Remaining Time: " + (int)Math.ceil((float)result.getRemainingTime() / 1000.0f));
        System.out.println("Mario State: " + result.getMarioMode() + " (Mushrooms: " + result.getNumCollectedMushrooms() + " Fire Flowers: " + result.getNumCollectedFireflower() + ")");
        System.out.println("Total Kills: " + result.getKillsTotal() + " (Stomps: " + result.getKillsByStomp() + " Fireballs: " + result.getKillsByFire() + " Shells: " + result.getKillsByShell() + " Falls: " + result.getKillsByFall() + ")");
        System.out.println("Bricks: " + result.getNumDestroyedBricks() + " Jumps: " + result.getNumJumps() + " Max X Jump: " + result.getMaxXJump() + " Max Air Time: " + result.getMaxJumpAirTime());
        System.out.println("****************************************************************");
    }

    public static void main(String[] args) {
        boolean finish;
        String levelStr = OnlineGen.getLevel("./levels/onlineGen/lvl-1-0.txt");
        Agent agent = new Agent();
        MarioOnlineGenGame game = new MarioOnlineGenGame(levelStr, agent, true);
        long lastFrameTime = System.currentTimeMillis();
        int segId = 1;
        while (!(finish = game.gameStep())) {
            if (game.getTileDistantToExit() < 28 && segId <= 6) {
                String segStr = OnlineGen.getLevel(String.format("./levels/onlineGen/lvl-1-%d.txt", segId));
                game.appendSegment(segStr);
                ++segId;
            }
            try {
                Thread.sleep(Math.max(0L, 33L - (System.currentTimeMillis() - lastFrameTime)));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            lastFrameTime = System.currentTimeMillis();
        }
        OnlineGen.printResults(game.getResult());
    }
}

