/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.HeuristicSearchingAgent;
import agents.andySloane.MarioState;
import agents.andySloane.PrioQ;
import agents.andySloane.Tunables;
import agents.andySloane.WorldState;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;

public final class Agent
extends HeuristicSearchingAgent {
    private PrioQ pq;
    private static final int maxSteps = 800;

    @Override
    public void initialize(MarioForwardModel model, MarioTimer timer) {
        super.initialize(model, timer);
        this.pq = new PrioQ(Tunables.MaxBreadth);
    }

    @Override
    protected int searchForAction(MarioState initialState, WorldState ws) {
        int a;
        this.pq.clear();
        initialState.ws = ws;
        initialState.g = 0.0f;
        initialState.dead = false;
        float threshold = 1.0E10f;
        initialState.cost = this.cost(initialState, initialState);
        for (a = 0; a < 16; ++a) {
            if (Agent.useless_action(a, initialState)) continue;
            MarioState ms = initialState.next(a, ws);
            ms.root_action = a;
            ms.cost = Tunables.FactorC + this.cost(ms, initialState);
            this.pq.offer(ms);
        }
        MarioState bestfound = this.pq.peek();
        for (int n = 0; n < 800 && !this.pq.isEmpty(); ++n) {
            MarioState next = this.pq.poll();
            for (a = 0; a < 16; ++a) {
                if (Agent.useless_action(a, next)) continue;
                MarioState ms = next.next(a, next.ws);
                ms.pred = next;
                if (ms.dead) continue;
                float h = this.cost(ms, initialState);
                ms.g = next.g + Tunables.GIncrement;
                ms.cost = ms.g + h + ((a & MarioState.ACT_JUMP) > 0 ? Tunables.FeetOnTheGroundBonus : 0.0f);
                bestfound = Agent.marioMin(ms, bestfound);
                if (h < 0.1f) {
                    return ms.root_action;
                }
                if (!(ms.cost < threshold)) continue;
                this.pq.offer(ms);
            }
        }
        if (!this.pq.isEmpty()) {
            bestfound = Agent.marioMin(this.pq.poll(), bestfound);
        }
        this.pq.clear();
        return bestfound.root_action;
    }
}

