/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.SpriteState;
import agents.andySloane.Tunables;
import agents.andySloane.WorldState;

public final class MarioState
extends SpriteState {
    public int jumpTime = 0;
    public int invulnerableTime = 0;
    public int hurt = 0;
    public boolean big = true;
    public boolean dead = false;
    public boolean hurtThisStep = false;
    public boolean fire = true;
    public boolean wasOnGround = false;
    public boolean mayJump = true;
    public boolean sliding = false;
    public float xJumpSpeed = 0.0f;
    public float yJumpSpeed = 0.0f;
    public static int ACT_SPEED = 1;
    public static int ACT_RIGHT = 2;
    public static int ACT_LEFT = 4;
    public static int ACT_JUMP = 8;
    public static int[] jumpstep_table = new int[]{0, 1, 2, 4, 7};
    public float g;
    public float cost;
    public int root_action;
    public WorldState ws;
    public int action;
    public MarioState pred;

    public MarioState(float _x, float _y, float _xa, float _ya) {
        this.x = _x;
        this.y = _y;
        this.xa = _xa;
        this.ya = _ya;
    }

    @Override
    public float height() {
        return this.big ? 24.0f : 12.0f;
    }

    public void print() {
        System.out.printf("g=%d a:%d x:(%f,%f) v:(%f,%f) %s%s%s cost=%f\n", (int)this.g, this.action, Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.xa), Float.valueOf(this.ya), this.onGround ? "G" : "g", this.mayJump ? "J" : "j", this.sliding ? "S" : "s", Float.valueOf(this.cost));
    }

    @Override
    public MarioState clone() {
        MarioState n = new MarioState(this.x, this.y, this.xa, this.ya);
        n.facing = this.facing;
        n.jumpTime = this.jumpTime;
        n.big = this.big;
        n.fire = this.fire;
        n.dead = this.dead;
        n.hurt = this.hurt;
        this.hurtThisStep = false;
        n.onGround = this.onGround;
        n.wasOnGround = this.onGround;
        n.mayJump = this.mayJump;
        n.sliding = this.sliding;
        n.xJumpSpeed = this.xJumpSpeed;
        n.yJumpSpeed = this.yJumpSpeed;
        n.root_action = this.root_action;
        n.invulnerableTime = this.invulnerableTime;
        n.ws = this.ws;
        return n;
    }

    public MarioState next(int action, WorldState ws) {
        MarioState n = this.clone();
        n.action = action;
        n.pred = this;
        n.g = this.g + Tunables.GIncrement;
        n.ws = ws;
        n.move(action);
        if (!this.hurtThisStep) {
            n.ws = n.ws.step();
            n.ws = n.ws.interact(n, false);
        }
        return n;
    }

    public void move(int action) {
        float sideWaysSpeed;
        boolean ducking = false;
        float f = sideWaysSpeed = (action & ACT_SPEED) != 0 ? 1.2f : 0.6f;
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        if (this.xa > 2.0f) {
            this.facing = 1;
        } else if (this.xa < -2.0f) {
            this.facing = -1;
        }
        if ((action & ACT_JUMP) != 0 || this.jumpTime < 0 && !this.onGround && !this.sliding) {
            if (this.jumpTime < 0) {
                this.xa = this.xJumpSpeed;
                this.ya = (float)(-this.jumpTime) * this.yJumpSpeed;
                ++this.jumpTime;
            } else if (this.onGround && this.mayJump) {
                this.xJumpSpeed = 0.0f;
                this.yJumpSpeed = -1.9f;
                this.jumpTime = 7;
                this.ya = (float)this.jumpTime * this.yJumpSpeed;
                this.onGround = false;
                this.sliding = false;
            } else if (this.sliding && this.mayJump) {
                this.xJumpSpeed = (float)(-this.facing) * 6.0f;
                this.yJumpSpeed = -2.0f;
                this.jumpTime = -6;
                this.xa = this.xJumpSpeed;
                this.ya = (float)(-this.jumpTime) * this.yJumpSpeed;
                this.onGround = false;
                this.sliding = false;
                this.facing = -this.facing;
            } else if (this.jumpTime > 0) {
                this.xa += this.xJumpSpeed;
                this.ya = (float)this.jumpTime * this.yJumpSpeed;
                --this.jumpTime;
            }
        } else {
            this.jumpTime = 0;
        }
        if ((action & ACT_LEFT) != 0 && !ducking) {
            if (this.facing == 1) {
                this.sliding = false;
            }
            this.xa -= sideWaysSpeed;
            if (this.jumpTime >= 0) {
                this.facing = -1;
            }
        }
        if ((action & ACT_RIGHT) != 0 && !ducking) {
            if (this.facing == -1) {
                this.sliding = false;
            }
            this.xa += sideWaysSpeed;
            if (this.jumpTime >= 0) {
                this.facing = 1;
            }
        }
        if ((action & ACT_LEFT) == 0 && (action & ACT_RIGHT) == 0 || ducking || this.ya < 0.0f || this.onGround) {
            this.sliding = false;
        }
        boolean bl = this.mayJump = (this.onGround || this.sliding) && (action & ACT_JUMP) == 0;
        if (Math.abs(this.xa) < 0.5f) {
            this.xa = 0.0f;
        }
        if (this.sliding) {
            this.ya *= 0.5f;
        }
        this.onGround = false;
        this.move(this.xa, 0.0f);
        this.move(0.0f, this.ya);
        if (this.y > 256.0f) {
            this.dead = true;
        }
        if (this.x < 0.0f) {
            this.x = 0.0f;
            this.xa = 0.0f;
        }
        this.xa *= 0.89f;
        this.ya *= 0.85f;
        if (!this.onGround) {
            this.ya += 3.0f;
        }
    }

    private boolean move(float xa, float ya) {
        int height;
        while (xa > 8.0f) {
            if (!this.move(8.0f, 0.0f)) {
                return false;
            }
            xa -= 8.0f;
        }
        while (xa < -8.0f) {
            if (!this.move(-8.0f, 0.0f)) {
                return false;
            }
            xa += 8.0f;
        }
        while (ya > 8.0f) {
            if (!this.move(0.0f, 8.0f)) {
                return false;
            }
            ya -= 8.0f;
        }
        while (ya < -8.0f) {
            if (!this.move(0.0f, -8.0f)) {
                return false;
            }
            ya += 8.0f;
        }
        boolean collide = false;
        int width = 4;
        int n = height = this.big ? 24 : 12;
        if (ya > 0.0f) {
            if (this.isBlocking(this.x + xa - (float)width, this.y + ya, xa, 0.0f)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + (float)width, this.y + ya, xa, 0.0f)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa - (float)width, this.y + ya + 1.0f, xa, ya)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + (float)width, this.y + ya + 1.0f, xa, ya)) {
                collide = true;
            }
        }
        if (ya < 0.0f) {
            if (this.isBlocking(this.x + xa, this.y + ya - (float)height, xa, ya)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa - (float)width, this.y + ya - (float)height, xa, ya)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa + (float)width, this.y + ya - (float)height, xa, ya)) {
                collide = true;
            }
        }
        if (xa > 0.0f) {
            this.sliding = true;
            if (this.isBlocking(this.x + xa + (float)width, this.y + ya - (float)height, xa, ya)) {
                collide = true;
            } else {
                this.sliding = false;
            }
            if (this.isBlocking(this.x + xa + (float)width, this.y + ya - (float)(height / 2), xa, ya)) {
                collide = true;
            } else {
                this.sliding = false;
            }
            if (this.isBlocking(this.x + xa + (float)width, this.y + ya, xa, ya)) {
                collide = true;
            } else {
                this.sliding = false;
            }
        }
        if (xa < 0.0f) {
            this.sliding = true;
            if (this.isBlocking(this.x + xa - (float)width, this.y + ya - (float)height, xa, ya)) {
                collide = true;
            } else {
                this.sliding = false;
            }
            if (this.isBlocking(this.x + xa - (float)width, this.y + ya - (float)(height / 2), xa, ya)) {
                collide = true;
            } else {
                this.sliding = false;
            }
            if (this.isBlocking(this.x + xa - (float)width, this.y + ya, xa, ya)) {
                collide = true;
            } else {
                this.sliding = false;
            }
        }
        if (collide) {
            if (xa < 0.0f) {
                this.x = (int)((this.x - (float)width) / 16.0f) * 16 + width;
                this.xa = 0.0f;
            } else if (xa > 0.0f) {
                this.x = (int)((this.x + (float)width) / 16.0f + 1.0f) * 16 - width - 1;
                this.xa = 0.0f;
            }
            if (ya < 0.0f) {
                this.y = (int)((this.y - (float)height) / 16.0f) * 16 + height;
                this.jumpTime = 0;
                this.ya = 0.0f;
            } else if (ya > 0.0f) {
                this.y = (int)((this.y - 1.0f) / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += xa;
        this.y += ya;
        return true;
    }

    private boolean isBlocking(float _x, float _y, float xa, float ya) {
        int x = (int)(_x / 16.0f);
        int y = (int)(_y / 16.0f);
        int Mx = (int)(this.x / 16.0f);
        int My = (int)(this.y / 16.0f);
        if (x == Mx && y == My) {
            return false;
        }
        boolean blocking = this.ws.isBlocking(x, y, xa, ya);
        int block = this.ws.getBlock(x, y);
        if (block == 34) {
            this.ws = this.ws.removeTile(x, y);
            return false;
        }
        if (blocking && ya < 0.0f) {
            this.ws = this.ws.bump(x, y, this.big);
        }
        return blocking;
    }

    public void stomp(SpriteState enemy) {
        float targetY = enemy.y - enemy.height() / 2.0f;
        this.move(0.0f, targetY - this.y);
        this.xJumpSpeed = 0.0f;
        this.yJumpSpeed = -1.9f;
        this.jumpTime = 8;
        this.ya = (float)this.jumpTime * this.yJumpSpeed;
        this.onGround = false;
        this.sliding = false;
        this.invulnerableTime = 1;
    }

    public void getHurt() {
        if (this.invulnerableTime > 0) {
            return;
        }
        if (this.big) {
            if (this.fire) {
                this.fire = false;
            } else {
                this.big = false;
            }
            this.invulnerableTime = 32;
        } else {
            this.dead = true;
        }
        ++this.hurt;
        this.hurtThisStep = true;
    }

    public int marioMode() {
        return (this.big ? 1 : 0) + (this.fire ? 1 : 0);
    }
}

