/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import agents.andySloane.MarioState;
import agents.andySloane.MarioStateComparator;
import java.util.Arrays;

public class PrioQ {
    private static MarioStateComparator comparator = new MarioStateComparator();
    private MarioState[] queue;
    private int size = 0;

    public PrioQ(int initialCapacity) {
        this.queue = new MarioState[initialCapacity];
    }

    public boolean offer(MarioState e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.size == this.queue.length) {
            this.drop();
        }
        int i = this.size;
        this.size = i + 1;
        if (i == 0) {
            this.queue[0] = e;
        } else {
            this.siftUp(i, e);
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    public MarioState peek() {
        if (this.size == 0) {
            return null;
        }
        return this.queue[0];
    }

    public MarioState poll() {
        if (this.size == 0) {
            return null;
        }
        int s = --this.size;
        MarioState result = this.queue[0];
        MarioState x = this.queue[s];
        this.queue[s] = null;
        if (s != 0) {
            this.siftDown(0, x);
        }
        return result;
    }

    public void drop() {
        int i;
        Arrays.sort(this.queue, 0, this.size, comparator);
        int l = this.size >> 1;
        for (i = 0; i < l; ++i) {
            this.queue[--this.size] = null;
        }
        for (i = (this.size >>> 1) - 1; i >= 0; --i) {
            this.siftDown(i, this.queue[i]);
        }
    }

    private void siftUp(int k, MarioState x) {
        int parent;
        MarioState e;
        while (k > 0 && this.compare(x, e = this.queue[parent = k - 1 >>> 1]) < 0) {
            this.queue[k] = e;
            k = parent;
        }
        this.queue[k] = x;
    }

    private void siftDown(int k, MarioState x) {
        int half = this.size >>> 1;
        while (k < half) {
            int child = (k << 1) + 1;
            MarioState c = this.queue[child];
            int right = child + 1;
            if (right < this.size && this.compare(c, this.queue[right]) > 0) {
                child = right;
                c = this.queue[child];
            }
            if (this.compare(x, c) <= 0) break;
            this.queue[k] = c;
            k = child;
        }
        this.queue[k] = x;
    }

    private int compare(MarioState a, MarioState b) {
        if (a.cost < b.cost) {
            return -1;
        }
        if (a.cost > b.cost) {
            return 1;
        }
        return 0;
    }
}

