/*
 * Decompiled with CFR 0.152.
 */
package agents.andySloane;

import engine.core.MarioForwardModel;

public class Sensors {
    private String[][] asciiScene;
    public int[][] levelScene;
    public int[][] enemiesScene;
    public int fireballsOnScreen;
    public static final int EMPTY = 0;
    public static final int COIN = 31;
    public static final int SOLID = 17;
    public static final int PLATFORM = 59;
    public static final int QUESTIONMARK_BOX = 24;
    public static final int BRICK = 23;

    public void updateReadings(MarioForwardModel model) {
        int y;
        this.levelScene = model.getMarioSceneObservation();
        this.enemiesScene = model.getMarioEnemiesObservation();
        this.asciiScene = new String[16][16];
        this.fireballsOnScreen = 0;
        int x = 0;
        while (x < this.levelScene.length) {
            y = 0;
            while (y < this.levelScene[0].length) {
                this.asciiScene[x][y] = this.asciiLevel(this.levelScene[x][y]);
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < this.enemiesScene.length) {
            y = 0;
            while (y < this.enemiesScene[0].length) {
                int enemy = this.enemiesScene[x][y];
                if (enemy != 0) {
                    if (enemy == 16) {
                        ++this.fireballsOnScreen;
                    }
                    this.asciiScene[x][y] = this.asciiEnemy(enemy);
                }
                ++y;
            }
            ++x;
        }
    }

    public int[] getMarioPosition() {
        return new int[]{8, 8};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String[][] stringArray = this.asciiScene;
        int n = this.asciiScene.length;
        int n2 = 0;
        while (n2 < n) {
            String[] sceneRow;
            String[] stringArray2 = sceneRow = stringArray[n2];
            int n3 = sceneRow.length;
            int n4 = 0;
            while (n4 < n3) {
                String square = stringArray2[n4];
                sb.append(String.valueOf(square) + " ");
                ++n4;
            }
            sb.append('\n');
            ++n2;
        }
        return sb.toString();
    }

    private String asciiLevel(int levelSquare) {
        switch (levelSquare) {
            case 0: {
                return " ";
            }
            case 31: {
                return "O";
            }
            case 17: {
                return "X";
            }
            case 59: {
                return "-";
            }
            case 23: {
                return "B";
            }
            case 24: {
                return "?";
            }
        }
        return "" + levelSquare;
    }

    private String asciiEnemy(int enemySquare) {
        if (enemySquare == 2) {
            return "G";
        }
        if (enemySquare == 4 || enemySquare == 6) {
            return "n";
        }
        if (enemySquare == 3 || enemySquare == 5 || enemySquare == 7) {
            return "w";
        }
        if (enemySquare == 14) {
            return "D";
        }
        if (enemySquare == 8) {
            return "^";
        }
        if (enemySquare == 9) {
            return "W";
        }
        if (enemySquare == 10) {
            return "<";
        }
        if (enemySquare == 11) {
            return "V";
        }
        if (enemySquare == 13) {
            return "F";
        }
        if (enemySquare == 16) {
            return "*";
        }
        return "" + enemySquare;
    }
}

