/*
 * Decompiled with CFR 0.152.
 */
package agents.collector;

import agents.collector.Helper;
import engine.core.MarioForwardModel;
import engine.helper.GameStatus;
import java.util.ArrayList;

public class SearchNode {
    public int timeElapsed = 0;
    public float remainingTimeEstimated = 0.0f;
    public float remainingTime = 0.0f;
    public SearchNode parentPos = null;
    public MarioForwardModel sceneSnapshot = null;
    public int distanceFromOrigin = 0;
    public boolean hasBeenHurt = false;
    public boolean isInVisitedList = false;
    public boolean check = false;
    boolean[] action;
    int repetitions = 1;

    public float calcRemainingTime(float marioX, float marioXA) {
        return (100000.0f - (this.maxForwardMovement(marioXA, 1000) + marioX)) / 10.909091f - 1000.0f;
    }

    public float getRemainingTime() {
        if (this.remainingTime > 0.0f) {
            return this.remainingTime;
        }
        return this.remainingTimeEstimated;
    }

    public float estimateRemainingTimeChild(boolean[] action, int repetitions) {
        float[] childbehaviorDistanceAndSpeed = Helper.estimateMaximumForwardMovement(this.sceneSnapshot.getMarioFloatVelocity()[0], action, repetitions);
        return this.calcRemainingTime(this.sceneSnapshot.getMarioFloatPos()[0] + childbehaviorDistanceAndSpeed[0], childbehaviorDistanceAndSpeed[1]);
    }

    public SearchNode(boolean[] action, int repetitions, SearchNode parent) {
        this.parentPos = parent;
        if (parent != null) {
            this.remainingTimeEstimated = parent.estimateRemainingTimeChild(action, repetitions);
            this.distanceFromOrigin = parent.distanceFromOrigin + 1;
            this.sceneSnapshot = this.parentPos.sceneSnapshot.clone();
            for (int i = 0; i < repetitions; ++i) {
                this.sceneSnapshot.advance(action);
            }
        }
        this.action = action;
        this.repetitions = repetitions;
        this.timeElapsed = parent != null ? parent.timeElapsed + repetitions : 0;
    }

    public void initializeRoot(MarioForwardModel model) {
        if (this.parentPos == null) {
            this.sceneSnapshot = model.clone();
            this.remainingTimeEstimated = this.calcRemainingTime(model.getMarioFloatPos()[0], 0.0f);
        }
    }

    public float simulatePos() {
        int marioDamage = Helper.getMarioDamage(this.sceneSnapshot, this.parentPos.sceneSnapshot);
        this.remainingTime = this.calcRemainingTime(this.sceneSnapshot.getMarioFloatPos()[0], this.sceneSnapshot.getMarioFloatVelocity()[0]) + (float)(marioDamage * (1000000 - 100 * this.distanceFromOrigin));
        if (this.isInVisitedList) {
            this.remainingTime += 1500.0f;
        }
        this.hasBeenHurt = marioDamage != 0;
        return this.remainingTime;
    }

    public ArrayList<SearchNode> generateChildren() {
        ArrayList<SearchNode> list = new ArrayList<SearchNode>();
        ArrayList<boolean[]> possibleActions = Helper.createPossibleActions(this);
        for (boolean[] action : possibleActions) {
            list.add(new SearchNode(action, this.repetitions, this));
        }
        return list;
    }

    public boolean isLeafNode() {
        if (this.sceneSnapshot == null) {
            return false;
        }
        return this.sceneSnapshot.getGameStatus() != GameStatus.RUNNING;
    }

    public int getkilled() {
        if (this.sceneSnapshot == null) {
            return 0;
        }
        return this.sceneSnapshot.getKillsTotal();
    }

    public float getkillrate() {
        if (this.sceneSnapshot == null) {
            return 0.0f;
        }
        if (this.sceneSnapshot.getTotalEnemies() == 0) {
            return 0.0f;
        }
        return (float)this.sceneSnapshot.getKillsTotal() / (float)this.sceneSnapshot.getTotalEnemies();
    }

    public int getTotalEnemies() {
        if (this.sceneSnapshot == null) {
            return 0;
        }
        return this.sceneSnapshot.getTotalEnemies();
    }

    public float[] getEnemiesFloatPos() {
        if (this.sceneSnapshot == null) {
            return null;
        }
        return this.sceneSnapshot.getEnemiesFloatPos();
    }

    public float getMarioX() {
        if (this.sceneSnapshot == null) {
            return 0.0f;
        }
        return this.sceneSnapshot.getMarioFloatPos()[0];
    }

    public float getMarioY() {
        if (this.sceneSnapshot == null) {
            return 0.0f;
        }
        return this.sceneSnapshot.getMarioFloatPos()[1];
    }

    public float getCollectRate() {
        if (this.sceneSnapshot == null) {
            return 0.0f;
        }
        if (this.sceneSnapshot.getTotalCoins() == 0) {
            return 0.0f;
        }
        return (float)this.sceneSnapshot.getNumCollectedCoins() / (float)this.sceneSnapshot.getTotalCoins();
    }

    public int ifWin() {
        if (this.sceneSnapshot == null) {
            return 0;
        }
        if (this.sceneSnapshot.getGameStatus() == GameStatus.WIN) {
            return 1;
        }
        return 0;
    }

    public int ifLose() {
        if (this.sceneSnapshot == null) {
            return 0;
        }
        if (this.sceneSnapshot.getGameStatus() == GameStatus.LOSE) {
            return 1;
        }
        return 0;
    }

    private float maxForwardMovement(float initialSpeed, int ticks) {
        float y = ticks;
        float s0 = initialSpeed;
        return (float)(99.17355373 * Math.pow(0.89, y + 1.0f) - 9.090909091 * (double)s0 * Math.pow(0.89, y + 1.0f) + 10.90909091 * (double)y - 88.26446282 + 9.090909091 * (double)s0);
    }
}

