/*
 * Decompiled with CFR 0.152.
 */
package agents.glennHartmann;

import engine.core.MarioAgent;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.MarioActions;

public class Agent
implements MarioAgent {
    private boolean[] action = new boolean[MarioActions.numberOfActions()];
    private int jumpCount = 0;
    private int speedCount = 0;

    private boolean safeToJumpFromEnemies(byte[][] enemiesFromBitmap) {
        for (int y = 5; y <= 9; ++y) {
            for (int x = 11; x <= 14; ++x) {
                if (x == 8 && y == 8 || enemiesFromBitmap[x][y] != 1) continue;
                return false;
            }
        }
        return true;
    }

    private boolean safeToJumpFromGaps(byte[][] levelSceneFromBitmap) {
        for (int y = 9; y <= 9; ++y) {
            boolean b = false;
            for (int x = 11; x <= 14; ++x) {
                if (levelSceneFromBitmap[x][y] != 1) continue;
                b = true;
                break;
            }
            if (b) continue;
            return false;
        }
        return true;
    }

    private boolean dangerFromEnemies(byte[][] enemiesFromBitmap) {
        for (int y = 7; y <= 9; ++y) {
            for (int x = 8; x <= 12; ++x) {
                if (x == 8 && y == 8 || enemiesFromBitmap[x][y] != 1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean dangerFromGaps(byte[][] levelSceneFromBitmap) {
        for (int y = 9; y <= 10; ++y) {
            for (int x = 9; x <= 12; ++x) {
                if (levelSceneFromBitmap[x][y] != 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean safeToJump(byte[][] levelSceneFromBitmap, byte[][] enemiesFromBitmap) {
        return this.safeToJumpFromGaps(levelSceneFromBitmap) && this.safeToJumpFromEnemies(enemiesFromBitmap);
    }

    private boolean block(byte[][] levelSceneFromBitmap) {
        for (int y = 8; y <= 8; ++y) {
            for (int x = 9; x <= 12; ++x) {
                if (levelSceneFromBitmap[x][y] != 1) continue;
                return true;
            }
        }
        return false;
    }

    private byte[][] decode(MarioForwardModel model, int[][] state) {
        model.getClass();
        model.getClass();
        byte[][] dstate = new byte[16][16];
        for (int i = 0; i < dstate.length; ++i) {
            for (int j = 0; j < dstate[0].length; ++j) {
                dstate[i][j] = 2;
            }
        }
        for (int x = 0; x < state.length; ++x) {
            for (int y = 0; y < state[x].length; ++y) {
                dstate[x][y] = state[x][y] != 0 ? (byte)1 : 0;
            }
        }
        return dstate;
    }

    @Override
    public void initialize(MarioForwardModel model, MarioTimer timer) {
        this.action = new boolean[MarioActions.numberOfActions()];
        this.action[MarioActions.RIGHT.getValue()] = true;
        this.action[MarioActions.SPEED.getValue()] = true;
        this.action[MarioActions.JUMP.getValue()] = false;
    }

    @Override
    public boolean[] getActions(MarioForwardModel model, MarioTimer timer) {
        byte[][] levelSceneFromBitmap = this.decode(model, model.getMarioSceneObservation());
        byte[][] enemiesFromBitmap = this.decode(model, model.getMarioEnemiesObservation());
        if (this.action[MarioActions.JUMP.getValue()] && this.jumpCount >= 8) {
            this.action[MarioActions.JUMP.getValue()] = false;
            this.jumpCount = 0;
        } else if (this.action[MarioActions.JUMP.getValue()]) {
            ++this.jumpCount;
        } else if (((this.dangerFromEnemies(enemiesFromBitmap) || this.block(levelSceneFromBitmap)) && this.safeToJump(levelSceneFromBitmap, enemiesFromBitmap) || this.dangerFromGaps(levelSceneFromBitmap)) && model.mayMarioJump()) {
            this.action[MarioActions.JUMP.getValue()] = true;
        }
        if (this.action[MarioActions.SPEED.getValue()] && this.speedCount >= 10) {
            this.action[MarioActions.SPEED.getValue()] = false;
            this.speedCount = 0;
        } else if (this.action[MarioActions.SPEED.getValue()]) {
            ++this.speedCount;
        } else {
            this.action[MarioActions.SPEED.getValue()] = true;
        }
        return this.action;
    }

    @Override
    public String getAgentName() {
        return "GlennHartmannAgent";
    }
}

