/*
 * Decompiled with CFR 0.152.
 */
package agents.human;

import engine.core.MarioAgent;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.MarioActions;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class Agent
extends KeyAdapter
implements MarioAgent {
    private boolean[] actions = null;

    @Override
    public void initialize(MarioForwardModel model, MarioTimer timer) {
        this.actions = new boolean[MarioActions.numberOfActions()];
    }

    @Override
    public boolean[] getActions(MarioForwardModel model, MarioTimer timer) {
        return (boolean[])this.actions.clone();
    }

    @Override
    public String getAgentName() {
        return "HumanAgent";
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.toggleKey(e.getKeyCode(), true);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.toggleKey(e.getKeyCode(), false);
    }

    private void toggleKey(int keyCode, boolean isPressed) {
        if (this.actions == null) {
            return;
        }
        switch (keyCode) {
            case 37: {
                this.actions[MarioActions.LEFT.getValue()] = isPressed;
                break;
            }
            case 39: {
                this.actions[MarioActions.RIGHT.getValue()] = isPressed;
                break;
            }
            case 40: {
                this.actions[MarioActions.DOWN.getValue()] = isPressed;
                break;
            }
            case 83: {
                this.actions[MarioActions.JUMP.getValue()] = isPressed;
                break;
            }
            case 65: {
                this.actions[MarioActions.SPEED.getValue()] = isPressed;
            }
        }
    }
}

