/*
 * Decompiled with CFR 0.152.
 */
package agents.killer;

import agents.killer.Helper;
import agents.killer.SearchNode;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.GameStatus;
import java.util.ArrayList;

public class AStarTree {
    public SearchNode bestPosition;
    public SearchNode furthestPosition;
    float currentSearchStartingMarioXPos;
    ArrayList<SearchNode> posPool;
    ArrayList<int[]> visitedStates = new ArrayList();
    private boolean requireReplanning = false;
    private ArrayList<boolean[]> currentActionPlan;
    int ticksBeforeReplanning = 0;
    public int SearchedStates = 0;
    public int SearchedLose = 0;

    private MarioForwardModel search(MarioTimer timer) {
        SearchNode current = this.bestPosition;
        boolean currentGood = false;
        int maxRight = 176;
        while (this.posPool.size() != 0 && (this.bestPosition.sceneSnapshot.getMarioFloatPos()[0] - this.currentSearchStartingMarioXPos < (float)maxRight || !currentGood) && timer.getRemainingTime() > 0L) {
            current = this.pickBestPos(this.posPool);
            if (current == null) {
                return null;
            }
            currentGood = false;
            float realRemainingTime = current.simulatePos();
            if (realRemainingTime < 0.0f) continue;
            if (!current.isInVisitedList && this.isInVisited((int)current.sceneSnapshot.getMarioFloatPos()[0], (int)current.sceneSnapshot.getMarioFloatPos()[1], current.timeElapsed)) {
                current.isInVisitedList = true;
                current.remainingTime = realRemainingTime += 1500.0f;
                current.remainingTimeEstimated = realRemainingTime;
                this.posPool.add(current);
            } else if ((double)(realRemainingTime - current.remainingTimeEstimated) > 0.1) {
                current.remainingTimeEstimated = realRemainingTime;
                this.posPool.add(current);
            } else {
                currentGood = true;
                this.visited((int)current.sceneSnapshot.getMarioFloatPos()[0], (int)current.sceneSnapshot.getMarioFloatPos()[1], current.timeElapsed);
                this.posPool.addAll(current.generateChildren());
            }
            if (!currentGood) continue;
            if (this.bestPosition.getRemainingTime() > current.getRemainingTime()) {
                this.bestPosition = current;
            }
            if (!(current.sceneSnapshot.getMarioFloatPos()[0] > this.furthestPosition.sceneSnapshot.getMarioFloatPos()[0])) continue;
            this.furthestPosition = current;
        }
        if (current.sceneSnapshot.getMarioFloatPos()[0] - this.currentSearchStartingMarioXPos < (float)maxRight && this.furthestPosition.sceneSnapshot.getMarioFloatPos()[0] > this.bestPosition.sceneSnapshot.getMarioFloatPos()[0] + 20.0f) {
            this.bestPosition = this.furthestPosition;
        }
        return current.sceneSnapshot;
    }

    private void startSearch(MarioForwardModel model, int repetitions) {
        SearchNode startPos = new SearchNode(null, repetitions, null);
        startPos.initializeRoot(model);
        this.posPool = new ArrayList();
        this.visitedStates.clear();
        ArrayList<SearchNode> tempPool = startPos.generateChildren();
        this.posPool.addAll(tempPool);
        this.currentSearchStartingMarioXPos = model.getMarioFloatPos()[0];
        this.bestPosition = startPos;
        this.furthestPosition = startPos;
    }

    private ArrayList<boolean[]> extractPlan() {
        ArrayList<boolean[]> actions = new ArrayList<boolean[]>();
        if (this.bestPosition == null) {
            actions.add(Helper.createAction(false, true, false, true, true));
            return actions;
        }
        SearchNode current = this.bestPosition;
        while (current.parentPos != null) {
            for (int i = 0; i < current.repetitions; ++i) {
                actions.add(0, current.action);
            }
            if (current.hasBeenHurt) {
                this.requireReplanning = true;
            }
            current = current.parentPos;
        }
        return actions;
    }

    private SearchNode pickBestPos(ArrayList<SearchNode> posPool) {
        SearchNode bestPos = null;
        float bestPosCost = 1.0E7f;
        for (SearchNode current : posPool) {
            float currentCost;
            float[] Enemies = current.getEnemiesFloatPos();
            float distance = 0.0f;
            float mario_x = current.getMarioX();
            float mario_y = current.getMarioY();
            if (!current.check) {
                current.check = true;
                ++this.SearchedStates;
                if (current.ifLose() == 1) {
                    ++this.SearchedLose;
                }
            }
            if (!((currentCost = -2.0f * current.getkillrate() - (float)current.ifWin() + (float)(20 * current.ifLose())) < bestPosCost)) continue;
            bestPos = current;
            bestPosCost = currentCost;
        }
        posPool.remove(bestPos);
        return bestPos;
    }

    public boolean[] optimise(MarioForwardModel model, MarioTimer timer) {
        int planAhead = 2;
        int stepsPerSearch = 4;
        MarioForwardModel originalModel = model.clone();
        --this.ticksBeforeReplanning;
        this.requireReplanning = false;
        if (this.ticksBeforeReplanning <= 0 || this.currentActionPlan.size() == 0 || this.requireReplanning) {
            this.currentActionPlan = this.extractPlan();
            if (this.currentActionPlan.size() < planAhead) {
                planAhead = this.currentActionPlan.size();
            }
            for (int i = 0; i < planAhead; ++i) {
                model.advance(this.currentActionPlan.get(i));
            }
            this.startSearch(model, stepsPerSearch);
            this.ticksBeforeReplanning = planAhead;
        }
        if (model.getGameStatus() == GameStatus.LOSE) {
            this.startSearch(originalModel, stepsPerSearch);
        }
        this.search(timer);
        boolean[] action = new boolean[5];
        if (this.currentActionPlan.size() > 0) {
            action = this.currentActionPlan.remove(0);
        }
        return action;
    }

    private void visited(int x, int y, int t) {
        this.visitedStates.add(new int[]{x, y, t});
    }

    private boolean isInVisited(int x, int y, int t) {
        int timeDiff = 5;
        int xDiff = 2;
        int yDiff = 2;
        for (int[] v : this.visitedStates) {
            if (Math.abs(v[0] - x) >= xDiff || Math.abs(v[1] - y) >= yDiff || Math.abs(v[2] - t) >= timeDiff || t < v[2]) continue;
            return true;
        }
        return false;
    }
}

