/*
 * Decompiled with CFR 0.152.
 */
package agents.michal;

import engine.core.MarioAgent;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.MarioActions;

public class Agent
implements MarioAgent {
    private boolean facing_left;
    private int leftCounter;
    private int shootCounter;
    private STATE state;
    private boolean[] action;

    @Override
    public void initialize(MarioForwardModel model, MarioTimer timer) {
        this.action = new boolean[MarioActions.numberOfActions()];
        this.state = STATE.WALK_FORWARD;
        this.facing_left = false;
        this.leftCounter = 0;
        this.shootCounter = 0;
    }

    private int getLocation(int relX, int relY, int[][] scene) {
        int realX = 8 + relX;
        int realY = 8 + relY;
        return scene[realX][realY];
    }

    private boolean thereIsObstacle(int[][] scene) {
        int[] inFrontOf = new int[]{this.getLocation(1, 0, scene), this.getLocation(2, 0, scene), this.getLocation(2, -1, scene)};
        for (int i = 0; i < inFrontOf.length; ++i) {
            if (inFrontOf[i] != 17 && inFrontOf[i] != 23 && inFrontOf[i] != 24) continue;
            return true;
        }
        return false;
    }

    private boolean thereIsHole(int[][] scene) {
        for (int i = 1; i < 3; ++i) {
            for (int j = 2; j < 8; ++j) {
                if (this.getLocation(i, j, scene) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private boolean enemyInFront(int[][] enemies) {
        for (int i = 0; i > -2; --i) {
            for (int j = 1; j < 2; ++j) {
                if (this.getLocation(j, i, enemies) <= 1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean[] getActions(MarioForwardModel model, MarioTimer timer) {
        int[][] scene = model.getMarioSceneObservation();
        int[][] enemies = model.getMarioEnemiesObservation();
        if (this.enemyInFront(enemies)) {
            if (this.shootCounter > 0) {
                this.action[MarioActions.SPEED.getValue()] = false;
            } else {
                this.action[MarioActions.SPEED.getValue()] = true;
                ++this.shootCounter;
            }
            return this.action;
        }
        if (this.shootCounter > 0) {
            this.shootCounter = 0;
        }
        switch (this.state) {
            case WALK_BACKWARD: {
                if (this.leftCounter > 5) {
                    this.state = STATE.WALK_FORWARD;
                    this.facing_left = false;
                }
                ++this.leftCounter;
                this.action[MarioActions.LEFT.getValue()] = true;
                this.action[MarioActions.RIGHT.getValue()] = false;
                break;
            }
            case WALK_FORWARD: {
                this.action[MarioActions.LEFT.getValue()] = false;
                if (this.thereIsHole(scene)) {
                    this.state = STATE.JUMP_HOLE;
                    this.action[MarioActions.JUMP.getValue()] = true;
                    this.action[MarioActions.SPEED.getValue()] = true;
                    break;
                }
                if (this.thereIsObstacle(scene)) {
                    this.state = STATE.JUMP;
                    this.action[MarioActions.JUMP.getValue()] = true;
                    this.action[MarioActions.RIGHT.getValue()] = true;
                    this.action[MarioActions.SPEED.getValue()] = false;
                    break;
                }
                this.action[MarioActions.RIGHT.getValue()] = true;
                this.action[MarioActions.SPEED.getValue()] = false;
                break;
            }
            case JUMP: {
                if (this.action[MarioActions.RIGHT.getValue()] && this.thereIsHole(scene)) {
                    this.action[MarioActions.RIGHT.getValue()] = false;
                    this.action[MarioActions.LEFT.getValue()] = true;
                    this.facing_left = true;
                    break;
                }
                if (!model.isMarioOnGround()) break;
                if (this.facing_left) {
                    this.state = STATE.WALK_BACKWARD;
                    this.leftCounter = 0;
                } else {
                    this.state = STATE.WALK_FORWARD;
                }
                this.action[MarioActions.LEFT.getValue()] = false;
                this.action[MarioActions.RIGHT.getValue()] = false;
                this.action[MarioActions.JUMP.getValue()] = false;
                this.action[MarioActions.SPEED.getValue()] = false;
                break;
            }
            case JUMP_HOLE: {
                if (!model.isMarioOnGround()) break;
                this.state = STATE.WALK_FORWARD;
                this.action[MarioActions.JUMP.getValue()] = false;
                this.action[MarioActions.SPEED.getValue()] = false;
                this.action[MarioActions.LEFT.getValue()] = false;
                this.action[MarioActions.RIGHT.getValue()] = false;
            }
        }
        return this.action;
    }

    @Override
    public String getAgentName() {
        return "MichalAgent";
    }

    private static enum STATE {
        WALK_FORWARD,
        WALK_BACKWARD,
        JUMP,
        JUMP_HOLE;

    }
}

