/*
 * Decompiled with CFR 0.152.
 */
package agents.replay;

import agents.replay.ReplayAgent;
import engine.core.MarioAgentEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;

public class ReplayUtils {
    public static ReplayAgent repAgentFromFile(String filepath) {
        byte[] content = new byte[]{};
        try {
            content = Files.readAllBytes(Paths.get(filepath, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean[][] actions = new boolean[content.length][5];
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = ReplayUtils.parseAction(content[i]);
        }
        return new ReplayAgent(actions);
    }

    public static byte[] serializeAgentEvents(ArrayList<MarioAgentEvent> events) {
        byte[] content = new byte[events.size()];
        for (int i = 0; i < events.size(); ++i) {
            boolean[] action = events.get(i).getActions();
            content[i] = ReplayUtils.serializeAction(action);
        }
        return content;
    }

    public static void saveReplay(String filepath, ArrayList<MarioAgentEvent> events) {
        try {
            byte[] content = ReplayUtils.serializeAgentEvents(events);
            Files.write(Paths.get(filepath, new String[0]), content, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte serializeAction(boolean[] action) {
        byte res = 0;
        for (int i = 0; i < 5; ++i) {
            if (!action[i]) continue;
            res = (byte)(res + (1 << i));
        }
        return res;
    }

    public static boolean[] parseAction(byte byteAction) {
        boolean[] action = new boolean[5];
        for (int i = 0; i < 5; ++i) {
            if ((byteAction & 1 << i) == 0) continue;
            action[i] = true;
        }
        return action;
    }
}

