/*
 * Decompiled with CFR 0.152.
 */
package agents.sergeyPolikarpov;

import java.util.Random;

public class CyberNeuron {
    private float[][][] sbox;
    private int[] inputs_for_sbox;
    private int[] outputs_for_sbox;
    private double[] outputs;
    private double[] inputs;
    public final int parallel_inputs = 1;
    private int num_bits_in_input = 10;
    private int num_of_cells_in_sbox = (int)Math.pow(2.0, this.num_bits_in_input);
    private int[] powstwo = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536};
    private int threshold;
    private final Random random = new Random();
    private double learningRate = 0.05;

    public CyberNeuron(int numberOfInputs, int numberOfOutputs) {
        this.threshold = (int)(0.65 * (double)(127 * numberOfInputs * 1 / this.num_bits_in_input));
        this.sbox = new float[numberOfInputs * 1 / this.num_bits_in_input][this.num_of_cells_in_sbox][numberOfOutputs];
        this.inputs_for_sbox = new int[this.sbox.length];
        this.outputs_for_sbox = new int[this.sbox[0][0].length];
        this.outputs = new double[numberOfOutputs];
        this.inputs = new double[numberOfInputs];
        this.initialize_sbox(this.sbox);
    }

    public CyberNeuron(float[][][] sbox, int numberOfOutputs) {
        this.sbox = sbox;
        this.inputs = new double[sbox.length * this.num_bits_in_input];
        this.outputs = new double[numberOfOutputs];
    }

    protected void initialize_sbox(float[][][] sbox) {
        for (int i = 0; i < sbox.length; ++i) {
            for (int j = 0; j < sbox[i].length; ++j) {
                for (int m = 0; m < sbox[i][j].length; ++m) {
                    sbox[i][j][m] = 0.0f;
                }
            }
        }
    }

    public CyberNeuron getNewInstance() {
        return new CyberNeuron(this.sbox.length * this.num_bits_in_input / 1, this.outputs.length);
    }

    public CyberNeuron copy() {
        CyberNeuron copy = new CyberNeuron(this.copy(this.sbox), this.outputs.length);
        return copy;
    }

    private float[][][] copy(float[][][] original) {
        float[][][] copy = new float[original.length][original[0].length][original[0][0].length];
        for (int i = 0; i < copy.length; ++i) {
            for (int j = 0; j < copy[i].length; ++j) {
                for (int m = 0; m < copy[i][j].length; ++m) {
                    copy[i][j][m] = original[i][j][m];
                }
            }
        }
        return copy;
    }

    public double[] propagate(double[] inputIn) {
        if (this.inputs != inputIn) {
            System.arraycopy(inputIn, 0, this.inputs, 0, inputIn.length);
        }
        if (inputIn.length < this.inputs.length) {
            System.out.println("NOTE: only " + inputIn.length + " inputs out of " + this.inputs.length + " are used in the network");
        }
        int blocksize = this.sbox.length / 1;
        int[] tmp_inputs = new int[blocksize];
        for (int m = 0; m < blocksize; ++m) {
            tmp_inputs[m] = 0;
            for (int n = 0; n < this.num_bits_in_input; ++n) {
                if (this.inputs[m * this.num_bits_in_input + n] != 1.0) continue;
                int n2 = m;
                tmp_inputs[n2] = tmp_inputs[n2] + this.powstwo[n];
            }
        }
        for (int p = 0; p < 1; ++p) {
            for (int m = 0; m < blocksize; ++m) {
                this.inputs_for_sbox[p * blocksize + m] = tmp_inputs[m];
            }
        }
        for (int i = 0; i < this.sbox[0][0].length; ++i) {
            this.outputs_for_sbox[i] = 0;
            for (int m = 0; m < this.sbox.length; ++m) {
                int n = i;
                this.outputs_for_sbox[n] = (int)((float)this.outputs_for_sbox[n] + this.sbox[m][this.inputs_for_sbox[m]][i]);
            }
            double tmp_value = this.outputs_for_sbox[i] > this.threshold ? (double)this.threshold : (double)this.outputs_for_sbox[i];
            this.outputs[i] = tmp_value / (double)this.threshold;
        }
        return this.outputs;
    }

    public double backPropagate(double[] targetOutputs) {
        int i;
        double[] outputError = new double[this.outputs.length];
        for (i = 0; i < targetOutputs.length; ++i) {
            outputError[i] = (targetOutputs[i] - this.outputs[i]) * (double)this.threshold;
            if (!Double.isNaN(outputError[i])) continue;
            System.out.println("Problem at output " + i);
            System.out.println(this.outputs[i] + " " + targetOutputs[i]);
            System.exit(0);
        }
        for (i = 0; i < this.sbox[0][0].length; ++i) {
            int cell_number;
            int row_number;
            int r;
            int outputError_tmp = (int)(outputError[i] * this.learningRate);
            if (outputError_tmp == 0) {
                if (outputError[i] > 0.0) {
                    outputError[i] = 1.0;
                }
                if (outputError[i] < 0.0) {
                    outputError[i] = -1.0;
                }
                if (outputError[i] == 0.0) {
                    outputError[i] = 0.0;
                }
            } else {
                outputError[i] = outputError_tmp;
            }
            if (outputError[i] > 0.0) {
                r = 0;
                while ((double)r < outputError[i]) {
                    row_number = this.random.nextInt(this.sbox.length);
                    cell_number = this.inputs_for_sbox[row_number];
                    float[] fArray = this.sbox[row_number][cell_number];
                    int n = i;
                    fArray[n] = fArray[n] + 1.0f;
                    ++r;
                }
                continue;
            }
            r = 0;
            while ((double)r < Math.abs(outputError[i])) {
                row_number = this.random.nextInt(this.sbox.length);
                cell_number = this.inputs_for_sbox[row_number];
                float[] fArray = this.sbox[row_number][cell_number];
                int n = i;
                fArray[n] = fArray[n] - 1.0f;
                ++r;
            }
        }
        double summedOutputError = 0.0;
        for (int k = 0; k < targetOutputs.length; ++k) {
            summedOutputError += Math.abs(targetOutputs[k] - this.outputs[k]);
        }
        return summedOutputError /= (double)this.outputs.length;
    }

    public double getMutationMagnitude() {
        return 0.0;
    }

    public void setMutationMagnitude(double mutationMagnitude) {
    }

    public static void setInitParameters(double mean, double deviation) {
        System.out.println("PARAMETERS SET: " + mean + "  deviation: " + deviation);
    }

    public void println() {
        System.out.print("\n\n---------------------------------------------------------------------------------------\n");
        System.out.print("---------------------------------------------------------------------------------------\n");
    }

    public String toString() {
        return "CyberNeuron by Sergey V. Polikarpov";
    }

    public void ssetLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public double[] getOutputs() {
        double[] outputsCopy = new double[this.outputs.length];
        System.arraycopy(this.outputs, 0, outputsCopy, 0, this.outputs.length);
        return outputsCopy;
    }

    public double[] getWeightsArray() {
        double[] weights = new double[this.sbox.length * this.sbox[0].length * this.sbox[0][0].length];
        int k = 0;
        for (int i = 0; i < this.sbox.length; ++i) {
            for (int j = 0; j < this.sbox[i].length; ++j) {
                for (int m = 0; m < this.sbox[i][j].length; ++m) {
                    k = i + j + m;
                    weights[k] = this.sbox[i][j][m];
                }
            }
        }
        return weights;
    }

    public void setWeightsArray(double[] weights) {
        int k = 0;
        for (int i = 0; i < this.sbox.length; ++i) {
            for (int j = 0; j < this.sbox[i].length; ++j) {
                for (int m = 0; m < this.sbox[i][j].length; ++m) {
                    k = i + j + m;
                    this.sbox[i][j][m] = (char)weights[k];
                }
            }
        }
    }

    public int getNumberOfInputs() {
        return this.inputs.length;
    }

    public void randomise() {
    }

    public double[] getArray() {
        return this.getWeightsArray();
    }

    public void setArray(double[] array) {
        this.setWeightsArray(array);
    }

    public int[] getPackedInputsToInt(double[] inputs) {
        int[] tmp_inputs = new int[this.sbox.length];
        for (int m = 0; m < this.sbox.length; ++m) {
            tmp_inputs[m] = 0;
            for (int n = 0; n < this.num_bits_in_input; ++n) {
                if (inputs[m * this.num_bits_in_input + n] != 1.0) continue;
                int n2 = m;
                tmp_inputs[n2] = tmp_inputs[n2] + this.powstwo[n];
            }
        }
        return tmp_inputs;
    }
}

