/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import agents.spencerSchumann.Enemy;
import agents.spencerSchumann.Scene;
import engine.core.MarioForwardModel;
import java.util.ArrayList;

public class EnemySimulator {
    public ArrayList<Enemy> enemies = new ArrayList();

    public EnemySimulator clone() {
        EnemySimulator es = new EnemySimulator();
        for (Enemy e : this.enemies) {
            es.enemies.add(e.clone());
        }
        return es;
    }

    public void update(Scene scene) {
        for (Enemy enemy : this.enemies) {
            enemy.x += enemy.vx;
        }
    }

    public void update(MarioForwardModel model) {
        float[] ep = model.getEnemiesFloatPos();
        ArrayList<Enemy> newEnemies = new ArrayList<Enemy>();
        for (int i = 0; i < ep.length; i += 3) {
            int type = (int)ep[i];
            float x = ep[i + 1];
            float y = ep[i + 2];
            boolean found = false;
            for (Enemy enemy : this.enemies) {
                if (type != enemy.type || y != enemy.y) continue;
                float xdiff = Math.abs(enemy.x - x);
                if (xdiff == 0.0f) {
                    newEnemies.add(enemy);
                    this.enemies.remove(enemy);
                    found = true;
                    break;
                }
                if (!(xdiff < 5.0f)) continue;
                enemy.vx += x - enemy.x;
                enemy.x = x;
                newEnemies.add(enemy);
                this.enemies.remove(enemy);
                found = true;
                break;
            }
            if (found) continue;
            newEnemies.add(new Enemy(type, x, y));
        }
        this.enemies = newEnemies;
    }
}

