/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import engine.core.MarioForwardModel;

public class MarioState {
    public float x;
    public float y;
    public float vx;
    public float vy;
    public int mode;
    public float height;
    public boolean onGround;
    public boolean mayJump;
    public int jumpTime;
    private boolean first = true;

    public void update(MarioForwardModel model) {
        this.mode = model.getMarioMode();
        this.height = this.mode > 0 ? 24.0f : 12.0f;
        this.onGround = model.isMarioOnGround();
        this.mayJump = model.mayMarioJump();
        float[] pos = model.getMarioFloatPos();
        if (this.first) {
            this.first = false;
            this.x = pos[0];
            this.y = pos[1];
        }
        float newVx = pos[0] - this.x;
        float newVy = pos[1] - this.y;
        this.vx = newVx;
        this.vy = newVy;
        this.x = pos[0];
        this.y = pos[1];
    }

    public MarioState clone() {
        MarioState m = new MarioState();
        m.x = this.x;
        m.y = this.y;
        m.vx = this.vx;
        m.vy = this.vy;
        m.first = this.first;
        m.mode = this.mode;
        m.height = this.height;
        m.onGround = this.onGround;
        m.mayJump = this.mayJump;
        m.jumpTime = this.jumpTime;
        return m;
    }

    public boolean equals(MarioState other) {
        return this.x == other.x && this.y == other.y && this.first == other.first && this.mode == other.mode && this.height == other.height && this.jumpTime == other.jumpTime && this.mayJump == other.mayJump && this.onGround == other.onGround;
    }
}

