/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import agents.spencerSchumann.BumpableEdge;
import agents.spencerSchumann.Edge;
import agents.spencerSchumann.Tiles;
import engine.core.MarioForwardModel;
import java.util.ArrayList;

public class Scene {
    public ArrayList<Edge> floors = new ArrayList();
    public ArrayList<Edge> walls = new ArrayList();
    public ArrayList<Edge> ceilings = new ArrayList();
    public ArrayList<BumpableEdge> bumpables = new ArrayList();
    public ArrayList<Edge> enemyEmitters = new ArrayList();
    public long constructTime;
    public float originX;
    public float originY;

    public Scene clone() {
        Scene s = new Scene();
        s.update(this);
        return s;
    }

    public void update(Scene scene) {
        this.clearEdges();
        this.add(scene);
        this.originX = scene.originX;
        this.originY = scene.originY;
    }

    public void clearEdges() {
        this.floors.clear();
        this.walls.clear();
        this.ceilings.clear();
        this.bumpables.clear();
        this.enemyEmitters.clear();
    }

    private Scene() {
    }

    public Scene(float originX, float originY) {
        this.originX = originX;
        this.originY = originY;
    }

    public Scene(MarioForwardModel model, int[][] scene) {
        long startTime = System.nanoTime();
        float[] marioPos = model.getMarioFloatPos();
        float f = (float)Math.floor(marioPos[0] / 16.0f) * 16.0f;
        model.getClass();
        this.originX = f - (float)(16 / 2) * 16.0f;
        float f2 = (float)Math.floor(marioPos[1] / 16.0f) * 16.0f;
        model.getClass();
        this.originY = f2 - (float)(16 / 2) * 16.0f;
        boolean[][] visited = new boolean[scene.length][scene[0].length];
        for (int x = 0; x < scene.length; ++x) {
            for (int y = 0; y < scene[x].length; ++y) {
                int tile = scene[x][y];
                if (tile == 7 || visited[y][x]) continue;
                if (Tiles.isWall(tile)) {
                    Scene block = new Scene(this.originX, this.originY);
                    block.expandWall(scene, visited, x, y);
                    this.add(block);
                    continue;
                }
                if (tile != 2) continue;
                Scene ledge = new Scene(this.originX, this.originY);
                ledge.expandLedge(scene, visited, x, y);
                this.add(ledge);
            }
        }
        this.constructTime = System.nanoTime() - startTime;
    }

    private void expandWall(int[][] scene, boolean[][] visited, int x, int y) {
        if (visited[y][x]) {
            return;
        }
        visited[y][x] = true;
        if (x > 0) {
            if (Tiles.isWall(scene[x - 1][y])) {
                this.expandWall(scene, visited, x - 1, y);
            } else {
                this.walls.add(new Edge(this.originX + (float)x * 16.0f, this.originY + (float)y * 16.0f, this.originX + (float)x * 16.0f, this.originY + (float)(y + 1) * 16.0f));
            }
        }
        if (x < scene.length - 1) {
            if (Tiles.isWall(scene[x + 1][y])) {
                this.expandWall(scene, visited, x + 1, y);
            } else {
                this.walls.add(new Edge(this.originX + (float)(x + 1) * 16.0f, this.originY + (float)y * 16.0f, this.originX + (float)(x + 1) * 16.0f, this.originY + (float)(y + 1) * 16.0f));
            }
        }
        if (y > 0) {
            if (Tiles.isWall(scene[x][y - 1])) {
                this.expandWall(scene, visited, x, y - 1);
            } else {
                this.floors.add(new Edge(this.originX + (float)x * 16.0f, this.originY + (float)y * 16.0f, this.originX + (float)(x + 1) * 16.0f, this.originY + (float)y * 16.0f));
            }
        }
        if (y < scene[x].length - 1) {
            if (Tiles.isWall(scene[x][y + 1])) {
                this.expandWall(scene, visited, x, y + 1);
            } else {
                this.ceilings.add(new Edge(this.originX + (float)x * 16.0f, this.originY + (float)(y + 1) * 16.0f, this.originX + (float)(x + 1) * 16.0f, this.originY + (float)(y + 1) * 16.0f));
            }
        }
        this.coalesce();
    }

    private void expandLedge(int[][] scene, boolean[][] visited, int x, int y) {
        if (visited[y][x]) {
            return;
        }
        visited[y][x] = true;
        int startx = x;
        int endx = x;
        while (startx > 0 && scene[startx - 1][y] == 2) {
            visited[y][--startx] = true;
        }
        while (endx < scene.length - 1 && scene[endx + 1][y] == 2) {
            visited[y][++endx] = true;
        }
        this.floors.add(new Edge(this.originX + (float)startx * 16.0f, this.originY + (float)y * 16.0f, this.originX + (float)(endx + 1) * 16.0f, this.originY + (float)y * 16.0f));
    }

    private void coalesce() {
        this.coalesce(this.walls);
        this.coalesce(this.ceilings);
        this.coalesce(this.floors);
        this.coalesce(this.enemyEmitters);
    }

    private void coalesce(ArrayList<Edge> edges) {
        boolean foundOne = true;
        block0: while (foundOne) {
            foundOne = false;
            for (Edge a : edges) {
                for (Edge b : edges) {
                    if (a == b) continue;
                    foundOne = true;
                    if (a.x1 == b.x1 && a.y1 == b.y1) {
                        throw new RuntimeException("Overlapping edges!");
                    }
                    if (a.x1 == b.x2 && a.y1 == b.y2) {
                        a.x1 = b.x1;
                        a.y1 = b.y1;
                    } else if (a.x2 == b.x1 && a.y2 == b.y1) {
                        a.x2 = b.x2;
                        a.y2 = b.y2;
                    } else {
                        foundOne = false;
                    }
                    if (!foundOne) continue;
                    edges.remove(b);
                    break;
                }
                if (!foundOne) continue;
                continue block0;
            }
        }
    }

    private void add(Scene subscene) {
        this.floors.addAll(subscene.floors);
        this.walls.addAll(subscene.walls);
        this.ceilings.addAll(subscene.ceilings);
        this.bumpables.addAll(subscene.bumpables);
        this.enemyEmitters.addAll(subscene.enemyEmitters);
    }
}

