/*
 * Decompiled with CFR 0.152.
 */
package agents.spencerSchumann;

import engine.core.MarioForwardModel;
import java.util.ArrayList;

public class Tiles {
    public static final byte EMPTY = 0;
    public static final byte SOLID = 1;
    public static final byte JUMPTHROUGH = 2;
    public static final byte BRICK = 5;
    public static final byte QUESTION = 6;
    public static final byte COIN = 7;
    public static final byte UNKNOWN = -1;
    ArrayList<Column> columns = new ArrayList();

    public static boolean isWall(int tile) {
        switch (tile) {
            case 1: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    private void setTile(int x, int y, int tile) {
        if (x < 0) {
            return;
        }
        while (x >= this.columns.size()) {
            this.columns.add(null);
        }
        Column c = this.columns.get(x);
        if (c == null) {
            c = new Column();
            this.columns.set(x, c);
        }
        c.setTile(y, tile);
    }

    public int getTile(int x, int y) {
        if (x < 0) {
            return 0;
        }
        if (x >= this.columns.size()) {
            return -1;
        }
        Column c = this.columns.get(x);
        if (c == null) {
            return -1;
        }
        return c.getTile(y);
    }

    public int[][] getScene(int x, int y, int width, int height) {
        int[][] scene = new int[height][width];
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                scene[row][col] = this.getTile(col + x, row + y);
            }
        }
        return scene;
    }

    public void addObservation(MarioForwardModel model) {
        int[][] scene = model.getMarioSceneObservation();
        float[] marioPos = model.getMarioFloatPos();
        int offsetX = (int)(marioPos[0] / 16.0f);
        int offsetY = (int)(marioPos[1] / 16.0f);
        model.getClass();
        offsetX -= 16 / 2;
        model.getClass();
        offsetY -= 16 / 2;
        for (int x = 0; x < scene.length; ++x) {
            for (int y = 0; y < scene[x].length; ++y) {
                int tile = scene[x][y];
                switch (tile) {
                    case 0: {
                        tile = 0;
                        break;
                    }
                    case 17: {
                        tile = 1;
                        break;
                    }
                    case 23: {
                        tile = 5;
                        break;
                    }
                    case 24: {
                        tile = 6;
                        break;
                    }
                    case 31: {
                        tile = 7;
                        break;
                    }
                    case 59: {
                        tile = 2;
                        break;
                    }
                    default: {
                        tile = -1;
                    }
                }
                if (tile == -1) continue;
                this.setTile(x + offsetX, y + offsetY, tile);
            }
        }
    }

    private class Column {
        public int startRow = 0;
        int[] tiles = null;

        private Column() {
        }

        public void setTile(int y, int tile) {
            if (this.tiles == null) {
                this.tiles = new int[1];
                this.tiles[0] = tile;
                this.startRow = y;
            } else {
                if (this.startRow > y) {
                    int expansion = this.startRow - y;
                    int[] newTiles = new int[this.tiles.length + expansion];
                    System.arraycopy(this.tiles, 0, newTiles, expansion, this.tiles.length);
                    for (int i = 0; i < this.startRow; ++i) {
                        newTiles[i] = -1;
                    }
                    this.tiles = newTiles;
                    this.startRow = y;
                } else if (y >= this.startRow + this.tiles.length) {
                    int expansion = y - this.startRow - this.tiles.length + 1;
                    int[] newTiles = new int[this.tiles.length + expansion];
                    System.arraycopy(this.tiles, 0, newTiles, 0, this.tiles.length);
                    for (int i = this.tiles.length; i < newTiles.length; ++i) {
                        newTiles[i] = -1;
                    }
                    this.tiles = newTiles;
                }
                this.tiles[y - this.startRow] = tile;
            }
        }

        public int getTile(int y) {
            if (y < this.startRow || y >= this.startRow + this.tiles.length) {
                return -1;
            }
            return this.tiles[y - this.startRow];
        }
    }
}

