/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.graphics.MarioImage;
import engine.graphics.MarioTilemap;
import engine.helper.Assets;
import engine.helper.SpriteType;
import engine.helper.TileFeature;
import java.awt.Graphics;
import java.util.ArrayList;

public class MarioLevel {
    public int width = 256;
    public int tileWidth = 16;
    public int height = 256;
    public int tileHeight = 16;
    public int totalCoins = 0;
    public int totalEnemies = 0;
    public int totalItems = 0;
    public int marioTileX;
    public int marioTileY;
    public int exitTileX;
    public int exitTileY;
    private ArrayList<int[]> levelTiles;
    private ArrayList<SpriteType[]> spriteTemplates;
    private ArrayList<int[]> lastSpawnTime;
    private ArrayList<boolean[]> solidMap;
    public ArrayList<Integer> enemyNumList;
    private MarioTilemap graphics;
    private MarioImage flag;

    public MarioLevel(String level, boolean visuals) {
        if (level.trim().length() == 0) {
            this.tileWidth = 0;
            this.width = 0;
            this.tileHeight = 0;
            this.height = 0;
            return;
        }
        String[] lines = level.split("\\r?\\n");
        this.tileWidth = lines[0].length();
        this.width = this.tileWidth * 16;
        this.tileHeight = lines.length;
        this.height = this.tileHeight * 16;
        this.levelTiles = new ArrayList();
        this.spriteTemplates = new ArrayList();
        this.lastSpawnTime = new ArrayList();
        this.solidMap = new ArrayList();
        this.enemyNumList = new ArrayList();
        int x = 0;
        while (x < this.tileWidth) {
            this.levelTiles.add(new int[this.tileHeight]);
            this.spriteTemplates.add(new SpriteType[this.tileHeight]);
            this.lastSpawnTime.add(new int[this.tileHeight]);
            this.solidMap.add(new boolean[this.tileHeight]);
            this.enemyNumList.add(0);
            int y = 0;
            while (y < this.tileHeight) {
                this.levelTiles.get((int)x)[y] = 0;
                this.spriteTemplates.get((int)x)[y] = SpriteType.NONE;
                this.lastSpawnTime.get((int)x)[y] = -40;
                this.solidMap.get((int)x)[y] = false;
                ++y;
            }
            ++x;
        }
        boolean marioLocInit = false;
        boolean exitLocInit = false;
        int y = 0;
        while (y < this.tileHeight) {
            int x2 = 0;
            while (x2 < this.tileWidth) {
                Character c = Character.valueOf(lines[y].charAt(x2));
                this.solidMap.get((int)x2)[y] = this.isSolid(c.charValue());
                switch (c.charValue()) {
                    case 'M': {
                        this.marioTileX = x2;
                        this.marioTileY = y;
                        marioLocInit = true;
                        break;
                    }
                    case 'F': {
                        this.exitTileX = x2;
                        this.exitTileY = y;
                        exitLocInit = true;
                        break;
                    }
                    case 'y': {
                        this.spriteTemplates.get((int)x2)[y] = SpriteType.SPIKY;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x2) + 1;
                        this.enemyNumList.set(x2, tmp);
                        break;
                    }
                    case 'Y': {
                        this.spriteTemplates.get((int)x2)[y] = SpriteType.SPIKY_WINGED;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x2) + 1;
                        this.enemyNumList.set(x2, tmp);
                        break;
                    }
                    case 'E': 
                    case 'g': {
                        this.spriteTemplates.get((int)x2)[y] = SpriteType.GOOMBA;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x2) + 1;
                        this.enemyNumList.set(x2, tmp);
                        break;
                    }
                    case 'G': {
                        this.spriteTemplates.get((int)x2)[y] = SpriteType.GOOMBA_WINGED;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x2) + 1;
                        this.enemyNumList.set(x2, tmp);
                        break;
                    }
                    case 'k': {
                        this.spriteTemplates.get((int)x2)[y] = SpriteType.GREEN_KOOPA;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x2) + 1;
                        this.enemyNumList.set(x2, tmp);
                        break;
                    }
                    case 'K': {
                        this.spriteTemplates.get((int)x2)[y] = SpriteType.GREEN_KOOPA_WINGED;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x2) + 1;
                        this.enemyNumList.set(x2, tmp);
                        break;
                    }
                    case 'r': {
                        this.spriteTemplates.get((int)x2)[y] = SpriteType.RED_KOOPA;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x2) + 1;
                        this.enemyNumList.set(x2, tmp);
                        break;
                    }
                    case 'R': {
                        this.spriteTemplates.get((int)x2)[y] = SpriteType.RED_KOOPA_WINGED;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x2) + 1;
                        this.enemyNumList.set(x2, tmp);
                        break;
                    }
                    case 'X': {
                        this.levelTiles.get((int)x2)[y] = 1;
                        break;
                    }
                    case '#': {
                        this.levelTiles.get((int)x2)[y] = 2;
                        break;
                    }
                    case '%': {
                        int tempIndex = 0;
                        if (x2 > 0 && lines[y].charAt(x2 - 1) == '%') {
                            tempIndex += 2;
                        }
                        if (x2 < this.levelTiles.size() - 1 && lines[y].charAt(x2 + 1) == '%') {
                            ++tempIndex;
                        }
                        this.levelTiles.get((int)x2)[y] = 43 + tempIndex;
                        break;
                    }
                    case '|': {
                        this.levelTiles.get((int)x2)[y] = 47;
                        break;
                    }
                    case '*': {
                        int tempIndex = 0;
                        if (y > 0 && lines[y - 1].charAt(x2) == '*') {
                            ++tempIndex;
                        }
                        if (y > 1 && lines[y - 2].charAt(x2) == '*') {
                            ++tempIndex;
                        }
                        this.levelTiles.get((int)x2)[y] = 3 + tempIndex;
                        break;
                    }
                    case 'B': {
                        this.levelTiles.get((int)x2)[y] = 3;
                        break;
                    }
                    case 'b': {
                        int tempIndex = 0;
                        if (y > 1 && lines[y - 2].charAt(x2) == 'B') {
                            ++tempIndex;
                        }
                        this.levelTiles.get((int)x2)[y] = 4 + tempIndex;
                        break;
                    }
                    case '?': 
                    case '@': {
                        this.levelTiles.get((int)x2)[y] = 8;
                        ++this.totalItems;
                        break;
                    }
                    case '!': 
                    case 'Q': {
                        ++this.totalCoins;
                        this.levelTiles.get((int)x2)[y] = 11;
                        ++this.totalItems;
                        break;
                    }
                    case '1': {
                        this.levelTiles.get((int)x2)[y] = 48;
                        ++this.totalItems;
                        break;
                    }
                    case '2': {
                        ++this.totalCoins;
                        this.levelTiles.get((int)x2)[y] = 49;
                        ++this.totalItems;
                        break;
                    }
                    case 'D': {
                        this.levelTiles.get((int)x2)[y] = 14;
                        break;
                    }
                    case 'S': {
                        this.levelTiles.get((int)x2)[y] = 6;
                        break;
                    }
                    case 'C': {
                        ++this.totalCoins;
                        this.levelTiles.get((int)x2)[y] = 7;
                        break;
                    }
                    case 'U': {
                        this.levelTiles.get((int)x2)[y] = 50;
                        ++this.totalItems;
                        break;
                    }
                    case 'L': {
                        this.levelTiles.get((int)x2)[y] = 51;
                        ++this.totalItems;
                        break;
                    }
                    case 'o': {
                        ++this.totalCoins;
                        this.levelTiles.get((int)x2)[y] = 15;
                        break;
                    }
                    case 't': {
                        int tempIndex = 0;
                        boolean singlePipe = !(x2 < lines[y].length() - 1 && Character.toLowerCase(lines[y].charAt(x2 + 1)) == 't' || x2 != 0 && Character.toLowerCase(lines[y].charAt(x2 - 1)) == 't');
                        boolean isRight = y > 0 && (this.levelTiles.get(x2)[y - 1] == 19 || this.levelTiles.get(x2)[y - 1] == 21);
                        boolean bl = isRight = isRight || x2 > 0 && (this.levelTiles.get(x2 - 1)[y] == 18 || this.levelTiles.get(x2 - 1)[y] == 20);
                        if (isRight) {
                            ++tempIndex;
                        }
                        if (y > 0 && Character.toLowerCase(lines[y - 1].charAt(x2)) == 't' && x2 > 0 && this.levelTiles.get(x2 - 1)[y] != 18) {
                            tempIndex = singlePipe ? ++tempIndex : (tempIndex += 2);
                        }
                        if (singlePipe) {
                            this.levelTiles.get((int)x2)[y] = 52 + tempIndex;
                            break;
                        }
                        this.levelTiles.get((int)x2)[y] = 18 + tempIndex;
                        break;
                    }
                    case 'T': {
                        int tempIndex = 0;
                        boolean singlePipe = !(x2 < lines[y].length() - 1 && Character.toLowerCase(lines[y].charAt(x2 + 1)) == 't' || x2 != 0 && Character.toLowerCase(lines[y].charAt(x2 - 1)) == 't');
                        boolean isRight = y > 0 && (this.levelTiles.get(x2)[y - 1] == 19 || this.levelTiles.get(x2)[y - 1] == 21);
                        boolean bl = isRight = isRight || x2 > 0 && (this.levelTiles.get(x2 - 1)[y] == 18 || this.levelTiles.get(x2 - 1)[y] == 20);
                        if (isRight) {
                            ++tempIndex;
                        }
                        if (y > 0 && Character.toLowerCase(lines[y - 1].charAt(x2)) == 't' && x2 > 0 && this.levelTiles.get(x2 - 1)[y] != 18) {
                            tempIndex = singlePipe ? ++tempIndex : (tempIndex += 2);
                        }
                        if (singlePipe) {
                            this.levelTiles.get((int)x2)[y] = 52 + tempIndex;
                            break;
                        }
                        if (tempIndex == 0) {
                            this.spriteTemplates.get((int)x2)[y] = SpriteType.ENEMY_FLOWER;
                        }
                        this.levelTiles.get((int)x2)[y] = 18 + tempIndex;
                        break;
                    }
                    case '<': {
                        this.levelTiles.get((int)x2)[y] = 18;
                        break;
                    }
                    case '>': {
                        this.levelTiles.get((int)x2)[y] = 19;
                        break;
                    }
                    case '[': {
                        this.levelTiles.get((int)x2)[y] = 20;
                        break;
                    }
                    case ']': {
                        this.levelTiles.get((int)x2)[y] = 21;
                    }
                }
                ++x2;
            }
            ++y;
        }
        if (!marioLocInit) {
            this.marioTileX = 0;
            this.marioTileY = this.findFirstFloor(lines, this.marioTileX);
        }
        if (!exitLocInit) {
            this.exitTileX = lines[0].length() - 1;
            this.exitTileY = this.findFirstFloor(lines, this.exitTileX);
        }
        y = this.exitTileY;
        while (y > Math.max(1, this.exitTileY - 11)) {
            this.levelTiles.get((int)this.exitTileX)[y] = 40;
            --y;
        }
        this.levelTiles.get((int)this.exitTileX)[Math.max((int)1, (int)(this.exitTileY - 11))] = 39;
        if (visuals) {
            this.graphics = new MarioTilemap(Assets.level, this.levelTiles);
            this.flag = new MarioImage(Assets.level, 41);
            this.flag.width = 16;
            this.flag.height = 16;
        }
    }

    public MarioLevel clone() {
        MarioLevel level = new MarioLevel("", false);
        level.width = this.width;
        level.height = this.height;
        level.tileWidth = this.tileWidth;
        level.tileHeight = this.tileHeight;
        level.totalCoins = this.totalCoins;
        level.totalEnemies = this.totalEnemies;
        level.totalItems = this.totalItems;
        level.marioTileX = this.marioTileX;
        level.marioTileY = this.marioTileY;
        level.exitTileX = this.exitTileX;
        level.exitTileY = this.exitTileY;
        level.levelTiles = new ArrayList();
        level.lastSpawnTime = new ArrayList();
        level.solidMap = new ArrayList();
        level.enemyNumList = new ArrayList();
        int x = 0;
        while (x < level.tileWidth) {
            level.levelTiles.add(new int[level.tileHeight]);
            level.lastSpawnTime.add(new int[level.tileHeight]);
            level.solidMap.add(new boolean[level.tileHeight]);
            level.enemyNumList.add(this.enemyNumList.get(x));
            int y = 0;
            while (y < level.tileHeight) {
                level.levelTiles.get((int)x)[y] = this.levelTiles.get(x)[y];
                level.lastSpawnTime.get((int)x)[y] = this.lastSpawnTime.get(x)[y];
                level.solidMap.get((int)x)[y] = this.solidMap.get(x)[y];
                ++y;
            }
            ++x;
        }
        level.spriteTemplates = this.spriteTemplates;
        return level;
    }

    public void appendSegment(String segmentStr) {
        if (segmentStr.trim().length() == 0) {
            this.tileWidth = 0;
            this.width = 0;
            this.tileHeight = 0;
            this.height = 0;
            return;
        }
        int x0 = this.tileWidth;
        String[] lines = segmentStr.split("\\r?\\n");
        this.tileWidth += lines[0].length();
        this.width += lines[0].length() * 16;
        boolean exitLocInit = false;
        int x = x0;
        while (x < this.tileWidth) {
            this.levelTiles.add(new int[this.tileHeight]);
            this.spriteTemplates.add(new SpriteType[this.tileHeight]);
            this.lastSpawnTime.add(new int[this.tileHeight]);
            this.solidMap.add(new boolean[this.tileHeight]);
            int relateX = x - x0;
            int y = 0;
            while (y < this.tileHeight) {
                this.levelTiles.get((int)x)[y] = 0;
                this.spriteTemplates.get((int)x)[y] = SpriteType.NONE;
                this.lastSpawnTime.get((int)x)[y] = -40;
                Character c = Character.valueOf(lines[y].charAt(relateX));
                this.solidMap.get((int)x)[y] = this.isSolid(c.charValue());
                switch (c.charValue()) {
                    case 'F': {
                        this.exitTileX = x;
                        this.exitTileY = y;
                        exitLocInit = true;
                        break;
                    }
                    case 'y': {
                        this.spriteTemplates.get((int)x)[y] = SpriteType.SPIKY;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x) + 1;
                        this.enemyNumList.set(x, tmp);
                        break;
                    }
                    case 'Y': {
                        this.spriteTemplates.get((int)x)[y] = SpriteType.SPIKY_WINGED;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x) + 1;
                        this.enemyNumList.set(x, tmp);
                        break;
                    }
                    case 'E': 
                    case 'g': {
                        this.spriteTemplates.get((int)x)[y] = SpriteType.GOOMBA;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x) + 1;
                        this.enemyNumList.set(x, tmp);
                        break;
                    }
                    case 'G': {
                        this.spriteTemplates.get((int)x)[y] = SpriteType.GOOMBA_WINGED;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x) + 1;
                        this.enemyNumList.set(x, tmp);
                        break;
                    }
                    case 'k': {
                        this.spriteTemplates.get((int)x)[y] = SpriteType.GREEN_KOOPA;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x) + 1;
                        this.enemyNumList.set(x, tmp);
                        break;
                    }
                    case 'K': {
                        this.spriteTemplates.get((int)x)[y] = SpriteType.GREEN_KOOPA_WINGED;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x) + 1;
                        this.enemyNumList.set(x, tmp);
                        break;
                    }
                    case 'r': {
                        this.spriteTemplates.get((int)x)[y] = SpriteType.RED_KOOPA;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x) + 1;
                        this.enemyNumList.set(x, tmp);
                        break;
                    }
                    case 'R': {
                        this.spriteTemplates.get((int)x)[y] = SpriteType.RED_KOOPA_WINGED;
                        ++this.totalEnemies;
                        int tmp = this.enemyNumList.get(x) + 1;
                        this.enemyNumList.set(x, tmp);
                        break;
                    }
                    case 'X': {
                        this.levelTiles.get((int)x)[y] = 1;
                        break;
                    }
                    case '#': {
                        this.levelTiles.get((int)x)[y] = 2;
                        break;
                    }
                    case '%': {
                        int tempIndex = 0;
                        if (x > 0 && lines[y].charAt(relateX - 1) == '%') {
                            tempIndex += 2;
                        }
                        if (x < this.levelTiles.size() - 1 && lines[y].charAt(relateX + 1) == '%') {
                            ++tempIndex;
                        }
                        this.levelTiles.get((int)x)[y] = 43 + tempIndex;
                        break;
                    }
                    case '|': {
                        this.levelTiles.get((int)x)[y] = 47;
                        break;
                    }
                    case '*': {
                        int tempIndex = 0;
                        if (y > 0 && lines[y - 1].charAt(relateX) == '*') {
                            ++tempIndex;
                        }
                        if (y > 1 && lines[y - 2].charAt(relateX) == '*') {
                            ++tempIndex;
                        }
                        this.levelTiles.get((int)x)[y] = 3 + tempIndex;
                        break;
                    }
                    case 'B': {
                        this.levelTiles.get((int)x)[y] = 3;
                        break;
                    }
                    case 'b': {
                        int tempIndex = 0;
                        if (y > 1 && lines[y - 2].charAt(relateX) == 'B') {
                            ++tempIndex;
                        }
                        this.levelTiles.get((int)x)[y] = 4 + tempIndex;
                        break;
                    }
                    case '?': 
                    case '@': {
                        this.levelTiles.get((int)x)[y] = 8;
                        ++this.totalItems;
                        break;
                    }
                    case '!': 
                    case 'Q': {
                        ++this.totalCoins;
                        this.levelTiles.get((int)x)[y] = 11;
                        ++this.totalItems;
                        break;
                    }
                    case '1': {
                        this.levelTiles.get((int)x)[y] = 48;
                        ++this.totalItems;
                        break;
                    }
                    case '2': {
                        ++this.totalCoins;
                        this.levelTiles.get((int)x)[y] = 49;
                        ++this.totalItems;
                        break;
                    }
                    case 'D': {
                        this.levelTiles.get((int)x)[y] = 14;
                        break;
                    }
                    case 'S': {
                        this.levelTiles.get((int)x)[y] = 6;
                        break;
                    }
                    case 'C': {
                        ++this.totalCoins;
                        this.levelTiles.get((int)x)[y] = 7;
                        break;
                    }
                    case 'U': {
                        this.levelTiles.get((int)x)[y] = 50;
                        ++this.totalItems;
                        break;
                    }
                    case 'L': {
                        this.levelTiles.get((int)x)[y] = 51;
                        ++this.totalItems;
                        break;
                    }
                    case 'o': {
                        ++this.totalCoins;
                        this.levelTiles.get((int)x)[y] = 15;
                        break;
                    }
                    case 't': {
                        boolean singlePipe;
                        int tempIndex = 0;
                        boolean bl = singlePipe = x < lines[y].length() - 1 && Character.toLowerCase(lines[y].charAt(relateX + 1)) != 't' && x > 0 && Character.toLowerCase(lines[y].charAt(relateX - 1)) != 't';
                        if (x > 0 && (this.levelTiles.get(x - 1)[y] == 18 || this.levelTiles.get(x - 1)[y] == 20)) {
                            ++tempIndex;
                        }
                        if (y > 0 && Character.toLowerCase(lines[y - 1].charAt(relateX)) == 't') {
                            tempIndex = singlePipe ? ++tempIndex : (tempIndex += 2);
                        }
                        if (singlePipe) {
                            this.levelTiles.get((int)x)[y] = 52 + tempIndex;
                            break;
                        }
                        this.levelTiles.get((int)x)[y] = 18 + tempIndex;
                        break;
                    }
                    case 'T': {
                        boolean singlePipe;
                        int tempIndex = 0;
                        boolean bl = singlePipe = x < lines[y].length() - 1 && Character.toLowerCase(lines[y].charAt(relateX + 1)) != 't' && x > 0 && Character.toLowerCase(lines[y].charAt(relateX - 1)) != 't';
                        if (x > 0 && (this.levelTiles.get(x - 1)[y] == 18 || this.levelTiles.get(x - 1)[y] == 20)) {
                            ++tempIndex;
                        }
                        if (y > 0 && Character.toLowerCase(lines[y - 1].charAt(relateX)) == 't') {
                            tempIndex = singlePipe ? ++tempIndex : (tempIndex += 2);
                        }
                        if (singlePipe) {
                            this.levelTiles.get((int)x)[y] = 52 + tempIndex;
                            break;
                        }
                        if (tempIndex == 0) {
                            this.spriteTemplates.get((int)x)[y] = SpriteType.ENEMY_FLOWER;
                        }
                        this.levelTiles.get((int)x)[y] = 18 + tempIndex;
                        break;
                    }
                    case '<': {
                        this.levelTiles.get((int)x)[y] = 18;
                        break;
                    }
                    case '>': {
                        this.levelTiles.get((int)x)[y] = 19;
                        break;
                    }
                    case '[': {
                        this.levelTiles.get((int)x)[y] = 20;
                        break;
                    }
                    case ']': {
                        this.levelTiles.get((int)x)[y] = 21;
                    }
                }
                ++y;
            }
            ++x;
        }
        if (!exitLocInit) {
            this.exitTileX = this.tileWidth - 1;
            this.exitTileY = this.findFirstFloor(lines, this.exitTileX - x0);
        }
        int y = this.exitTileY;
        while (y > Math.max(1, this.exitTileY - 11)) {
            this.levelTiles.get((int)this.exitTileX)[y] = 40;
            --y;
        }
        this.levelTiles.get((int)this.exitTileX)[Math.max((int)1, (int)(this.exitTileY - 11))] = 39;
    }

    public boolean isBlocking(int xTile, int yTile, float xa, float ya) {
        int block = this.getBlock(xTile, yTile);
        ArrayList<TileFeature> features = TileFeature.getTileType(block);
        boolean blocking = features.contains((Object)TileFeature.BLOCK_ALL);
        blocking |= ya < 0.0f && features.contains((Object)TileFeature.BLOCK_UPPER);
        return blocking |= ya > 0.0f && features.contains((Object)TileFeature.BLOCK_LOWER);
    }

    public int getBlock(int xTile, int yTile) {
        if (xTile < 0) {
            xTile = 0;
        }
        if (xTile > this.tileWidth - 1) {
            xTile = this.tileWidth - 1;
        }
        if (yTile < 0 || yTile > this.tileHeight - 1) {
            return 0;
        }
        return this.levelTiles.get(xTile)[yTile];
    }

    public void setBlock(int xTile, int yTile, int index) {
        if (xTile < 0 || yTile < 0 || xTile > this.tileWidth - 1 || yTile > this.tileHeight - 1) {
            return;
        }
        this.levelTiles.get((int)xTile)[yTile] = index;
    }

    public void setShiftIndex(int xTile, int yTile, int shift) {
        if (this.graphics == null || xTile < 0 || yTile < 0 || xTile > this.tileWidth - 1 || yTile > this.tileHeight - 1) {
            return;
        }
        this.graphics.moveShift.get((int)xTile)[yTile] = shift;
    }

    public SpriteType getSpriteType(int xTile, int yTile) {
        if (xTile < 0 || yTile < 0 || xTile >= this.tileWidth || yTile >= this.tileHeight) {
            return SpriteType.NONE;
        }
        return this.spriteTemplates.get(xTile)[yTile];
    }

    public int getLastSpawnTick(int xTile, int yTile) {
        if (xTile < 0 || yTile < 0 || xTile > this.tileWidth - 1 || yTile > this.tileHeight - 1) {
            return 0;
        }
        return this.lastSpawnTime.get(xTile)[yTile];
    }

    public void setLastSpawnTick(int xTile, int yTile, int tick) {
        if (xTile < 0 || yTile < 0 || xTile > this.tileWidth - 1 || yTile > this.tileHeight - 1) {
            return;
        }
        this.lastSpawnTime.get((int)xTile)[yTile] = tick;
    }

    public String getSpriteCode(int xTile, int yTile) {
        try {
            return String.valueOf(xTile) + "_" + yTile + "_" + this.getSpriteType(xTile, yTile).getValue();
        }
        catch (NullPointerException e) {
            System.out.println(this.spriteTemplates);
            return String.valueOf(xTile) + "_" + yTile + "_" + this.getSpriteType(xTile, yTile).getValue();
        }
    }

    private boolean isSolid(char c) {
        return c == 'X' || c == '#' || c == '@' || c == '!' || c == 'B' || c == 'C' || c == 'Q' || c == '<' || c == '>' || c == '[' || c == ']' || c == '?' || c == 'S' || c == 'U' || c == 'D' || c == '%' || c == 't' || c == 'T';
    }

    private int findFirstFloor(String[] lines, int x) {
        boolean skipLines = true;
        int i = lines.length - 1;
        while (i >= 0) {
            Character c = Character.valueOf(lines[i].charAt(x));
            if (this.isSolid(c.charValue())) {
                skipLines = false;
            } else if (!skipLines && !this.isSolid(c.charValue())) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public void update(int cameraX, int cameraY) {
    }

    private void renewExit() {
    }

    public void render(Graphics og, int cameraX, int cameraY) {
        this.graphics.render(og, cameraX, cameraY);
        if (cameraX + 256 >= this.exitTileX * 16) {
            this.flag.render(og, this.exitTileX * 16 - 8 - cameraX, Math.max(1, this.exitTileY - 11) * 16 + 16 - cameraY);
        }
    }

    public boolean standable(int xTile, int yTile) {
        if (yTile >= this.tileHeight) {
            return false;
        }
        return !this.solidMap.get(xTile)[yTile] && this.solidMap.get(xTile)[yTile + 1];
    }
}

