/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.core.MarioAgent;
import engine.core.MarioGame;
import engine.core.MarioResult;

public class MarioLevelModel {
    public static final char MARIO_START = 'M';
    public static final char MARIO_EXIT = 'F';
    public static final char EMPTY = '-';
    public static final char GROUND = 'X';
    public static final char PYRAMID_BLOCK = '#';
    public static final char NORMAL_BRICK = 'S';
    public static final char COIN_BRICK = 'C';
    public static final char LIFE_BRICK = 'L';
    public static final char SPECIAL_BRICK = 'U';
    public static final char SPECIAL_QUESTION_BLOCK = '@';
    public static final char COIN_QUESTION_BLOCK = '!';
    public static final char COIN_HIDDEN_BLOCK = '2';
    public static final char LIFE_HIDDEN_BLOCK = '1';
    public static final char USED_BLOCK = 'D';
    public static final char COIN = 'o';
    public static final char PIPE = 't';
    public static final char PIPE_FLOWER = 'T';
    public static final char BULLET_BILL = '*';
    public static final char PLATFORM_BACKGROUND = '|';
    public static final char PLATFORM = '%';
    public static final char GOOMBA = 'g';
    public static final char GOOMBA_WINGED = 'G';
    public static final char RED_KOOPA = 'r';
    public static final char RED_KOOPA_WINGED = 'R';
    public static final char GREEN_KOOPA = 'k';
    public static final char GREEN_KOOPA_WINGED = 'K';
    public static final char SPIKY = 'y';
    public static final char SPIKY_WINGED = 'Y';
    private char[][] map;

    public static char[] getEnemyTiles() {
        return new char[]{'*', 'T'};
    }

    public static char[] getBumpableTiles() {
        return new char[]{'S', 'C', 'L', 'U', '@', '!'};
    }

    public static char[] getBlockTiles() {
        return new char[]{'X', '#', 'D', 'S', 'C', 'L', 'U', '@', '!', 't', 'T', '*'};
    }

    public static char[] getBlockNonSpecialTiles() {
        return new char[]{'X', '#', 'D', 't'};
    }

    public static char[] getNonBlockingTiles() {
        return new char[]{'o', '2', '1', '|'};
    }

    public static char[] getCollectablesTiles() {
        return new char[]{'o', 'C', 'L', 'U', '@', '!', '2', '1'};
    }

    public static char getWingedEnemyVersion(char enemy, boolean winged) {
        if (!winged) {
            if (enemy == 'G') {
                return 'g';
            }
            if (enemy == 'K') {
                return 'k';
            }
            if (enemy == 'R') {
                return 'r';
            }
            if (enemy == 'Y') {
                return 'y';
            }
            return enemy;
        }
        if (enemy == 'g') {
            return 'G';
        }
        if (enemy == 'k') {
            return 'K';
        }
        if (enemy == 'r') {
            return 'R';
        }
        if (enemy == 'y') {
            return 'Y';
        }
        return enemy;
    }

    public static char[] getEnemyCharacters() {
        return new char[]{'g', 'G', 'r', 'R', 'k', 'K', 'y', 'Y'};
    }

    public static char[] getEnemyCharacters(boolean wings) {
        if (wings) {
            return new char[]{'G', 'R', 'K', 'Y'};
        }
        return new char[]{'g', 'r', 'k', 'y'};
    }

    public MarioLevelModel(int levelWidth, int levelHeight) {
        this.map = new char[levelWidth][levelHeight];
    }

    public MarioLevelModel clone() {
        MarioLevelModel model = new MarioLevelModel(this.getWidth(), this.getHeight());
        int x = 0;
        while (x < model.getWidth()) {
            int y = 0;
            while (y < model.getHeight()) {
                model.map[x][y] = this.map[x][y];
                ++y;
            }
            ++x;
        }
        return model;
    }

    public int getWidth() {
        return this.map.length;
    }

    public int getHeight() {
        return this.map[0].length;
    }

    public char getBlock(int x, int y) {
        int currentX = x;
        int currentY = y;
        if (x < 0) {
            currentX = 0;
        }
        if (y < 0) {
            currentY = 0;
        }
        if (x > this.map.length - 1) {
            currentX = this.map.length - 1;
        }
        if (y > this.map[0].length - 1) {
            currentY = this.map[0].length - 1;
        }
        return this.map[currentX][currentY];
    }

    public void setBlock(int x, int y, char value) {
        if (x < 0 || y < 0 || x > this.map.length - 1 || y > this.map[0].length - 1) {
            return;
        }
        this.map[x][y] = value;
    }

    public void setRectangle(int startX, int startY, int width, int height, char value) {
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                this.setBlock(startX + x, startY + y, value);
                ++y;
            }
            ++x;
        }
    }

    public void copyFromString(String level) {
        this.copyFromString(0, 0, 0, 0, this.getWidth(), this.getHeight(), level);
    }

    public void copyFromString(int targetX, int targetY, int sourceX, int sourceY, int width, int height, String level) {
        String[] lines = level.split("\n");
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int maxWidth = lines[0].length();
                int maxHeight = lines.length;
                this.setBlock(x + targetX, y + targetY, lines[Math.min(y + sourceY, maxHeight - 1)].charAt(Math.min(x + sourceX, maxWidth - 1)));
                ++x;
            }
            ++y;
        }
    }

    public void clearMap() {
        this.setRectangle(0, 0, this.getWidth(), this.getHeight(), '-');
    }

    public String getMap() {
        String result = "";
        int y = 0;
        while (y < this.map[0].length) {
            int x = 0;
            while (x < this.map.length) {
                result = String.valueOf(result) + this.map[x][y];
                ++x;
            }
            result = String.valueOf(result) + "\n";
            ++y;
        }
        return result;
    }

    public MarioResult testALevelWithAgent(MarioAgent agent, int timer) {
        MarioGame game = new MarioGame();
        return game.runGame(agent, this.getMap(), timer);
    }
}

