/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import agents.human.Agent;
import engine.core.MarioAgent;
import engine.core.MarioAgentEvent;
import engine.core.MarioEvent;
import engine.core.MarioForwardModel;
import engine.core.MarioRender;
import engine.core.MarioResult;
import engine.core.MarioTimer;
import engine.core.MarioWorld;
import engine.helper.GameStatus;
import engine.helper.MarioActions;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import javax.swing.JFrame;

public class MarioOnlineGenGame {
    public static final long maxTime = 40L;
    public static final long graceTime = 10L;
    public static final int width = 256;
    public static final int height = 256;
    public static final int tileWidth = 16;
    public static final int tileHeight = 16;
    public static final int timerCoefficient = 50;
    private MarioEvent[] killEvents;
    private MarioAgent agent = null;
    private MarioWorld world = new MarioWorld(null);
    private ArrayList<MarioEvent> gameEvents;
    private ArrayList<MarioAgentEvent> agentEvents;
    private MarioTimer agentTimer;
    private final boolean visual;
    private JFrame window = null;
    private MarioRender render = null;
    private VolatileImage renderTarget = null;
    private Graphics backBuffer = null;
    private Graphics currentBuffer = null;
    private boolean verbose = false;

    public MarioOnlineGenGame(String levelStr) {
        this(levelStr, new Agent(), true);
    }

    public MarioOnlineGenGame(String levelStr, MarioAgent agent) {
        this(levelStr, agent, false);
    }

    public MarioOnlineGenGame(String levelStr, MarioAgent agent, boolean visual) {
        this.world.visuals = visual;
        if (visual) {
            this.window = new JFrame("Mario AI Framework");
            this.render = new MarioRender(2.0f);
            this.window.setContentPane(this.render);
            this.window.pack();
            this.window.setResizable(false);
            this.window.setDefaultCloseOperation(3);
            this.render.init();
            this.window.setVisible(true);
            this.world.initializeVisuals(this.render.getGraphicsConfiguration());
        }
        this.world.initializeLevel(levelStr, 50 * levelStr.length());
        this.world.mario.isLarge = false;
        this.world.mario.isFire = false;
        this.world.update(new boolean[MarioActions.numberOfActions()]);
        this.gameEvents = new ArrayList();
        this.agentEvents = new ArrayList();
        this.visual = visual;
        this.setAgent(agent);
        if (this.agent != null) {
            this.agentTimer = new MarioTimer(40L);
            this.agent.initialize(new MarioForwardModel(this.world.clone()), this.agentTimer);
        }
        if (visual) {
            this.renderTarget = this.render.createVolatileImage(256, 256);
            this.backBuffer = this.render.getGraphics();
            this.currentBuffer = this.renderTarget.getGraphics();
            this.render.addFocusListener(this.render);
        }
    }

    public boolean gameStep() {
        if (this.world.gameStatus == GameStatus.RUNNING) {
            this.agentTimer = new MarioTimer(40L);
            boolean[] actions = this.agent.getActions(new MarioForwardModel(this.world.clone()), this.agentTimer);
            this.world.update(actions);
            this.gameEvents.addAll(this.world.lastFrameEvents);
            this.agentEvents.add(new MarioAgentEvent(actions, this.world.mario.x, this.world.mario.y, (this.world.mario.isLarge ? 1 : 0) + (this.world.mario.isFire ? 1 : 0), this.world.mario.onGround, this.world.currentTick));
            if (this.visual) {
                this.render.renderWorld(this.world, this.renderTarget, this.backBuffer, this.currentBuffer, this.verbose);
            }
            return false;
        }
        return true;
    }

    public MarioResult getResult() {
        return new MarioResult(this.world, this.gameEvents, this.agentEvents);
    }

    public void appendSegment(String segmentStr) {
        this.world.appendLevelSegment(segmentStr);
    }

    private void setAgent(MarioAgent agent) {
        this.agent = agent;
        if (agent instanceof KeyAdapter) {
            this.render.addKeyListener((KeyAdapter)((Object)this.agent));
        }
    }

    public int getTileDistantToExit() {
        return this.world.level.exitTileX - this.getMarioTileX();
    }

    public float getMarioX() {
        return this.world.mario.x;
    }

    public int getMarioTileX() {
        return (int)this.world.mario.x / 16;
    }
}

