/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.core.MarioWorld;
import engine.helper.Assets;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;

public class MarioRender
extends JComponent
implements FocusListener {
    private static final long serialVersionUID = 790878775993203817L;
    public static final int TICKS_PER_SECOND = 24;
    private float scale;
    private GraphicsConfiguration graphicsConfiguration;
    int frame;
    Thread animator;
    boolean focused;

    public MarioRender(float scale) {
        this.setFocusable(true);
        this.setEnabled(true);
        this.scale = scale;
        Dimension size = new Dimension((int)(256.0f * scale), (int)(240.0f * scale));
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setFocusable(true);
    }

    public void init() {
        this.graphicsConfiguration = this.getGraphicsConfiguration();
        Assets.init(this.graphicsConfiguration);
    }

    public void renderWorld(MarioWorld world, Image image, Graphics g, Graphics og, boolean verbose) {
        og.fillRect(0, 0, 256, 240);
        world.render(og);
        this.drawStringDropShadow(og, String.format("Lives:%d", world.lives), 0, 0, 7);
        this.drawStringDropShadow(og, "Time:" + (world.currentTimer == -1 ? "Inf" : Integer.valueOf((int)Math.ceil((float)world.currentTimer / 1000.0f))), 22, 0, 7);
        if (verbose) {
            this.drawStringDropShadow(og, String.format("Deaths:%d", world.deaths), 11, 0, 7);
            this.drawStringDropShadow(og, String.format("Kills:%d", world.kills), 0, 1, 7);
            this.drawStringDropShadow(og, String.format("Coins:%d", world.coins), 11, 1, 7);
            this.drawStringDropShadow(og, String.format("Items:%d", world.items), 22, 1, 7);
            this.drawStringDropShadow(og, String.format("Air Time:%d", world.airTime), 0, 2, 7);
            this.drawStringDropShadow(og, String.format("Jumps:%d", world.jumps), 22, 2, 7);
        }
        if (this.scale > 1.0f) {
            g.drawImage(image, 0, 0, (int)(256.0f * this.scale), (int)(240.0f * this.scale), null);
        } else {
            g.drawImage(image, 0, 0, null);
        }
    }

    public void drawStringDropShadow(Graphics g, String text, int x, int y, int c) {
        this.drawString(g, text, x * 8 + 5, y * 8 + 5, 0);
        this.drawString(g, text, x * 8 + 4, y * 8 + 4, c);
    }

    private void drawString(Graphics g, String text, int x, int y, int c) {
        char[] ch = text.toCharArray();
        int i = 0;
        while (i < ch.length) {
            g.drawImage(Assets.font[ch[i] - 32][c], x + i * 8, y, null);
            ++i;
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.focused = true;
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.focused = false;
    }
}

