/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.effects.DeathEffect;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.EventType;
import engine.helper.SpriteType;
import engine.sprites.Fireball;
import engine.sprites.Shell;
import java.awt.Graphics;

public class BulletBill
extends MarioSprite {
    private MarioImage graphics;

    public BulletBill(boolean visuals, float x, float y, int dir) {
        super(x, y, SpriteType.BULLET_BILL);
        this.width = 4;
        this.height = 12;
        this.ya = -5.0f;
        this.facing = dir;
        if (visuals) {
            this.graphics = new MarioImage(Assets.enemies, 40);
            this.graphics.originX = 8;
            this.graphics.originY = 31;
            this.graphics.width = 16;
        }
    }

    @Override
    public MarioSprite clone() {
        BulletBill sprite = new BulletBill(false, this.x, this.y, this.facing);
        sprite.xa = this.xa;
        sprite.ya = this.ya;
        sprite.width = this.width;
        sprite.height = this.height;
        return sprite;
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        super.update();
        float sideWaysSpeed = 4.0f;
        this.xa = (float)this.facing * sideWaysSpeed;
        this.move(this.xa, 0.0f);
        if (this.graphics != null) {
            this.graphics.flipX = this.facing == -1;
        }
    }

    @Override
    public void render(Graphics og) {
        super.render(og);
        this.graphics.render(og, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
    }

    @Override
    public void collideCheck() {
        if (!this.alive) {
            return;
        }
        float xMarioD = this.world.mario.x - this.x;
        float yMarioD = this.world.mario.y - this.y;
        if (xMarioD > -16.0f && xMarioD < 16.0f && yMarioD > (float)(-this.height) && yMarioD < (float)this.world.mario.height) {
            if (this.world.mario.ya > 0.0f && yMarioD <= 0.0f && (!this.world.mario.onGround || !this.world.mario.wasOnGround)) {
                this.world.mario.stomp(this);
                if (this.graphics != null) {
                    this.world.addEffect(new DeathEffect(this.x, this.y - 7.0f, this.graphics.flipX, 43, 0.0f));
                }
                this.world.removeSprite(this);
            } else {
                this.world.addEvent(EventType.HURT, this.type.getValue());
                this.world.mario.getHurt();
            }
        }
    }

    private boolean move(float xa, float ya) {
        this.x += xa;
        return true;
    }

    @Override
    public boolean fireballCollideCheck(Fireball fireball) {
        if (!this.alive) {
            return false;
        }
        float xD = fireball.x - this.x;
        float yD = fireball.y - this.y;
        if (xD > -16.0f && xD < 16.0f) {
            return yD > (float)(-this.height) && yD < (float)fireball.height;
        }
        return false;
    }

    @Override
    public boolean shellCollideCheck(Shell shell) {
        if (!this.alive) {
            return false;
        }
        float xD = shell.x - this.x;
        float yD = shell.y - this.y;
        if (xD > -16.0f && xD < 16.0f && yD > (float)(-this.height) && yD < (float)shell.height) {
            if (this.graphics != null) {
                this.world.addEffect(new DeathEffect(this.x, this.y - 7.0f, this.graphics.flipX, 43, -1.0f));
            }
            this.world.addEvent(EventType.SHELL_KILL, this.type.getValue());
            this.world.removeSprite(this);
            return true;
        }
        return false;
    }
}

