/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.SpriteType;
import java.awt.Graphics;

public class Fireball
extends MarioSprite {
    private static final float GROUND_INERTIA = 0.89f;
    private static final float AIR_INERTIA = 0.89f;
    private boolean onGround = false;
    private MarioImage graphics;
    private int anim = 0;

    public Fireball(boolean visuals, float x, float y, int facing) {
        super(x, y, SpriteType.FIREBALL);
        this.facing = facing;
        this.ya = 4.0f;
        this.width = 4;
        this.height = 8;
        if (visuals) {
            this.graphics = new MarioImage(Assets.particles, 24);
            this.graphics.originX = 8;
            this.graphics.originY = 8;
            this.graphics.width = 16;
            this.graphics.height = 16;
        }
    }

    @Override
    public MarioSprite clone() {
        Fireball f = new Fireball(false, this.x, this.y, this.facing);
        f.xa = this.xa;
        f.ya = this.ya;
        f.initialCode = this.initialCode;
        f.width = this.width;
        f.height = this.height;
        f.onGround = this.onGround;
        return f;
    }

    private boolean move(float xa, float ya) {
        while (xa > 8.0f) {
            if (!this.move(8.0f, 0.0f)) {
                return false;
            }
            xa -= 8.0f;
        }
        while (xa < -8.0f) {
            if (!this.move(-8.0f, 0.0f)) {
                return false;
            }
            xa += 8.0f;
        }
        while (ya > 8.0f) {
            if (!this.move(0.0f, 8.0f)) {
                return false;
            }
            ya -= 8.0f;
        }
        while (ya < -8.0f) {
            if (!this.move(0.0f, -8.0f)) {
                return false;
            }
            ya += 8.0f;
        }
        boolean collide = false;
        if (ya > 0.0f) {
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya, xa, 0.0f)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya, xa, 0.0f)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya + 1.0f, xa, ya)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya + 1.0f, xa, ya)) {
                collide = true;
            }
        }
        if (ya < 0.0f) {
            if (this.isBlocking(this.x + xa, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
        }
        if (xa > 0.0f) {
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)(this.height / 2), xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya, xa, ya)) {
                collide = true;
            }
        }
        if (xa < 0.0f) {
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)(this.height / 2), xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya, xa, ya)) {
                collide = true;
            }
        }
        if (collide) {
            if (xa < 0.0f) {
                this.x = (int)((this.x - (float)this.width) / 16.0f) * 16 + this.width;
                this.xa = 0.0f;
            }
            if (xa > 0.0f) {
                this.x = (int)((this.x + (float)this.width) / 16.0f + 1.0f) * 16 - this.width - 1;
                this.xa = 0.0f;
            }
            if (ya < 0.0f) {
                this.y = (int)((this.y - (float)this.height) / 16.0f) * 16 + this.height;
                this.ya = 0.0f;
            }
            if (ya > 0.0f) {
                this.y = (int)(this.y / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += xa;
        this.y += ya;
        return true;
    }

    private boolean isBlocking(float _x, float _y, float xa, float ya) {
        int x = (int)(_x / 16.0f);
        int y = (int)(_y / 16.0f);
        if (x == (int)(this.x / 16.0f) && y == (int)(this.y / 16.0f)) {
            return false;
        }
        boolean blocking = this.world.level.isBlocking(x, y, xa, ya);
        return blocking;
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        if (this.facing != 0) {
            ++this.anim;
        }
        float sideWaysSpeed = 8.0f;
        if (this.xa > 2.0f) {
            this.facing = 1;
        }
        if (this.xa < -2.0f) {
            this.facing = -1;
        }
        this.xa = (float)this.facing * sideWaysSpeed;
        this.world.checkFireballCollide(this);
        if (!this.move(this.xa, 0.0f)) {
            this.world.removeSprite(this);
            return;
        }
        this.onGround = false;
        this.move(0.0f, this.ya);
        if (this.onGround) {
            this.ya = -10.0f;
        }
        this.ya *= 0.95f;
        this.xa = this.onGround ? (this.xa *= 0.89f) : (this.xa *= 0.89f);
        if (!this.onGround) {
            this.ya = (float)((double)this.ya + 1.5);
        }
        if (this.graphics != null) {
            this.graphics.flipX = this.facing == -1;
            this.graphics.index = 24 + this.anim % 4;
        }
    }

    @Override
    public void render(Graphics og) {
        super.render(og);
        this.graphics.render(og, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
    }
}

