/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.helper.SpriteType;
import engine.sprites.Enemy;

public class FlowerEnemy
extends Enemy {
    private float yStart;
    private int tick;
    private int waitTime;

    public FlowerEnemy(boolean visuals, float x, float y) {
        super(visuals, x, y, 0, SpriteType.ENEMY_FLOWER);
        this.winged = false;
        this.noFireballDeath = false;
        this.width = 2;
        this.yStart = this.y;
        this.ya = -1.0f;
        this.y -= 1.0f;
        int i = 0;
        while (i < 4) {
            this.update();
            ++i;
        }
        if (visuals) {
            this.graphics.originY = 24;
            this.tick = 0;
        }
    }

    @Override
    public MarioSprite clone() {
        FlowerEnemy sprite = new FlowerEnemy(false, this.x, this.y);
        sprite.xa = this.xa;
        sprite.ya = this.ya;
        sprite.initialCode = this.initialCode;
        sprite.width = this.width;
        sprite.height = this.height;
        sprite.onGround = this.onGround;
        sprite.winged = this.winged;
        sprite.avoidCliffs = this.avoidCliffs;
        sprite.noFireballDeath = this.noFireballDeath;
        sprite.yStart = this.yStart;
        sprite.waitTime = this.waitTime;
        return sprite;
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        if (this.ya > 0.0f) {
            if (this.y >= this.yStart) {
                this.y = this.yStart;
                int xd = (int)Math.abs(this.world.mario.x - this.x);
                ++this.waitTime;
                if (this.waitTime > 40 && xd > 24) {
                    this.waitTime = 0;
                    this.ya = -1.0f;
                }
            }
        } else if (this.ya < 0.0f && this.yStart - this.y > 20.0f) {
            this.y = this.yStart - 20.0f;
            ++this.waitTime;
            if (this.waitTime > 40) {
                this.waitTime = 0;
                this.ya = 1.0f;
            }
        }
        this.y += this.ya;
        if (this.graphics != null) {
            ++this.tick;
            this.graphics.index = this.type.getStartIndex() + (this.tick / 2 & 1) * 2 + (this.tick / 6 & 1);
        }
    }
}

