/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.effects.DeathEffect;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.EventType;
import engine.helper.SpriteType;
import engine.sprites.Fireball;
import java.awt.Graphics;

public class Shell
extends MarioSprite {
    private static final float GROUND_INERTIA = 0.89f;
    private static final float AIR_INERTIA = 0.89f;
    private int shellType = 0;
    private boolean onGround = false;
    private MarioImage graphics;

    public Shell(boolean visuals, float x, float y, int shellType, String spriteCode) {
        super(x, y, SpriteType.SHELL);
        this.width = 4;
        this.height = 12;
        this.facing = 0;
        this.ya = -5.0f;
        this.shellType = shellType;
        this.initialCode = spriteCode;
        if (visuals) {
            this.graphics = new MarioImage(Assets.enemies, shellType * 8 + 3);
            this.graphics.originX = 8;
            this.graphics.originY = 31;
            this.graphics.width = 16;
        }
    }

    @Override
    public MarioSprite clone() {
        Shell sprite = new Shell(false, this.x, this.y, this.shellType, this.initialCode);
        sprite.xa = this.xa;
        sprite.ya = this.ya;
        sprite.width = this.width;
        sprite.height = this.height;
        sprite.facing = this.facing;
        sprite.onGround = this.onGround;
        return sprite;
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        super.update();
        float sideWaysSpeed = 11.0f;
        if (this.xa > 2.0f) {
            this.facing = 1;
        }
        if (this.xa < -2.0f) {
            this.facing = -1;
        }
        this.xa = (float)this.facing * sideWaysSpeed;
        if (this.facing != 0) {
            this.world.checkShellCollide(this);
        }
        if (!this.move(this.xa, 0.0f)) {
            this.facing = -this.facing;
        }
        this.onGround = false;
        this.move(0.0f, this.ya);
        this.ya *= 0.85f;
        this.xa = this.onGround ? (this.xa *= 0.89f) : (this.xa *= 0.89f);
        if (!this.onGround) {
            this.ya += 2.0f;
        }
        if (this.graphics != null) {
            this.graphics.flipX = this.facing == -1;
        }
    }

    @Override
    public void render(Graphics og) {
        super.render(og);
        this.graphics.render(og, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
    }

    @Override
    public boolean fireballCollideCheck(Fireball fireball) {
        if (!this.alive) {
            return false;
        }
        float xD = fireball.x - this.x;
        float yD = fireball.y - this.y;
        if (xD > -16.0f && xD < 16.0f && yD > (float)(-this.height) && yD < (float)fireball.height) {
            if (this.facing != 0) {
                return true;
            }
            this.xa = fireball.facing * 2;
            this.ya = -5.0f;
            if (this.graphics != null) {
                this.world.addEffect(new DeathEffect(this.x, this.y, this.graphics.flipX, 41 + this.shellType, -5.0f));
            }
            this.world.removeSprite(this);
            return true;
        }
        return false;
    }

    @Override
    public void collideCheck() {
        if (!this.alive) {
            return;
        }
        float xMarioD = this.world.mario.x - this.x;
        float yMarioD = this.world.mario.y - this.y;
        if (xMarioD > -16.0f && xMarioD < 16.0f && yMarioD > (float)(-this.height) && yMarioD < (float)this.world.mario.height) {
            if (this.world.mario.ya > 0.0f && yMarioD <= 0.0f && (!this.world.mario.onGround || !this.world.mario.wasOnGround)) {
                this.world.mario.stomp(this);
                if (this.facing != 0) {
                    this.xa = 0.0f;
                    this.facing = 0;
                } else {
                    this.facing = this.world.mario.facing;
                }
            } else if (this.facing != 0) {
                this.world.addEvent(EventType.HURT, this.type.getValue());
                this.world.mario.getHurt();
            } else {
                this.world.addEvent(EventType.KICK, this.type.getValue());
                this.world.mario.kick(this);
                this.facing = this.world.mario.facing;
            }
        }
    }

    private boolean move(float xa, float ya) {
        while (xa > 8.0f) {
            if (!this.move(8.0f, 0.0f)) {
                return false;
            }
            xa -= 8.0f;
        }
        while (xa < -8.0f) {
            if (!this.move(-8.0f, 0.0f)) {
                return false;
            }
            xa += 8.0f;
        }
        while (ya > 8.0f) {
            if (!this.move(0.0f, 8.0f)) {
                return false;
            }
            ya -= 8.0f;
        }
        while (ya < -8.0f) {
            if (!this.move(0.0f, -8.0f)) {
                return false;
            }
            ya += 8.0f;
        }
        boolean collide = false;
        if (ya > 0.0f) {
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya, xa, 0.0f)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya, xa, 0.0f)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya + 1.0f, xa, ya)) {
                collide = true;
            } else if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya + 1.0f, xa, ya)) {
                collide = true;
            }
        }
        if (ya < 0.0f) {
            if (this.isBlocking(this.x + xa, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            } else if (collide || this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
        }
        if (xa > 0.0f) {
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya - (float)(this.height / 2), xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa + (float)this.width, this.y + ya, xa, ya)) {
                collide = true;
            }
        }
        if (xa < 0.0f) {
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)this.height, xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya - (float)(this.height / 2), xa, ya)) {
                collide = true;
            }
            if (this.isBlocking(this.x + xa - (float)this.width, this.y + ya, xa, ya)) {
                collide = true;
            }
        }
        if (collide) {
            if (xa < 0.0f) {
                this.x = (int)((this.x - (float)this.width) / 16.0f) * 16 + this.width;
                this.xa = 0.0f;
            }
            if (xa > 0.0f) {
                this.x = (int)((this.x + (float)this.width) / 16.0f + 1.0f) * 16 - this.width - 1;
                this.xa = 0.0f;
            }
            if (ya < 0.0f) {
                this.y = (int)((this.y - (float)this.height) / 16.0f) * 16 + this.height;
                this.ya = 0.0f;
            }
            if (ya > 0.0f) {
                this.y = (int)(this.y / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += xa;
        this.y += ya;
        return true;
    }

    private boolean isBlocking(float _x, float _y, float xa, float ya) {
        int x = (int)(_x / 16.0f);
        int y = (int)(_y / 16.0f);
        if (x == (int)(this.x / 16.0f) && y == (int)(this.y / 16.0f)) {
            return false;
        }
        boolean blocking = this.world.level.isBlocking(x, y, xa, ya);
        if (blocking && ya == 0.0f && xa != 0.0f) {
            this.world.bump(x, y, true);
        }
        return blocking;
    }

    @Override
    public void bumpCheck(int xTile, int yTile) {
        if (!this.alive) {
            return;
        }
        if (this.x + (float)this.width > (float)(xTile * 16) && this.x - (float)this.width < (float)(xTile * 16 + 16) && yTile == (int)((this.y - 1.0f) / 16.0f)) {
            this.facing = -this.world.mario.facing;
            this.ya = -10.0f;
        }
    }

    @Override
    public boolean shellCollideCheck(Shell shell) {
        if (!this.alive) {
            return false;
        }
        float xD = shell.x - this.x;
        float yD = shell.y - this.y;
        if (xD > -16.0f && xD < 16.0f && yD > (float)(-this.height) && yD < (float)shell.height) {
            this.world.addEvent(EventType.SHELL_KILL, this.type.getValue());
            if (this != shell) {
                this.world.removeSprite(shell);
            }
            this.world.removeSprite(this);
            return true;
        }
        return false;
    }
}

