import random
import numpy as np


class RingQueue:
    def __init__(self, capacity):
        self.main = []
        self.p = 0
        self.capacity = capacity

    def push(self, item):
        if len(self.main) < self.capacity:
            self.main.append(item)
        else:
            self.main[self.p] = item
        self.p = (self.p + 1) % self.capacity

    def rear(self):
        if len(self.main) < self.capacity:
            return self.main[-1]
        else:
            return self.main[(self.p - 1) % self.capacity]

    def front(self):
        if len(self.main) < self.capacity:
            return self.main[0]
        else:
            return self.main[self.p]

    def to_list(self):
        return self.main[self.p:] + self.main[:self.p]

    def clear(self):
        self.main.clear()
        self.p = 0

    def __len__(self):
        return len(self.main)

    def full(self):
        return len(self.main) == self.capacity

    def empty(self):
        return len(self.main) == 0

def deepget(data, *keys):
    res = data
    for k in keys:
        res = res[k]
    return res

def multiget(data, *keys):
    return tuple(data[k] for k in keys)

def recursive_update(base, update):
    for key, value in update.items():
        if isinstance(value, dict) and key in base:
            recursive_update(base[key], value)
        else:
            base[key] = value

