from PIL import Image
from math import ceil
from myutils.filesys import gp


# def vsplit_img(img, w, lw=6, lcolor='white', save_path='./image.png'):
#     n = ceil(img.get_width() / w)
#     h = img.get_height()
#     canvas = pygame.Surface((img.get_width() + (n-1) * lw, h))
#     canvas.fill(lcolor)
#     for i in range(n):
#         canvas.blit(img.subsurface(i*w, 0, min(w, img.get_width()-i*w), h), (i*(w + lw), 0))
#     pygame.image.save(canvas, gp(save_path))
#     pass


def make_img_sheet(imgs, ncols, x_margin=6, y_margin=6, margin_color='white', save_path='./image.png'):
    nrows = ceil(len(imgs) / ncols)
    w, h = imgs[0].size

    canvas = Image.new('RGBA', ((w + x_margin) * ncols - x_margin, (h + y_margin) * nrows - y_margin), 'white')
    # canvas.fill(margin_color)
    for i in range(len(imgs)):
        row_id, col_id = i // ncols, i % ncols
        x, y = (w + x_margin) * col_id, (h + y_margin) * row_id
        canvas.paste(imgs[i], (x, y))

    canvas.save(gp(save_path))

