import numpy as np
from scipy.stats import entropy


def a_clip(v, g, r=1.0):
    return min(r, 1 - abs(v - g) / g)

def jsdiv(p, q):
    return (entropy(p, p + q, base=2) + entropy(q, p + q, base=2)) / 2

def box_to_euc(x):
    r = np.abs(x).max() / np.linalg.vector_norm(x)
    return x * r

def euc_clip(x, maximum):
    m = np.linalg.vector_norm(x)
    r = 1.0 if m <= maximum else maximum / m
    return x * r

def euc_clip_box(x, maximum):
    return euc_clip(box_to_euc(x), maximum)

