import torch


def polyak_update(params, target_params, tau) -> None:
    with torch.no_grad():
        for param, target_param in zip(params, target_params):
            target_param.data.mul_(1 - tau)
            torch.add(target_param.data, param.data, alpha=tau, out=target_param.data)


class PeriodicTrigger:
    def __init__(self, itv):
        self.itv = itv
        self.remain = itv

    def step(self, delta=1):
        if self.remain > 0:
            self.remain -= delta
        if self.remain <= 0:
            self.remain += self.itv
            return True
        return False

