import glob
import argparse
import itertools as itt
from myutils.filesys import gp
from analysis.eval import eval_robustness, eval_robustness_throughout_learning


# TODO: argumentparse based running like in train.py

def eval_point_maze_robustness(_args):
    root = 'formal' if _args.formal else 'data'
    for folder in glob.glob(gp(root, 'PointMaze', _args.level, _args.algo, 'trial*')):
        eval_robustness(folder, f'cuda:{_args.gpuid}')

def eval_point_maze_robustness_learning(_args):
    root = 'formal' if _args.formal else 'data'
    for folder in glob.glob(gp(root, 'PointMaze', _args.level, _args.algo, 'trial*')):
        eval_robustness_throughout_learning(folder, f'cuda:{_args.gpuid}')

def set_argparser(_parser):
    subparsers = _parser.add_subparsers()

    subparser = subparsers.add_parser('robustness', help=f'Evaluate robustness in multi-goal navigation envs')
    subparser.add_argument("--level", type=str)
    subparser.add_argument("--algo", type=str, default='')
    subparser.add_argument("--gpuid", type=int, default=0)
    subparser.add_argument("--formal", action='store_true')
    subparser.set_defaults(foo=eval_point_maze_robustness)

    subparser = subparsers.add_parser('robustness_learning', help=f'Evaluate robustness with respect to learning steps')
    subparser.add_argument("--level", type=str)
    subparser.add_argument("--algo", type=str, default='')
    subparser.add_argument("--gpuid", type=int, default=0)
    subparser.add_argument("--formal", action='store_true')
    subparser.set_defaults(foo=eval_point_maze_robustness_learning)
    return parser
    # subparser = setup(subparser, algo)    


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    set_argparser(parser)
    args = parser.parse_args()
    args.foo(args)
    # eval_point_maze_robustness()
