function [op_norm_buf_avg_ER_revBuf,op_norm_buf_tavg_ER_revBuf,...
    op_norm_buf_avg_ER_randBuf,op_norm_buf_tavg_ER_randBuf,...
    op_norm_avg_ER_noBuf,op_norm_tavg_ER_noBuf,op_norm_ols]...
    =AR_algos_compare_neurips(A0,X0,T1,d,sig,A_true,B,u,T1_eff,n_samples_norm_est,tavg_start)
% T1 is the number of buffers


T=T1*(B+u);
A_prev_rev=A0;
A_prev_rand=A0;
A_prev_noBuf=A0;
X_prev=X0;
A_buf_avg_ER_revBuf=A0;%full average of end points of each buffer
A_buf_tavg_ER_revBuf=A0;%tail average of end points of each buffer
A_buf_avg_ER_randBuf=A0;
A_buf_tavg_ER_randBuf=A0;
A_avg_ER_noBuf=A0;
A_tavg_ER_noBuf=A0;


op_norm_buf_tavg_ER_revBuf=norm(A0-A_true)*ones(1,T1);
op_norm_buf_avg_ER_revBuf=norm(A0-A_true)*ones(1,T1);
op_norm_buf_tavg_ER_randBuf=norm(A0-A_true)*ones(1,T1);
op_norm_buf_avg_ER_randBuf=norm(A0-A_true)*ones(1,T1);
op_norm_tavg_ER_noBuf=norm(A0-A_true)*ones(1,T1);
op_norm_avg_ER_noBuf=norm(A0-A_true)*ones(1,T1);
op_norm_ols=norm(A0-A_true)*ones(1,T1);





%to estimate R=max_t (norm(X_t)^2)
%use log T samples to estimate
norm_sum_X=0;
%need to generate (B+u)*(floor(n_samples_norm_est/(B+u))+1) samples
X=gen_data_ar(d,X_prev,A_true,sig,(B+u)*(floor(n_samples_norm_est/(B+u))+1));%function to generate samples from VAR

for i=1:n_samples_norm_est %using only n_samples_norm_est for norm estimation
    norm_sum_X=norm_sum_X+norm(X(:,i))^2;
end
R=norm_sum_X;
eta=0.5*(max(1/R,1/T));%step size for SGD-RER
X1_sum=zeros(d,d);
X2_sum=zeros(d,d);

for t0=1:(floor(n_samples_norm_est/(B+u))+1)
    for i=1:B+u
        X1_sum=X1_sum+X(:,(t0-1)*(B+u)+i)*(X(:,(t0-1)*(B+u)+i))';
        X2_sum=X2_sum+X(:,(t0-1)*(B+u)+i)*(X(:,(t0-1)*(B+u)+i+1))';
    end
    
    diff=(X1_sum)\(X2_sum);
    A_ols=diff';
    op_norm_ols(t0)=norm(A_ols-A_true);
end


X_prev=X(:,end);


for t=1:T1_eff
    
    X=gen_data_ar(d,X_prev,A_true,sig,B+u);
    
    perm_rev=B:-1:1;%reverse permutation
    perm_rand=randperm(B);%random permutation
    
    
    %%reverse buffer
    for i=u+1:B+u
        X_prev=X(:,u+perm_rev(i-u));
        X_curr=X(:,u+perm_rev(i-u)+1);
        
        
        A_curr_rev=A_prev_rev*(eye(d)-2*((sqrt(eta)*X_prev)*(sqrt(eta)*X_prev)'))...
            +2*((sqrt(eta)*X_curr)*(sqrt(eta)*X_prev)');
        
        if(2*eta*norm(X_prev)^2>1)
            disp('high step size!')
        end
        A_prev_rev=A_curr_rev;
        
    end
    A_buf_avg_ER_revBuf=((t-1)*A_buf_avg_ER_revBuf+A_curr_rev)/(t);%assuming that A0=0, avg is only from A_1 to A_T
    if(t>tavg_start)
        A_buf_tavg_ER_revBuf=((t-tavg_start-1)*A_buf_tavg_ER_revBuf+A_curr_rev)/(t-tavg_start);
    end
    
    op_norm_buf_tavg_ER_revBuf(t+(floor(n_samples_norm_est/(B+u))+1))...
        =norm(A_buf_tavg_ER_revBuf-A_true);
    op_norm_buf_avg_ER_revBuf(t+(floor(n_samples_norm_est/(B+u))+1))...
        =norm(A_buf_avg_ER_revBuf-A_true);
    
    
    %%rand buffer
    for i=u+1:B+u
        X_prev=X(:,u+perm_rand(i-u));
        X_curr=X(:,u+perm_rand(i-u)+1);
        
        
        A_curr_rand=A_prev_rand*(eye(d)-2*((sqrt(eta)*X_prev)*(sqrt(eta)*X_prev)'))...
            +2*((sqrt(eta)*X_curr)*(sqrt(eta)*X_prev)');
        
        A_prev_rand=A_curr_rand;

    end
    A_buf_avg_ER_randBuf=((t-1)*A_buf_avg_ER_randBuf+A_curr_rand)/(t);%assuming that A0=0, avg is only from A_1 to A_T
    if(t>tavg_start)
        A_buf_tavg_ER_randBuf=((t-tavg_start-1)*A_buf_tavg_ER_randBuf+A_curr_rand)/(t-tavg_start);
    end
    
    op_norm_buf_tavg_ER_randBuf(t+(floor(n_samples_norm_est/(B+u))+1))...
        =norm(A_buf_tavg_ER_randBuf-A_true);
    op_norm_buf_avg_ER_randBuf(t+(floor(n_samples_norm_est/(B+u))+1))...
        =norm(A_buf_avg_ER_randBuf-A_true);
    
    
    %%no buffer
    for i=1:B+u
        X_prev=X(:,i);
        X_curr=X(:,i+1);
        A_curr_noBuf=A_prev_noBuf*(eye(d)-2*((sqrt(eta)*X_prev)*(sqrt(eta)*X_prev)'))...
            +2*((sqrt(eta)*X_curr)*(sqrt(eta)*X_prev)');
        
        A_avg_ER_noBuf=(((t-1)*(B+u)+i-1)*A_avg_ER_noBuf+A_curr_noBuf)/((t-1)*(B+u)+i);%assuming that A0=0, avg is only from A_1 to A_T
        if((t-1)*(B+u)+i>floor((t-tavg_start)*(B+u)))
            A_tavg_ER_noBuf=((((t-1)*(B+u)+i)-floor((t-tavg_start)*(B+u))-1)*A_tavg_ER_noBuf+A_curr_noBuf)/...
                ((t-1)*(B+u)+i-floor((t-tavg_start)*(B+u)));
        end
        
        
        A_prev_noBuf=A_curr_noBuf;
        X1_sum=X1_sum+X(:,i)*(X(:,i))';
        X2_sum=X2_sum+X(:,i)*(X(:,i+1))';
        
    end
    
        op_norm_tavg_ER_noBuf(t+(floor(n_samples_norm_est/(B+u))+1))...
            =norm(A_tavg_ER_noBuf-A_true);
        op_norm_avg_ER_noBuf(t+(floor(n_samples_norm_est/(B+u))+1))...
            =norm(A_avg_ER_noBuf-A_true);
        
        diff=(X1_sum)\(X2_sum);
        A_ols=diff';
        op_norm_ols(t+(floor(n_samples_norm_est/(B+u))+1))...
            =norm(A_ols-A_true);
    
    
    X_prev=X(:,end);
    if(mod(t,1e4)==0)
        t
    end
end

end